/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.CounterOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.ICounterDelegator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class CounterDelegator
extends BaseDelegator
implements ICounterDelegator {
    public CounterDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String getCounter(String counterName) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getCounter(counterName, null);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String getCounter(String counterName, CounterOptions opts) throws P4JavaException {
        Validate.notBlank(counterName, "Counter name shouldn't be null or empty", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTER, Parameters.processParameters((Options)opts, null, new String[]{counterName}, (IServer)this.server), null);
        return ResultListBuilder.buildNullableObjectFromNonInfoMessageCommandResultMaps(resultMaps, map -> P4ResultMapUtils.parseString(map, "value"));
    }

    @Override
    public void setCounter(String counterName, String value, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        Validate.notBlank(counterName, "Counter name shouldn't be null or empty", new Object[0]);
        Validate.notBlank(value, "Counter value shouldn't be null or empty", new Object[0]);
        try {
            CounterOptions counterOptions = new CounterOptions().setPerforceCounter(perforceCounter);
            this.setCounter(counterName, value, counterOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String setCounter(String counterName, String value, CounterOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.COUNTER, Parameters.processParameters((Options)opts, null, new String[]{counterName, value}, (IServer)this.server), null);
        return ResultListBuilder.buildNullableObjectFromNonInfoMessageCommandResultMaps(resultMaps, map -> P4ResultMapUtils.parseString(map, "value"));
    }

    @Override
    public void deleteCounter(String counterName, boolean perforceCounter) throws ConnectionException, RequestException, AccessException {
        Validate.notBlank(counterName, "Counter name shouldn't null or empty", new Object[0]);
        try {
            CounterOptions counterOptions = new CounterOptions(perforceCounter, true, false);
            this.setCounter(counterName, null, counterOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

