/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class BaseDelegator {
    protected static int MAX_LIMIT_SUPPORTED_MIN_VERSION = 20061;
    protected static int USER_RESTRICTIONS_SUPPORTED_MIN_VERSION = 20062;
    protected static int QUERY_EXPRESSIONS_SUPPORTED_MIN_VERSION = 20082;
    final IOptionsServer server;

    BaseDelegator(IOptionsServer server) {
        this.server = server;
    }

    @Deprecated
    IFileSpec handleFileReturn(Map<String, Object> map, IClient client) throws AccessException, ConnectionException {
        if (map != null) {
            String errStr = this.server.handleFileErrorStr(map);
            if (StringUtils.isBlank(errStr)) {
                return new FileSpec(map, this.server, -1);
            }
            FileSpecOpStatus specOpStatus = FileSpecOpStatus.ERROR;
            if (this.server.isInfoMessage(map)) {
                specOpStatus = FileSpecOpStatus.INFO;
            }
            String codeStr = P4ResultMapUtils.parseCode0ErrorString(map);
            return new FileSpec(specOpStatus, errStr, codeStr);
        }
        return null;
    }

    List<Map<String, Object>> execMapCmdList(@Nonnull CmdSpec cmdSpec, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException, RequestException {
        Validate.notNull(cmdSpec);
        return this.server.execMapCmdList(cmdSpec.toString(), cmdArgs, inMap);
    }

    InputStream execStreamCmd(CmdSpec cmdSpec, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(cmdSpec);
        return this.server.execStreamCmd(cmdSpec.toString(), cmdArgs);
    }

    void checkMinSupportedPerforceVersion(String userName, int maxLimit, String queryString, String clientOrLabel) throws RequestException, ConnectionException {
        int serverVersion = this.server.getServerVersion();
        if (StringUtils.isNotBlank(userName)) {
            P4JavaExceptions.throwRequestExceptionIfPerforceServerVersionOldThanExpected(serverVersion >= USER_RESTRICTIONS_SUPPORTED_MIN_VERSION, "user restrictions '%s' for %s lists are not supported by this version of the Perforce server", userName, clientOrLabel);
        }
        if (maxLimit > 0) {
            P4JavaExceptions.throwRequestExceptionIfPerforceServerVersionOldThanExpected(serverVersion >= MAX_LIMIT_SUPPORTED_MIN_VERSION, "max limit '%s' for %s lists are not supported by this version of the Perforce server", maxLimit, clientOrLabel);
        }
        if (StringUtils.isNotBlank(queryString)) {
            P4JavaExceptions.throwRequestExceptionIfPerforceServerVersionOldThanExpected(serverVersion >= QUERY_EXPRESSIONS_SUPPORTED_MIN_VERSION, "query expressions '%s' for %s lists are not supported by this version of the Perforce server", queryString, clientOrLabel);
        }
    }
}

