/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.env.SystemInfo;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcCRC32Checksum;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInflaterOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcLineEndFilterOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.server.P4Charset;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.Inflater;

public class RpcOutputStream
extends FileOutputStream {
    private static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int TRAILER_SIZE = 8;
    private RpcPerforceFile file = null;
    private RpcPerforceFileType fileType = null;
    private RpcInflaterOutputStream outStream = null;
    private CheckedOutputStream checkedOutStream = null;
    private Inflater inflater = null;
    private RpcCRC32Checksum crc = null;
    private boolean headerRead = false;
    private byte[] footerBytes = null;
    private boolean closed = false;
    private boolean writeUtf8Bom = false;
    private ClientLineEnding lineEnding = null;
    private RpcLineEndFilterOutputStream lineEndStream = null;
    private CharsetConverter converter = null;
    private String serverDigest = null;
    private MD5Digester localDigester = null;
    private ByteArrayOutputStream tempBufferToStoreCompressedBytes;
    private int len = 0;
    private int start = 0;

    public static RpcOutputStream getTmpOutputStream(RpcPerforceFile file) throws IOException {
        return new RpcOutputStream(file, null, false, false, 1);
    }

    public RpcOutputStream(RpcPerforceFile file, RpcConnection rpcConnection, boolean useLocalDigester) throws IOException {
        this(file, rpcConnection.getP4Charset(), rpcConnection.isUnicodeServer(), useLocalDigester, rpcConnection.getFilesysUtf8bom());
    }

    private RpcOutputStream(RpcPerforceFile file, P4Charset p4Charset, boolean isUnicodeServer, boolean useLocalDigester, int filesys_utf8bom) throws IOException {
        super(file);
        Charset charset;
        if (file == null) {
            throw new NullPointerError("Null RpcPerforceFile passed to RpcOutputStream constructor");
        }
        if (useLocalDigester) {
            this.localDigester = new MD5Digester();
        }
        Charset converterCharset = null;
        this.fileType = file.getFileType();
        if (p4Charset != null && (charset = p4Charset.getCharset()) != null && !this.fileType.equals((Object)RpcPerforceFileType.FST_XUTF8) && !this.fileType.equals((Object)RpcPerforceFileType.FST_UTF8)) {
            converterCharset = isUnicodeServer && !charset.equals(CharsetDefs.UTF8) ? charset : null;
        }
        this.closed = false;
        this.file = file;
        this.lineEnding = file.getLineEnding();
        this.writeUtf8Bom = false;
        if (this.fileType != null) {
            switch (this.fileType) {
                case FST_UTF16: 
                case FST_XUTF16: 
                case FST_UTF16_GUNZIP: 
                case FST_XUTF16_GUNZIP: {
                    converterCharset = CharsetDefs.UTF16;
                }
                case FST_UTF8: 
                case FST_XUTF8: 
                case FST_UTF8_GUNZIP: 
                case FST_XUTF8_GUNZIP: {
                    boolean addBOM = filesys_utf8bom == 1 || filesys_utf8bom == 2 && SystemInfo.isWindows();
                    this.writeUtf8Bom = converterCharset == null && addBOM;
                }
                case FST_UNICODE: 
                case FST_XUNICODE: 
                case FST_UNICODE_GUNZIP: 
                case FST_XUNICODE_GUNZIP: {
                    if (converterCharset != null && (isUnicodeServer || converterCharset == CharsetDefs.UTF16)) {
                        this.converter = new CharsetConverter(CharsetDefs.UTF8, converterCharset);
                    }
                    this.writeUtf8Bom |= p4Charset != null && p4Charset.isClientBOM();
                }
                case FST_TEXT: 
                case FST_XTEXT: 
                case FST_TEXT_GUNZIP: 
                case FST_XTEXT_GUNZIP: {
                    if (ClientLineEnding.needsLineEndFiltering(this.lineEnding)) {
                        this.lineEndStream = new RpcLineEndFilterOutputStream(this, this.lineEnding);
                    }
                    this.inflater = new Inflater(true);
                    this.crc = new RpcCRC32Checksum();
                    this.tempBufferToStoreCompressedBytes = new ByteArrayOutputStream();
                    this.checkedOutStream = new CheckedOutputStream(this.tempBufferToStoreCompressedBytes, this.crc);
                    this.outStream = new RpcInflaterOutputStream(this.checkedOutStream, this.inflater, this.localDigester);
                    this.headerRead = false;
                    this.footerBytes = new byte[8];
                    break;
                }
                case FST_BINARY_GUNZIP: 
                case FST_XBINARY_GUNZIP: 
                case FST_SYMLINK_GUNZIP: 
                case FST_RESOURCE_GUNZIP: 
                case FST_XSYMLINK_GUNZIP: 
                case FST_XRESOURCE_GUNZIP: 
                case FST_RTEXT_GUNZIP: 
                case FST_XRTEXT_GUNZIP: 
                case FST_APPLETEXT_GUNZIP: 
                case FST_APPLEFILE_GUNZIP: 
                case FST_XAPPLETEXT_GUNZIP: 
                case FST_XAPPLEFILE_GUNZIP: 
                case FST_GUNZIP: 
                case FST_XGUNZIP: {
                    this.inflater = new Inflater(true);
                    this.crc = new RpcCRC32Checksum();
                    this.checkedOutStream = new CheckedOutputStream(new BufferedOutputStream(this), this.crc);
                    this.outStream = new RpcInflaterOutputStream(this.checkedOutStream, this.inflater, this.localDigester);
                    this.headerRead = false;
                    this.footerBytes = new byte[8];
                    break;
                }
            }
        } else {
            this.fileType = RpcPerforceFileType.FST_TEXT;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            switch (this.fileType) {
                case FST_UTF16_GUNZIP: 
                case FST_XUTF16_GUNZIP: 
                case FST_UTF8_GUNZIP: 
                case FST_XUTF8_GUNZIP: 
                case FST_UNICODE_GUNZIP: 
                case FST_XUNICODE_GUNZIP: 
                case FST_TEXT_GUNZIP: 
                case FST_XTEXT_GUNZIP: {
                    this.readTrailer(this.footerBytes);
                    this.outStream.close();
                    this.checkedOutStream.close();
                }
                case FST_UTF16: 
                case FST_XUTF16: 
                case FST_UTF8: 
                case FST_XUTF8: 
                case FST_UNICODE: 
                case FST_XUNICODE: 
                case FST_TEXT: 
                case FST_XTEXT: {
                    if (this.lineEndStream == null) break;
                    this.lineEndStream.close();
                    break;
                }
                case FST_BINARY_GUNZIP: 
                case FST_XBINARY_GUNZIP: 
                case FST_SYMLINK_GUNZIP: 
                case FST_RESOURCE_GUNZIP: 
                case FST_XSYMLINK_GUNZIP: 
                case FST_XRESOURCE_GUNZIP: 
                case FST_RTEXT_GUNZIP: 
                case FST_XRTEXT_GUNZIP: 
                case FST_APPLETEXT_GUNZIP: 
                case FST_APPLEFILE_GUNZIP: 
                case FST_XAPPLETEXT_GUNZIP: 
                case FST_XAPPLEFILE_GUNZIP: 
                case FST_GUNZIP: 
                case FST_XGUNZIP: {
                    this.readTrailer(this.footerBytes);
                    this.outStream.close();
                    this.checkedOutStream.close();
                    break;
                }
            }
            super.close();
        }
    }

    public long write(Map<String, Object> map) throws IOException, FileDecoderException, FileEncoderException {
        if (map == null) {
            throw new NullPointerError("Null map passed to RpcOutputStream.write(map)");
        }
        try {
            byte[] sourceBytes = (byte[])map.get("data");
            return this.writeConverted(sourceBytes);
        }
        catch (ClassCastException exc) {
            throw new P4JavaError("RpcFunctionMapKey.DATA value not byte[] type");
        }
    }

    @Override
    public void write(byte[] sourceBytes, int off, int len) throws IOException {
        if (sourceBytes == null) {
            throw new NullPointerError("Null bytes passed to RpcOutputStream.write()");
        }
        if (off < 0) {
            throw new P4JavaError("Negative offset in RpcOutputStream.write()");
        }
        if (len < 0) {
            throw new P4JavaError("Negative length in RpcOutputStream.write()");
        }
        super.write(sourceBytes, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerError("Null bytes passed to RpcOutputStream.write()");
        }
        super.write(b, 0, b.length);
    }

    public long writeConverted(byte[] sourceBytes) throws IOException, FileDecoderException, FileEncoderException {
        this.len = sourceBytes.length;
        this.start = 0;
        int bom = 0;
        if (this.writeUtf8Bom) {
            this.write(new byte[]{-17, -69, -65}, 0, 3);
            bom = 3;
            this.writeUtf8Bom = false;
        }
        if (this.len <= 0) {
            return 0L;
        }
        long bytesWritten = this.len + bom - this.start;
        switch (this.fileType) {
            case FST_UTF16: 
            case FST_XUTF16: 
            case FST_UNICODE: 
            case FST_XUNICODE: {
                if (this.converter != null) {
                    if (this.localDigester != null) {
                        this.localDigester.update(sourceBytes);
                    }
                    sourceBytes = this.convertLineEnding(sourceBytes);
                    sourceBytes = this.convertCharset(sourceBytes);
                    if (this.len <= 0) {
                        return 0L;
                    }
                    this.write(sourceBytes, this.start, this.len);
                    bytesWritten = this.len + bom - this.start;
                    break;
                }
            }
            case FST_UTF8: 
            case FST_XUTF8: 
            case FST_TEXT: 
            case FST_XTEXT: {
                if (this.localDigester != null) {
                    this.localDigester.update(sourceBytes, this.start, this.len);
                }
                if (this.lineEndStream != null) {
                    this.lineEndStream.write(sourceBytes, this.start, this.len);
                } else {
                    this.write(sourceBytes, this.start, this.len);
                }
                bytesWritten = this.len + bom - this.start;
                break;
            }
            case FST_UTF16_GUNZIP: 
            case FST_XUTF16_GUNZIP: 
            case FST_UNICODE_GUNZIP: 
            case FST_XUNICODE_GUNZIP: {
                sourceBytes = this.decompressSourceBytes(sourceBytes);
                if (this.converter != null) {
                    sourceBytes = this.convertLineEnding(sourceBytes);
                    sourceBytes = this.convertCharset(sourceBytes);
                    if (this.len <= 0) {
                        return 0L;
                    }
                    this.write(sourceBytes, this.start, this.len);
                    bytesWritten = this.len + bom - this.start;
                    break;
                }
            }
            case FST_UTF8_GUNZIP: 
            case FST_XUTF8_GUNZIP: 
            case FST_TEXT_GUNZIP: 
            case FST_XTEXT_GUNZIP: {
                sourceBytes = this.decompressSourceBytes(sourceBytes);
                if (this.lineEndStream != null) {
                    this.lineEndStream.write(sourceBytes, this.start, this.len);
                } else {
                    this.write(sourceBytes, this.start, this.len);
                }
                bytesWritten = this.len + bom - this.start;
                break;
            }
            case FST_BINARY_GUNZIP: 
            case FST_XBINARY_GUNZIP: 
            case FST_SYMLINK_GUNZIP: 
            case FST_RESOURCE_GUNZIP: 
            case FST_XSYMLINK_GUNZIP: 
            case FST_XRESOURCE_GUNZIP: 
            case FST_RTEXT_GUNZIP: 
            case FST_XRTEXT_GUNZIP: 
            case FST_APPLETEXT_GUNZIP: 
            case FST_APPLEFILE_GUNZIP: 
            case FST_XAPPLETEXT_GUNZIP: 
            case FST_XAPPLEFILE_GUNZIP: 
            case FST_GUNZIP: 
            case FST_XGUNZIP: {
                long bytesWrittenPrior = this.decompress(sourceBytes, this.len);
                bytesWritten = this.outStream.getBytesWritten() - bytesWrittenPrior;
                break;
            }
            default: {
                if (this.localDigester != null) {
                    this.localDigester.update(sourceBytes, 0, this.len);
                }
                this.write(sourceBytes, 0, this.len);
                bytesWritten = this.len + bom - 0;
            }
        }
        return bytesWritten;
    }

    private byte[] decompressSourceBytes(byte[] sourceBytes) throws IOException {
        this.decompress(sourceBytes, this.len);
        byte[] uncompressedBytes = this.tempBufferToStoreCompressedBytes.toByteArray();
        this.len = uncompressedBytes.length;
        this.tempBufferToStoreCompressedBytes.close();
        return uncompressedBytes;
    }

    private byte[] convertCharset(byte[] sourceBytes) throws FileDecoderException, FileEncoderException {
        ByteBuffer sourceBuffer = ByteBuffer.wrap(sourceBytes);
        ByteBuffer converted = this.converter.convert(sourceBuffer);
        if (converted != null) {
            sourceBytes = converted.array();
            this.start = converted.position();
            this.len = converted.limit();
        } else {
            this.len = 0;
        }
        return sourceBytes;
    }

    private byte[] convertLineEnding(byte[] sourceBytes) throws IOException {
        if (this.lineEndStream != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
            this.lineEndStream.write(out, sourceBytes, this.start, this.len);
            sourceBytes = out.toByteArray();
            this.len = sourceBytes.length;
            this.start = 0;
        }
        return sourceBytes;
    }

    private long decompress(byte[] sourceBytes, int len) throws IOException {
        long bytesWrittenPrior = this.outStream.getBytesWritten();
        if (!this.headerRead) {
            int bytesAvailable;
            try (ByteArrayInputStream byteStream = new ByteArrayInputStream(sourceBytes, 0, len);){
                this.readHeader(byteStream, new RpcCRC32Checksum());
                this.headerRead = true;
                bytesAvailable = byteStream.available();
            }
            if (bytesAvailable > 0) {
                this.outStream.write(sourceBytes, len - bytesAvailable, bytesAvailable);
                if (bytesAvailable >= 8) {
                    System.arraycopy(sourceBytes, len - 8, this.footerBytes, 0, 8);
                } else {
                    System.arraycopy(sourceBytes, len - bytesAvailable, this.footerBytes, 0, bytesAvailable);
                }
            }
        } else {
            this.outStream.write(sourceBytes, 0, len);
            if (len >= 8) {
                System.arraycopy(sourceBytes, len - 8, this.footerBytes, 0, 8);
            } else {
                System.arraycopy(this.footerBytes, len, this.footerBytes, 0, 8 - len);
                System.arraycopy(sourceBytes, 0, this.footerBytes, 8 - len, len);
            }
        }
        return bytesWrittenPrior;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
    }

    public RpcPerforceFile getFile() {
        return this.file;
    }

    private void readHeader(InputStream inStream, RpcCRC32Checksum crc) throws IOException {
        CheckedInputStream in = new CheckedInputStream(inStream, crc);
        crc.reset();
        if (this.readUShort(in) != 35615) {
            throw new IOException("Not in GZIP format");
        }
        if (this.readUByte(in) != 8) {
            throw new IOException("Unsupported compression method");
        }
        int flg = this.readUByte(in);
        this.skipBytes(in, 6);
        if ((flg & 4) == 4) {
            this.skipBytes(in, this.readUShort(in));
        }
        if ((flg & 8) == 8) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 0x10) == 16) {
            while (this.readUByte(in) != 0) {
            }
        }
        if ((flg & 2) == 2) {
            int v = (int)crc.getValue() & 0xFFFF;
            if (this.readUShort(in) != v) {
                throw new IOException("Corrupt GZIP header");
            }
        }
    }

    private void readTrailer(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        long intIn = this.readUInt(in);
        long len = this.readUInt(in);
        Checksum checksum = this.checkedOutStream.getChecksum();
        if (checksum != null && intIn != checksum.getValue()) {
            throw new IOException("Corrupt GZIP trailer (bad CRC value)");
        }
        if (len != (this.inflater.getBytesWritten() & 0xFFFFFFFFL)) {
            throw new IOException("Corrupt GZIP trailer (bad bytes-written size)");
        }
    }

    private long readUInt(InputStream in) throws IOException {
        long s2 = this.readUShort(in);
        return (long)this.readUShort(in) << 16 | s2;
    }

    private int readUShort(InputStream in) throws IOException {
        int b = this.readUByte(in);
        return this.readUByte(in) << 8 | b;
    }

    private int readUByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        if (b < -1 || b > 255) {
            throw new IOException(".read() returned value out of range -1..255: " + b);
        }
        return b;
    }

    private void skipBytes(InputStream in, int n) throws IOException {
        byte[] tmpbuf = new byte[128];
        while (n > 0) {
            int len = in.read(tmpbuf, 0, n < tmpbuf.length ? n : tmpbuf.length);
            if (len == -1) {
                throw new EOFException("Unexpected EOF");
            }
            n -= len;
        }
    }

    public String getServerDigest() {
        return this.serverDigest;
    }

    public void setServerDigest(String serverDigest) {
        this.serverDigest = serverDigest;
    }

    public MD5Digester getLocalDigester() {
        return this.localDigester;
    }

    public void setLocalDigester(MD5Digester localDigester) {
        this.localDigester = localDigester;
    }
}

