/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.env.PerforceEnvironment;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.exception.TrustException;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientTrust;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.PerformanceMonitor;
import com.perforce.p4java.impl.mapbased.rpc.helper.RpcUserAuthCounter;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.helper.RpcPacketFieldRule;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcStreamConnection;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.messages.PerforceMessages;
import com.perforce.p4java.option.UsageOptions;
import com.perforce.p4java.option.server.TrustOptions;
import com.perforce.p4java.server.AuthTicketsHelper;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.Fingerprint;
import com.perforce.p4java.server.FingerprintsHelper;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.IServerImplMetadata;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.P4Charset;
import com.perforce.p4java.server.ServerStatus;
import com.perforce.p4java.util.PropertiesHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class RpcServer
extends Server {
    public static final IServerImplMetadata.ImplType IMPL_TYPE = IServerImplMetadata.ImplType.NATIVE_RPC;
    public static final String DEFAULT_PROG_NAME = "p4jrpc";
    public static final String DEFAULT_PROG_VERSION = "Beta 1.0";
    public static final int DEFAULT_CLIENT_API_LEVEL = 92;
    public static final int DEFAULT_SERVER_API_LEVEL = 99999;
    public static final boolean RPC_TAGS_USED = true;
    public static final boolean RPC_ENABLE_STREAMS = true;
    public static final String RPC_ENV_CWD_KEY = "user.dir";
    public static final String RPC_ENV_OS_NAME_KEY = "os.name";
    public static final String RPC_ENV_WINDOWS_PREFIX = "windows";
    public static final String RPC_ENV_WINDOWS_SPEC = "NT";
    public static final String RPC_ENV_UNIX_SPEC = "UNIX";
    public static final String RPC_ENV_NOCLIENT_SPEC = "unknownclient";
    public static final String RPC_ENV_NOHOST_SPEC = "nohost";
    public static final String RPC_ENV_NOUSER_SPEC = "nouser";
    public static final String TRACE_PREFIX = "RpcServer";
    public static final String RPC_TMP_OUTFILE_STREAM_KEY = "";
    public static final String RPC_TMP_CONVERTER_KEY = "RPC_TMP_CONVERTER_KEY";
    private static final String AUTH_FAIL_STRING_1 = "Single sign-on on client failed";
    private static final String AUTH_FAIL_STRING_2 = "Password invalid";
    private static final String[] ACCESS_ERROR_MSGS = new String[]{"Perforce password (P4PASSWD)", "Access for user", "Your session has expired", "Your session was logged out", "Single sign-on on client failed", "Password invalid"};
    private static final String PASSWORD_NOT_SET_STRING = "no password set for this user";
    protected String localHostName = null;
    protected int clientApiLevel = 92;
    protected int serverApiLevel = 99999;
    protected String applicationName = null;
    protected long connectionStart = 0L;
    protected Map<String, Object> serverProtocolMap = new HashMap<String, Object>();
    protected ServerStats serverStats = null;
    protected String serverId = null;
    protected Map<String, String> secretKeys = new HashMap<String, String>();
    protected Map<String, String> pBufs = new HashMap<String, String>();
    protected ClientTrust clientTrust = null;
    protected String ticketsFilePath = null;
    protected String trustFilePath = null;
    protected boolean validatedByChain = false;
    protected boolean validatedByFingerprint = false;
    protected boolean validatedByHostname = false;
    protected int authFileLockTry = 0;
    protected long authFileLockDelay = 0L;
    protected long authFileLockWait = 0L;
    protected RpcUserAuthCounter authCounter = new RpcUserAuthCounter();
    protected IServerAddress rpcServerAddress = null;
    protected Map<String, Object> cmdMapArgs = null;
    protected boolean relaxCmdNameValidationChecks = false;
    private PerformanceMonitor perfMonitor = new PerformanceMonitor();

    public boolean isValidatedByChain() {
        if (!this.isSecure()) {
            return false;
        }
        return this.validatedByChain;
    }

    public boolean isValidatedByFingerprint() {
        if (!this.isSecure()) {
            return false;
        }
        return this.validatedByFingerprint;
    }

    public boolean isValidatedByHostname() {
        if (!this.isSecure()) {
            return false;
        }
        return this.validatedByHostname;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public RpcUserAuthCounter getAuthCounter() {
        return this.authCounter;
    }

    public int getClientApiLevel() {
        return this.clientApiLevel;
    }

    public void setClientApiLevel(int clientApiLevel) {
        this.clientApiLevel = clientApiLevel;
    }

    public PerformanceMonitor getPerfMonitor() {
        return this.perfMonitor;
    }

    public void setPerfMonitor(PerformanceMonitor perfMonitor) {
        this.perfMonitor = perfMonitor;
    }

    public IServerAddress getRpcServerAddress() {
        return this.rpcServerAddress;
    }

    public void setRpcServerAddress(IServerAddress rpcServerAddress) {
        this.rpcServerAddress = rpcServerAddress;
    }

    public String getServerAddress() {
        String serverAddress = this.serverAddress;
        if (StringUtils.isBlank(serverAddress)) {
            serverAddress = this.getServerHostPort();
        }
        return serverAddress;
    }

    public String getServerHostPort() {
        String serverHostPort = null;
        if (StringUtils.isNotBlank(this.serverHost)) {
            serverHostPort = this.serverHost;
            if (this.serverPort != -1) {
                serverHostPort = serverHostPort + ":" + String.valueOf(this.serverPort);
            }
        } else if (this.serverPort != -1) {
            serverHostPort = String.valueOf(this.serverPort);
        }
        return serverHostPort;
    }

    public Charset getClientCharset() {
        if (this.p4Charset == null) {
            return null;
        }
        return this.p4Charset.getCharset();
    }

    public boolean isServerUnicode() {
        return P4Charset.isUnicodeServer(this.p4Charset);
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Override
    public String getTicketsFilePath() {
        return this.ticketsFilePath;
    }

    @Override
    public void setTicketsFilePath(String ticketsFilePath) {
        Validate.notBlank(ticketsFilePath, "ticketsFilePath shouldn't null or empty", new Object[0]);
        this.ticketsFilePath = ticketsFilePath;
    }

    @Override
    public String getTrustFilePath() {
        return this.trustFilePath;
    }

    @Override
    public void setTrustFilePath(String trustFilePath) {
        Validate.notBlank(trustFilePath, "ticketsFilePath shouldn't null or empty", new Object[0]);
        this.trustFilePath = trustFilePath;
    }

    protected boolean isRelaxCmdNameValidationChecks() {
        return this.relaxCmdNameValidationChecks;
    }

    protected void setRelaxCmdNameValidationChecks(boolean relaxCmdNameValidationChecks) {
        this.relaxCmdNameValidationChecks = relaxCmdNameValidationChecks;
    }

    private boolean isClusterMember() {
        return this.serverInfo != null && this.serverInfo.getServerCluster() != null;
    }

    @Override
    @Deprecated
    public boolean isAuthFail(String errStr) {
        return ResultMapParser.isAuthFail(errStr);
    }

    @Override
    @Deprecated
    public String getInfoStr(Map<String, Object> map) {
        return ResultMapParser.getInfoStr(map);
    }

    @Override
    @Deprecated
    public boolean isInfoMessage(Map<String, Object> map) {
        return ResultMapParser.isInfoMessage(map);
    }

    @Override
    @Deprecated
    public String getErrorStr(Map<String, Object> map) {
        return ResultMapParser.getErrorStr(map);
    }

    @Override
    @Deprecated
    public void setAuthTicket(String userName, String authTicket) {
        this.setAuthTicket(userName, null, authTicket);
    }

    @Override
    public void setAuthTicket(String userName, String serverId, String authTicket) {
        String serverAddress;
        Validate.notBlank(userName, "Null or empty userName passed to the setAuthTicket method.", new Object[0]);
        String lowerCaseableUserName = userName;
        if (!this.isCaseSensitive() && StringUtils.isNotBlank(userName)) {
            lowerCaseableUserName = userName.toLowerCase();
        }
        if (StringUtils.isBlank(serverAddress = serverId)) {
            serverAddress = StringHelper.firstNonBlank(this.getServerId(), this.getServerAddress());
            if (this.isClusterMember()) {
                serverAddress = this.serverInfo.getServerCluster();
            }
            Validate.notBlank(serverAddress, "Null serverAddress in the setAuthTicket method.", new Object[0]);
        }
        if (StringUtils.isBlank(authTicket)) {
            this.authTickets.remove(this.composeAuthTicketEntryKey(lowerCaseableUserName, serverAddress));
        } else {
            this.authTickets.put(this.composeAuthTicketEntryKey(lowerCaseableUserName, serverAddress), authTicket);
        }
    }

    @Override
    public String getTrust() throws P4JavaException {
        String string;
        RpcStreamConnection rpcConnection = null;
        try {
            rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.p4Charset, this.secure);
            string = rpcConnection.getFingerprint();
        }
        catch (Throwable throwable) {
            this.closeQuietly(rpcConnection);
            throw throwable;
        }
        this.closeQuietly(rpcConnection);
        return string;
    }

    @Override
    public String addTrust(TrustOptions opts) throws P4JavaException {
        return this.addTrust(null, opts);
    }

    @Override
    public String addTrust(String fingerprintValue) throws P4JavaException {
        Validate.notBlank(fingerprintValue, "fingerprintValue shouldn't null or empty", new Object[0]);
        return this.addTrust(fingerprintValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addTrust(String fingerprintValue, TrustOptions options) throws P4JavaException {
        PerforceMessages messages;
        RpcStreamConnection rpcConnection;
        block16: {
            String trustAddedInfo;
            String newFingerprint;
            String fingerprintUser;
            boolean fingerprintMatches;
            String serverIpPort;
            block15: {
                String newKeyWarning;
                TrustOptions opts;
                block14: {
                    boolean fingerprintExists;
                    String newConnectionWarning;
                    String serverHostPort;
                    String originalFingerprint;
                    block13: {
                        boolean fingerprintReplaceMatches;
                        boolean fingerprintReplaceExists;
                        block11: {
                            boolean fingerprintMatchesHost;
                            block12: {
                                String string;
                                rpcConnection = null;
                                try {
                                    rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.p4Charset, this.secure);
                                    opts = ObjectUtils.firstNonNull(options, new TrustOptions());
                                    if (StringUtils.isNotBlank(fingerprintValue)) {
                                        opts.setAutoAccept(true);
                                        opts.setForce(true);
                                    }
                                    originalFingerprint = rpcConnection.getFingerprint();
                                    messages = this.clientTrust.getMessages();
                                    serverHostPort = this.getServerHostPort();
                                    Object[] warningParams = new Object[]{serverHostPort, originalFingerprint};
                                    newConnectionWarning = messages.getMessage("client.trust.warning.newconnection", warningParams);
                                    newKeyWarning = messages.getMessage("client.trust.warning.newkey", warningParams);
                                    serverIpPort = ((RpcConnection)rpcConnection).getServerIpPort();
                                    fingerprintExists = this.fingerprintExists(serverIpPort, "**++**");
                                    fingerprintMatches = this.fingerprintMatches(serverIpPort, "**++**", originalFingerprint);
                                    fingerprintReplaceExists = this.fingerprintExists(serverIpPort, "++++++");
                                    fingerprintReplaceMatches = this.fingerprintMatches(serverIpPort, "++++++", originalFingerprint);
                                    boolean fingerprintExistsHost = this.fingerprintExists(serverHostPort, "**++**");
                                    fingerprintMatchesHost = this.fingerprintMatches(serverHostPort, "**++**", originalFingerprint);
                                    boolean fingerprintReplaceExistsHost = this.fingerprintExists(serverHostPort, "++++++");
                                    boolean fingerprintReplaceMatchesHost = this.fingerprintMatches(serverHostPort, "++++++", originalFingerprint);
                                    if (!opts.isAutoRefuse()) break block11;
                                    if (fingerprintExists || fingerprintExistsHost) break block12;
                                    string = newConnectionWarning;
                                }
                                catch (Throwable throwable) {
                                    this.closeQuietly(rpcConnection);
                                    throw throwable;
                                }
                                this.closeQuietly(rpcConnection);
                                return string;
                            }
                            if (fingerprintMatches || fingerprintMatchesHost) break block11;
                            String string = newKeyWarning;
                            this.closeQuietly(rpcConnection);
                            return string;
                        }
                        boolean established = this.checkAndUseReplacementFingerprint(serverIpPort, fingerprintExists, fingerprintMatches, fingerprintReplaceExists, fingerprintReplaceMatches, rpcConnection);
                        boolean establishedHost = this.checkAndUseReplacementFingerprint(serverHostPort, fingerprintExists, fingerprintMatches, fingerprintReplaceExists, fingerprintReplaceMatches, rpcConnection);
                        if (!established && !establishedHost) break block13;
                        String string = messages.getMessage("client.trust.alreadyestablished");
                        this.closeQuietly(rpcConnection);
                        return string;
                    }
                    fingerprintUser = StringHelper.firstConditionIsTrue(opts.isReplacement(), "++++++", "**++**");
                    newFingerprint = StringHelper.firstNonBlank(fingerprintValue, originalFingerprint);
                    trustAddedInfo = messages.getMessage("client.trust.added", new Object[]{serverHostPort, serverIpPort});
                    if (!this.installFingerprintIfNewConnection(fingerprintExists, rpcConnection, opts, fingerprintUser, newFingerprint)) break block14;
                    String string = newConnectionWarning + trustAddedInfo;
                    this.closeQuietly(rpcConnection);
                    return string;
                }
                if (!this.installNewFingerprintIfNewKey(fingerprintMatches, rpcConnection, opts, fingerprintUser, newFingerprint)) break block15;
                String string = newKeyWarning + trustAddedInfo;
                this.closeQuietly(rpcConnection);
                return string;
            }
            if (!fingerprintMatches || !StringUtils.isNotBlank(fingerprintValue)) break block16;
            int sslClientTrustName = RpcPropertyDefs.getPropertyAsInt(this.props, "secureClientCertValidate", 1);
            if (sslClientTrustName <= 1) {
                this.clientTrust.installFingerprint(serverIpPort, fingerprintUser, newFingerprint);
            }
            if (sslClientTrustName >= 1) {
                this.clientTrust.installFingerprint(this.getServerHostPort(), fingerprintUser, newFingerprint);
            }
            String string = trustAddedInfo;
            this.closeQuietly(rpcConnection);
            return string;
        }
        String string = messages.getMessage("client.trust.alreadyestablished");
        this.closeQuietly(rpcConnection);
        return string;
    }

    @Override
    public String removeTrust() throws P4JavaException {
        return this.removeTrust(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String removeTrust(TrustOptions opts) throws P4JavaException {
        String string;
        RpcStreamConnection rpcConnection = null;
        try {
            rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.p4Charset, this.secure);
            String fingerprintUser = StringHelper.firstConditionIsTrue(Objects.nonNull(opts) && opts.isReplacement(), "++++++", "**++**");
            String message = RPC_TMP_OUTFILE_STREAM_KEY;
            PerforceMessages messages = this.clientTrust.getMessages();
            String fingerprint = rpcConnection.getFingerprint();
            Object[] params = new Object[]{this.getServerHostPort(), fingerprint};
            String serverIpPort = ((RpcConnection)rpcConnection).getServerIpPort();
            if (!this.fingerprintExists(serverIpPort, "**++**")) {
                message = messages.getMessage("client.trust.warning.newconnection", params);
            } else if (!this.fingerprintMatches(serverIpPort, "**++**", fingerprint)) {
                message = messages.getMessage("client.trust.warning.newkey", params);
            }
            if (this.fingerprintExists(serverIpPort, fingerprintUser)) {
                this.clientTrust.removeFingerprint(serverIpPort, fingerprintUser);
                message = message + messages.getMessage("client.trust.removed", new Object[]{this.getServerHostPort(), serverIpPort});
            }
            if (this.fingerprintExists(this.getServerHostPort(), fingerprintUser)) {
                this.clientTrust.removeFingerprint(this.getServerHostPort(), fingerprintUser);
                message = message + (message.length() > 0 ? " " : RPC_TMP_OUTFILE_STREAM_KEY) + messages.getMessage("client.trust.removed", new Object[]{this.getServerHostPort(), this.getServerHostPort()});
            }
            string = message;
        }
        catch (Throwable throwable) {
            this.closeQuietly(rpcConnection);
            throw throwable;
        }
        this.closeQuietly(rpcConnection);
        return string;
    }

    @Override
    public List<Fingerprint> getTrusts() throws P4JavaException {
        return this.getTrusts(null);
    }

    @Override
    public List<Fingerprint> getTrusts(TrustOptions opts) throws P4JavaException {
        Fingerprint[] fingerprints = this.loadFingerprints();
        if (Objects.nonNull(fingerprints)) {
            ArrayList<Fingerprint> fingerprintsList = new ArrayList<Fingerprint>();
            ArrayList<Fingerprint> replacementsList = new ArrayList<Fingerprint>();
            for (Fingerprint fingerprint : fingerprints) {
                if (!Objects.nonNull(fingerprint) || !StringUtils.isNotBlank(fingerprint.getUserName())) continue;
                if ("++++++".equalsIgnoreCase(fingerprint.getUserName())) {
                    replacementsList.add(fingerprint);
                    continue;
                }
                fingerprintsList.add(fingerprint);
            }
            if (Objects.nonNull(opts) && opts.isReplacement()) {
                return replacementsList;
            }
            return fingerprintsList;
        }
        return Collections.emptyList();
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.connectionStart = System.currentTimeMillis();
        super.connect();
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        super.disconnect();
        if (this.connectionStart != 0L) {
            Log.stats("RPC connection connected for %s msec elapsed time", System.currentTimeMillis() - this.connectionStart);
        }
        this.serverStats.logStats();
        this.authCounter.clearCount();
    }

    @Override
    @Deprecated
    public String getAuthTicket(String userName) {
        return this.getAuthTicket(userName, null);
    }

    @Override
    public String getAuthTicket(String userName, String serverId) {
        String serverAddress;
        String lowerCaseableUserName = userName;
        if (!this.isCaseSensitive() && StringUtils.isNotBlank(userName)) {
            lowerCaseableUserName = userName.toLowerCase();
        }
        if (StringUtils.isBlank(serverAddress = serverId)) {
            serverAddress = StringHelper.firstNonBlank(this.getServerId(), this.getServerAddress());
            if (this.isClusterMember()) {
                serverAddress = this.serverInfo.getServerCluster();
            }
        }
        if (StringUtils.isNotBlank(lowerCaseableUserName) && StringUtils.isNotBlank(serverAddress)) {
            return (String)this.authTickets.get(this.composeAuthTicketEntryKey(lowerCaseableUserName, serverAddress));
        }
        return null;
    }

    @Override
    public boolean isLoginNotRequired(String msgStr) {
        return StringUtils.contains((CharSequence)msgStr, PASSWORD_NOT_SET_STRING);
    }

    @Override
    public boolean supportsSmartMove() throws ConnectionException, RequestException, AccessException {
        if (this.serverVersion < 20091) {
            return false;
        }
        IServerInfo info = this.getServerInfo();
        return Objects.nonNull(info) && !info.isMoveDisabled();
    }

    @Override
    public ServerStatus init(String host, int port, Properties properties, UsageOptions opts, boolean secure) throws ConfigException, ConnectionException {
        super.init(host, port, properties, opts, secure);
        try {
            this.cmdMapArgs = new HashMap<String, Object>();
            this.cmdMapArgs.put("tag", RPC_TMP_OUTFILE_STREAM_KEY);
            this.relaxCmdNameValidationChecks = RpcPropertyDefs.getPropertyAsBoolean(properties, "relaxCmdNameChecks", false);
            this.applicationName = RpcPropertyDefs.getProperty(properties, "applicationName");
            this.localHostName = StringUtils.isNotBlank(this.getUsageOptions().getHostName()) ? this.getUsageOptions().getHostName() : InetAddress.getLocalHost().getHostName();
            Validate.notBlank(this.localHostName, "Null or empty client host name in RPC connection init", new Object[0]);
            if (!this.useAuthMemoryStore) {
                this.ticketsFilePath = PropertiesHelper.getPropertyByKeys(this.props, "ticketPath", "com.perforce.p4java.ticketPath");
                if (StringUtils.isBlank(this.ticketsFilePath)) {
                    this.ticketsFilePath = PerforceEnvironment.getP4Tickets();
                }
                if (StringUtils.isBlank(this.ticketsFilePath)) {
                    this.ticketsFilePath = this.getDefaultP4TicketsFile();
                }
                this.trustFilePath = PropertiesHelper.getPropertyByKeys(this.props, "trustPath", "com.perforce.p4java.trustPath");
                if (StringUtils.isBlank(this.trustFilePath)) {
                    this.trustFilePath = PerforceEnvironment.getP4Trust();
                }
                if (StringUtils.isBlank(this.trustFilePath)) {
                    this.trustFilePath = this.getDefaultP4TrustFile();
                }
            }
            this.serverStats = new ServerStats();
            this.authFileLockTry = PropertiesHelper.getPropertyAsInt(properties, new String[]{"authFileLockTry", "com.perforce.p4java.authFileLockTry"}, 100);
            this.authFileLockDelay = PropertiesHelper.getPropertyAsLong(properties, new String[]{"authFileLockDelay", "com.perforce.p4java.authFileLockDelay"}, 300000L);
            this.authFileLockWait = PropertiesHelper.getPropertyAsLong(properties, new String[]{"authFileLockWait", "com.perforce.p4java.authFileLockWait"}, 1L);
        }
        catch (UnknownHostException uhe) {
            throw new ConfigException("Unable to determine client host name: %s" + uhe.getLocalizedMessage());
        }
        this.clientTrust = new ClientTrust(this);
        return this.status;
    }

    @Override
    public ServerStatus init(String host, int port, Properties props, UsageOptions opts) throws ConfigException, ConnectionException {
        return this.init(host, port, props, opts, false);
    }

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        return this.init(host, port, props, null);
    }

    private boolean checkAndUseReplacementFingerprint(String serverKey, boolean fingerprintExists, boolean fingerprintMatches, boolean fingerprintReplaceExists, boolean fingerprintReplaceMatches, RpcConnection rpcConnection) throws TrustException {
        if ((!fingerprintExists || !fingerprintMatches) && fingerprintReplaceExists && fingerprintReplaceMatches) {
            this.clientTrust.installFingerprint(serverKey, "**++**", rpcConnection.getFingerprint());
            this.clientTrust.removeFingerprint(serverKey, "++++++");
            return true;
        }
        return false;
    }

    public void trustConnectionCheck(RpcConnection rpcConnection) throws ConnectionException {
        int sslCertMethod = RpcPropertyDefs.getPropertyAsInt(this.props, "secureClientCertValidate", 1);
        if (sslCertMethod < 0 || sslCertMethod > 2) {
            sslCertMethod = 1;
        }
        if (!rpcConnection.isSelfSigned() && rpcConnection.getServerCerts().length >= 2 && sslCertMethod == 1) {
            try {
                ClientTrust.validateServerChain(rpcConnection.getServerCerts(), this.getServerHostPort().split(":")[0]);
                this.validatedByChain = true;
                return;
            }
            catch (Exception ce) {
                boolean bl = ce instanceof CertificateException;
            }
        } else if (!rpcConnection.isSelfSigned() && rpcConnection.getServerCerts().length >= 2 && sslCertMethod == 2) {
            X509Certificate[] certs = rpcConnection.getServerCerts();
            try {
                ClientTrust.verifyCertificateSubject(certs[0], this.serverHost);
                this.validatedByHostname = true;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.checkFingerprint(rpcConnection);
        this.validatedByFingerprint = rpcConnection.isTrusted();
    }

    protected void checkFingerprint(RpcConnection rpcConnection) throws ConnectionException {
        if (Objects.nonNull(rpcConnection) && rpcConnection.isSecure() && !rpcConnection.isTrusted()) {
            try {
                if (rpcConnection.getServerCerts().length > 0) {
                    ClientTrust.verifyCertificateDates(rpcConnection.getServerCerts()[0]);
                }
            }
            catch (CertificateException e) {
                throw new ConnectionException(e);
            }
            String fingerprint = rpcConnection.getFingerprint();
            P4JavaExceptions.throwConnectionExceptionIfConditionFails(StringUtils.isNotBlank(fingerprint), "Null fingerprint for this Perforce SSL connection", new Object[0]);
            String serverIpPort = rpcConnection.getServerIpPort();
            boolean fingerprintExists = this.fingerprintExists(serverIpPort, "**++**");
            boolean fingerprintReplaceExist = this.fingerprintExists(serverIpPort, "++++++");
            boolean fingerprintMatches = this.clientTrust.fingerprintMatches(serverIpPort, "**++**", fingerprint);
            boolean fingerprintReplaceMatches = this.fingerprintMatches(serverIpPort, "++++++", fingerprint);
            boolean isNotEstablished = !fingerprintExists && !fingerprintReplaceExist || !fingerprintExists && !fingerprintReplaceMatches;
            String serverHost = this.getServerHostPort();
            boolean fingerprintExistsHost = this.fingerprintExists(serverHost, "**++**");
            boolean fingerprintReplaceExistHost = this.fingerprintExists(serverHost, "++++++");
            boolean fingerprintMatchesHost = this.clientTrust.fingerprintMatches(serverHost, "**++**", fingerprint);
            boolean fingerprintReplaceMatchesHost = this.fingerprintMatches(serverHost, "++++++", fingerprint);
            boolean isNotEstablishedHost = !fingerprintExistsHost && !fingerprintReplaceExistHost || !fingerprintExistsHost && !fingerprintReplaceMatchesHost;
            this.throwTrustExceptionIfConditionIsTrue(isNotEstablished && isNotEstablishedHost, rpcConnection, TrustException.Type.NEW_CONNECTION, "client.trust.warning.notestablished", "client.trust.exception.newconnection");
            boolean isNewKey = !fingerprintMatches && !fingerprintReplaceMatches;
            boolean isNewKeyHost = !fingerprintMatchesHost && !fingerprintReplaceMatchesHost;
            this.throwTrustExceptionIfConditionIsTrue(isNewKey && isNewKeyHost, rpcConnection, TrustException.Type.NEW_KEY, "client.trust.warning.newkey", "client.trust.exception.newkey");
            if ((!fingerprintExists || !fingerprintMatches) && fingerprintReplaceExist && fingerprintReplaceMatches) {
                this.clientTrust.installFingerprint(serverIpPort, "**++**", fingerprint);
                this.clientTrust.removeFingerprint(serverIpPort, "++++++");
            }
            if ((!fingerprintExistsHost || !fingerprintMatchesHost) && fingerprintReplaceExistHost && fingerprintReplaceMatchesHost) {
                this.clientTrust.installFingerprint(serverHost, "**++**", fingerprint);
                this.clientTrust.removeFingerprint(serverHost, "++++++");
            }
            rpcConnection.setTrusted(true);
        }
    }

    private boolean fingerprintExists(String serverIpPort, String fingerprintUser) {
        return this.clientTrust.fingerprintExists(serverIpPort, fingerprintUser);
    }

    private boolean fingerprintMatches(String serverIpPort, String fingerprintUser, String fingerprint) {
        return this.clientTrust.fingerprintMatches(serverIpPort, fingerprintUser, fingerprint);
    }

    private void throwTrustExceptionIfConditionIsTrue(boolean expression, RpcConnection rpcConnection, TrustException.Type type, String warningMessageKey, String exceptionMessageKey) throws TrustException {
        if (expression) {
            this.throwTrustException(rpcConnection, type, warningMessageKey, exceptionMessageKey);
        }
    }

    private void closeQuietly(@Nullable RpcConnection rpcConnection) throws ConnectionException {
        if (Objects.nonNull(rpcConnection)) {
            rpcConnection.disconnect(null);
        }
    }

    protected String composeAuthTicketEntryKey(String userName, String serverAddress) {
        Validate.notBlank(userName, "Null userName passed to the composeAuthTicketEntryKey method.", new Object[0]);
        Validate.notBlank(serverAddress, "Null serverAddress passed to the composeAuthTicketEntryKey method.", new Object[0]);
        String wellFormedServerAddress = serverAddress;
        if (StringUtils.indexOf((CharSequence)serverAddress, 58) == -1) {
            wellFormedServerAddress = "localhost:" + serverAddress;
        }
        return wellFormedServerAddress + "=" + userName;
    }

    protected String getClientNameForEnv() {
        if (StringUtils.isNotBlank(this.clientName)) {
            return this.clientName;
        }
        return this.getUsageOptions().getUnsetClientName();
    }

    protected String getHostForEnv() {
        if (StringUtils.isNotBlank(this.localHostName)) {
            return this.localHostName;
        }
        return RPC_ENV_NOHOST_SPEC;
    }

    protected String getLanguageForEnv() {
        return this.getUsageOptions().getTextLanguage();
    }

    protected String getOsTypeForEnv() {
        String osName = System.getProperty(RPC_ENV_OS_NAME_KEY);
        if (StringUtils.isNotBlank(osName) && osName.toLowerCase(Locale.ENGLISH).contains(RPC_ENV_WINDOWS_PREFIX)) {
            return RPC_ENV_WINDOWS_SPEC;
        }
        return RPC_ENV_UNIX_SPEC;
    }

    protected RpcPacketFieldRule getRpcPacketFieldRule(Map<String, Object> inMap, CmdSpec cmdSpec) {
        Map cmdMap;
        if (Objects.nonNull(inMap) && Objects.nonNull((Object)cmdSpec) && cmdSpec == CmdSpec.EXPORT && inMap.containsKey(cmdSpec.toString()) && inMap.get(cmdSpec.toString()) instanceof Map && Objects.nonNull(cmdMap = (Map)inMap.remove(cmdSpec.toString()))) {
            return RpcPacketFieldRule.getInstance(cmdMap);
        }
        return null;
    }

    public String getSecretKey() {
        return this.getSecretKey(this.userName);
    }

    public void setSecretKey(String secretKey) {
        this.setSecretKey(this.userName, secretKey);
    }

    public String getSecretKey(String userName) {
        if (StringUtils.isNotBlank(userName)) {
            return this.secretKeys.get(userName);
        }
        return null;
    }

    public String getPBuf(String userName) {
        if (StringUtils.isNotBlank(userName)) {
            return this.pBufs.get(userName);
        }
        return null;
    }

    protected String getUserForEnv() {
        if (StringUtils.isNotBlank(this.userName)) {
            return this.userName;
        }
        return this.getUsageOptions().getUnsetUserName();
    }

    private boolean installFingerprintIfNewConnection(boolean fingerprintExists, RpcConnection rpcConnection, TrustOptions trustOptions, String fingerprintUser, String newFingerprint) throws TrustException {
        if (!fingerprintExists) {
            if (this.installNewFingerprintIfIsAutoAccept(rpcConnection, trustOptions, fingerprintUser, newFingerprint)) {
                return true;
            }
            this.throwTrustException(rpcConnection, TrustException.Type.NEW_CONNECTION, "client.trust.warning.newconnection", "client.trust.add.exception.newconnection");
        }
        return false;
    }

    private boolean installNewFingerprintIfNewKey(boolean fingerprintMatches, RpcConnection rpcConnection, TrustOptions trustOptions, String fingerprintUser, String newFingerprint) throws TrustException {
        if (!fingerprintMatches) {
            if (trustOptions.isForce() && this.installNewFingerprintIfIsAutoAccept(rpcConnection, trustOptions, fingerprintUser, newFingerprint)) {
                return true;
            }
            this.throwTrustException(rpcConnection, TrustException.Type.NEW_KEY, "client.trust.warning.newkey", "client.trust.add.exception.newkey");
        }
        return false;
    }

    private boolean installNewFingerprintIfIsAutoAccept(RpcConnection rpcConnection, TrustOptions trustOptions, String fingerprintUser, String newFingerprint) throws TrustException {
        if (trustOptions.isAutoAccept()) {
            String serverHostNamePort;
            int sslClientTrustName = RpcPropertyDefs.getPropertyAsInt(this.props, "secureClientCertValidate", 1);
            if (sslClientTrustName == 0 || sslClientTrustName == 1) {
                this.clientTrust.installFingerprint(rpcConnection.getServerIpPort(), fingerprintUser, newFingerprint);
            }
            if ((sslClientTrustName == 1 || sslClientTrustName == 2) && (serverHostNamePort = rpcConnection.getServerHostNamePort()) != null) {
                this.clientTrust.installFingerprint(serverHostNamePort, fingerprintUser, newFingerprint);
            }
            return true;
        }
        return false;
    }

    private void throwTrustException(RpcConnection rpcConnection, TrustException.Type type, String warningMessageKey, String exceptionMessageKey) throws TrustException {
        Object[] warningParams = new Object[]{this.getServerHostPort(), rpcConnection.getFingerprint()};
        String warningMessage = this.clientTrust.getMessages().getMessage(warningMessageKey, warningParams);
        String exceptionMessage = this.clientTrust.getMessages().getMessage(exceptionMessageKey);
        throw new TrustException(type, this.getServerHostPort(), rpcConnection.getServerIpPort(), rpcConnection.getFingerprint(), warningMessage + exceptionMessage);
    }

    public Fingerprint loadFingerprint(String serverKey, String fingerprintUser) {
        if (StringUtils.isBlank(serverKey) || StringUtils.isBlank(fingerprintUser)) {
            return null;
        }
        Fingerprint fingerprint = null;
        try {
            fingerprint = FingerprintsHelper.getFingerprint(fingerprintUser, serverKey, this.trustFilePath);
        }
        catch (IOException e) {
            Log.error(e.getMessage(), new Object[0]);
        }
        return fingerprint;
    }

    public Fingerprint[] loadFingerprints() {
        Fingerprint[] fingerprints = null;
        try {
            fingerprints = FingerprintsHelper.getFingerprints(this.trustFilePath);
        }
        catch (IOException e) {
            Log.error(e.getMessage(), new Object[0]);
        }
        return fingerprints;
    }

    @Nullable
    public String loadTicket(String serverId) {
        return this.loadTicket(serverId, this.getUserName());
    }

    public String loadTicket(String serverId, String name) {
        String ticketValue = null;
        if (StringUtils.isNotBlank(name) && StringUtils.isBlank(ticketValue = this.quietGetTicketValue(name, serverId))) {
            String server = this.getServerHostPort();
            ticketValue = this.quietGetTicketValue(name, server);
        }
        return ticketValue;
    }

    @Nullable
    private String quietGetTicketValue(String userName, String serverOrServerId) {
        String ticketValue = null;
        try {
            ticketValue = AuthTicketsHelper.getTicketValue(userName, serverOrServerId, this.ticketsFilePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ticketValue;
    }

    protected void processCmdCallbacks(int cmdCallBackKey, long timeTaken, List<Map<String, Object>> resultMaps) {
        this.commandCallback.completedServerCommand(cmdCallBackKey, timeTaken);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                String str = ResultMapParser.getErrorOrInfoStr(map);
                if (StringUtils.isNotBlank(str)) {
                    str = str.trim();
                }
                int severity = this.getSeverityCode(map);
                int generic2 = this.getGenericCode(map);
                if (severity != 0) {
                    this.commandCallback.receivedServerMessage(cmdCallBackKey, generic2, severity, str);
                }
                if (severity == 1) {
                    this.commandCallback.receivedServerInfoLine(cmdCallBackKey, str);
                    continue;
                }
                if (severity < 3) continue;
                this.commandCallback.receivedServerErrorLine(cmdCallBackKey, str);
            }
        }
    }

    @Override
    @Deprecated
    public String getErrorOrInfoStr(Map<String, Object> map) {
        return ResultMapParser.getErrorOrInfoStr(map);
    }

    @Override
    public int getSeverityCode(Map<String, Object> map) {
        if (Objects.nonNull(map) && map.containsKey("code0")) {
            return RpcMessage.getSeverity(P4ResultMapUtils.parseCode0ErrorString(map));
        }
        return 0;
    }

    @Override
    public int getGenericCode(Map<String, Object> map) {
        if (Objects.nonNull(map) && map.containsKey("code0")) {
            return RpcMessage.getGeneric(P4ResultMapUtils.parseCode0ErrorString(map));
        }
        return 0;
    }

    @Override
    public String getAuthId() {
        if (this.isClusterMember()) {
            return this.serverInfo.getServerCluster();
        }
        return this.getServerHostPort();
    }

    @Deprecated
    public void saveCurrentTicket() throws P4JavaException {
        this.saveTicket(this.getAuthTicket());
    }

    @Deprecated
    public void saveTicket(String ticketValue) throws ConfigException {
        this.saveTicket(this.getUserName(), null, ticketValue);
    }

    public void saveFingerprint(String serverIpPort, String fingerprintUser, String fingerprintValue) throws ConfigException {
        if (StringUtils.isBlank(serverIpPort) || StringUtils.isBlank(fingerprintUser)) {
            return;
        }
        try {
            FingerprintsHelper.saveFingerprint(fingerprintUser, serverIpPort, fingerprintValue, this.trustFilePath, this.authFileLockTry, this.authFileLockDelay, this.authFileLockWait);
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    public void saveTicket(String userName, String serverId, String ticketValue) throws ConfigException {
        String lowerCaseableUserName = this.getLowerCaseableUserName(userName);
        String serId = StringUtils.isNotBlank(serverId) ? serverId : this.getServerId();
        ConfigException exception = this.quietSaveTicket(serId, lowerCaseableUserName, ticketValue, null);
        if (StringUtils.isBlank(ticketValue) || StringUtils.isBlank(serId)) {
            String server = this.getServerHostPort();
            exception = this.quietSaveTicket(server, lowerCaseableUserName, ticketValue, exception);
        }
        if (Objects.nonNull(exception)) {
            throw exception;
        }
    }

    private String getLowerCaseableUserName(String userName) {
        String lowerCaseableUserName = userName;
        if (!this.isCaseSensitive() && StringUtils.isNotBlank(userName)) {
            lowerCaseableUserName = userName.toLowerCase();
        }
        return lowerCaseableUserName;
    }

    @Nullable
    private ConfigException quietSaveTicket(String serverOrServerId, String lowerCaseUserName, String ticketValue, @Nullable ConfigException exception) {
        if (StringUtils.isNotBlank(serverOrServerId)) {
            try {
                AuthTicketsHelper.saveTicket(lowerCaseUserName, serverOrServerId, ticketValue, this.ticketsFilePath, this.authFileLockTry, this.authFileLockDelay, this.authFileLockWait);
            }
            catch (IOException e) {
                if (Objects.nonNull(exception)) {
                    exception.addSuppressed(e);
                    return exception;
                }
                return new ConfigException(e);
            }
        }
        return null;
    }

    public void setSecretKey(String userName, String secretKey) {
        if (StringUtils.isNotBlank(userName)) {
            if (StringUtils.isBlank(secretKey)) {
                this.secretKeys.remove(userName);
            } else {
                this.secretKeys.put(userName, secretKey);
            }
        }
    }

    public void setPbuf(String userName, String pBuf) {
        if (StringUtils.isNotBlank(userName)) {
            if (StringUtils.isBlank(pBuf)) {
                this.pBufs.remove(userName);
            } else {
                this.pBufs.put(userName, pBuf);
            }
        }
    }

    protected boolean useTags(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean isStreamCmd) {
        CmdSpec cmdSpec = CmdSpec.getValidP4JCmdSpec(cmdName);
        if (Objects.nonNull((Object)cmdSpec)) {
            if (cmdSpec == CmdSpec.LOGIN || cmdSpec == CmdSpec.LOGIN2) {
                return false;
            }
            if (isStreamCmd) {
                switch (cmdSpec) {
                    case DESCRIBE: 
                    case DIFF2: 
                    case PRINT: 
                    case PROTECT: {
                        return false;
                    }
                }
            }
            if (Objects.nonNull(inMap) && inMap.containsKey("useTags")) {
                return Boolean.valueOf((String)inMap.remove("useTags"));
            }
        }
        return true;
    }

    protected boolean writeInPlace(String cmdName) {
        String writeInPlaceKeyPropertyValue = System.getProperty("com.perforce.p4java.writeInPlace", this.props.getProperty("writeInPlace", "false"));
        return cmdName.equalsIgnoreCase(CmdSpec.SYNC.toString()) && Boolean.valueOf(writeInPlaceKeyPropertyValue) != false;
    }
}

