/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.ILicense;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class License
extends ServerResource
implements ILicense {
    private String license;
    private String licenseExpires;
    private String supportExpires;
    private String customer;
    private String application;
    private String ipaddress;
    private String platform;
    private long clients;
    private long users;
    private List<String> capabilities;

    public License() {
    }

    public License(Map<String, Object> map) {
        if (map != null) {
            try {
                this.license = (String)map.get("License");
                this.licenseExpires = (String)map.get("License-Expires");
                this.supportExpires = (String)map.get("Support-Expires");
                this.customer = (String)map.get("Customer");
                this.application = (String)map.get("Application");
                this.ipaddress = (String)map.get("IPaddress");
                this.platform = (String)map.get("Platform");
                this.clients = License.readValues(map, "Clients");
                this.users = License.readValues(map, "Users");
                int i = 0;
                this.capabilities = new ArrayList<String>();
                while (map.containsKey("ExtraCapabilities" + i)) {
                    this.capabilities.add((String)map.get("ExtraCapabilities" + i));
                    ++i;
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in License constructor: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
            }
        }
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public String getLicenseExpires() {
        return this.licenseExpires;
    }

    @Override
    public String getSupportExpires() {
        return this.supportExpires;
    }

    @Override
    public String getCustomer() {
        return this.customer;
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getIpaddress() {
        return this.ipaddress;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public long getClients() {
        return this.clients;
    }

    @Override
    public long getUsers() {
        return this.users;
    }

    @Override
    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public static long readValues(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return 0L;
        }
        String value = (String)map.get(key);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            if (StringUtils.isEmpty(value)) {
                return 0L;
            }
            if ("unlimited".equals(value)) {
                return Long.MAX_VALUE;
            }
            if (value.startsWith(">")) {
                return -1L;
            }
            if (value.startsWith("-")) {
                return 0L;
            }
            return 0L;
        }
    }
}

