/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.admin;

import com.perforce.p4java.common.base.P4ResultMapUtils;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ServerConfigurationValue {
    public static final String ALL_SERVERS = "allservers";
    private String serverName = null;
    private ConfigType type = ConfigType.UNKNOWN;
    private String name = null;
    private String value = null;

    public ServerConfigurationValue() {
    }

    public ServerConfigurationValue(String serverName, ConfigType type, String name, String value) {
        this.serverName = serverName;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public ServerConfigurationValue(String serverName, String type, String name, String value) {
        this.serverName = serverName;
        this.type = ConfigType.fromString(type);
        this.name = name;
        this.value = value;
    }

    public ServerConfigurationValue(Map<String, Object> map) {
        if (Objects.nonNull(map)) {
            this.name = P4ResultMapUtils.parseString(map, "Name");
            this.value = P4ResultMapUtils.parseString(map, "Value");
            this.serverName = P4ResultMapUtils.parseString(map, "ServerName");
            this.type = ConfigType.fromString(P4ResultMapUtils.parseString(map, "Type"));
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public ServerConfigurationValue setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public ConfigType getType() {
        return this.type;
    }

    public ServerConfigurationValue setType(ConfigType type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ServerConfigurationValue setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ServerConfigurationValue setValue(String value) {
        this.value = value;
        return this;
    }

    public String toString() {
        return "Server<" + this.serverName + ">, Type<" + (Object)((Object)this.type) + ">, Name<" + this.name + ">, Value<" + this.value + ">.";
    }

    public static enum ConfigType {
        DEFAULT,
        UNKNOWN,
        OPTION,
        ENVIRONMENT,
        TUNABLE,
        CONFIGURE;


        public static ConfigType fromString(String str) {
            if (StringUtils.isNotBlank(str)) {
                for (ConfigType configType : ConfigType.values()) {
                    if (!str.toUpperCase().startsWith(configType.toString())) continue;
                    return configType;
                }
            }
            return UNKNOWN;
        }
    }
}

