/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.trigger;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyEventFilter;
import org.apache.ivy.core.event.publish.PublishEvent;
import org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.util.filter.Filter;
import org.apache.tools.ant.Project;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.context.BuildContext;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.builder.ArtifactBuilder;
import org.jfrog.build.extractor.builder.DependencyBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.util.IvyResolverHelper;

public class ArtifactoryBuildInfoTrigger
implements Trigger {
    private final Filter filter;
    private BuildContext ctx;
    private String eventName;

    public ArtifactoryBuildInfoTrigger(String eventName) {
        this.eventName = eventName;
        this.filter = new IvyEventFilter(eventName, null, ExactPatternMatcher.INSTANCE);
    }

    public void setIvyBuildContext(BuildContext ctx) {
        this.ctx = ctx;
    }

    public Filter getEventFilter() {
        return this.filter;
    }

    @Override
    public void progress(IvyEvent event) {
        try {
            Project project = (Project)IvyContext.peekInContextStack("ant-project");
            if (project != null) {
                project.log("[buildinfo:collect] Received Event: " + event.getName(), 4);
            }
            if ("post-resolve".equals(event.getName())) {
                this.collectDependencyInformation(event);
            } else if ("post-publish-artifact".equals(event.getName())) {
                this.collectModuleInformation(event);
            }
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Fail to collect dependencies and modules using the progress trigger in the Artifactory Ivy plugin, due to: " + e.getMessage(), e);
            re.printStackTrace();
            throw re;
        }
    }

    private void collectDependencyInformation(IvyEvent event) {
        Project project = (Project)IvyContext.peekInContextStack("ant-project");
        ResolveReport report = ((EndResolveEvent)event).getReport();
        Map<String, String> attributes = event.getAttributes();
        Module module = this.getOrCreateModule(attributes);
        project.log("[buildinfo:collect] Collecting dependencies for " + module.getId(), 2);
        if (module.getDependencies() == null || module.getDependencies().isEmpty()) {
            String[] configurations = report.getConfigurations();
            ArrayList<Dependency> moduleDependencies = new ArrayList<Dependency>();
            for (String configuration : configurations) {
                ArtifactDownloadReport[] allArtifactsReports;
                project.log("[buildinfo:collect] Configuration: " + configuration + " Dependencies", 4);
                ConfigurationResolveReport configurationReport = report.getConfigurationReport(configuration);
                for (ArtifactDownloadReport artifactsReport : allArtifactsReports = configurationReport.getAllArtifactsReports()) {
                    project.log("[buildinfo:collect] Artifact Download Report for configuration: " + configuration + " : " + artifactsReport, 4);
                    ModuleRevisionId id = artifactsReport.getArtifact().getModuleRevisionId();
                    String type = this.getType(artifactsReport.getArtifact());
                    Dependency dependency = this.findDependencyInList(id, type, moduleDependencies);
                    if (dependency == null) {
                        Map<String, String> checksums;
                        DependencyBuilder dependencyBuilder = new DependencyBuilder();
                        dependencyBuilder.type(type).scopes(CommonUtils.newHashSet(configuration));
                        String idString = BuildInfoExtractorUtils.getModuleIdString(id.getOrganisation(), id.getName(), id.getRevision());
                        dependencyBuilder.id(idString);
                        File file = artifactsReport.getLocalFile();
                        try {
                            checksums = FileChecksumCalculator.calculateChecksums(file, "MD5", "SHA1", "SHA-256");
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        String md5 = checksums.get("MD5");
                        String sha1 = checksums.get("SHA1");
                        String sha256 = checksums.get("SHA-256");
                        dependencyBuilder.md5(md5).sha1(sha1).sha256(sha256);
                        dependency = dependencyBuilder.build();
                        moduleDependencies.add(dependency);
                        project.log("[buildinfo:collect] Added dependency '" + dependency.getId() + "'", 4);
                        continue;
                    }
                    if (!dependency.getScopes().contains(configuration)) {
                        dependency.getScopes().add(configuration);
                        project.log("[buildinfo:collect] Added scope " + configuration + " to dependency '" + dependency.getId() + "'", 4);
                        continue;
                    }
                    project.log("[buildinfo:collect] Find same dependency twice in configuration '" + configuration + "' for dependency '" + artifactsReport + "'", 1);
                }
            }
            module.setDependencies(moduleDependencies);
        }
    }

    private void collectModuleInformation(IvyEvent event) {
        List<Artifact> excludedArtifacts;
        ArtifactoryClientConfiguration.PublisherHandler publisher = this.ctx.getClientConf().publisher;
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
        boolean excludeArtifactsFromBuild = publisher.isFilterExcludedArtifactsFromBuild();
        Project project = (Project)IvyContext.peekInContextStack("ant-project");
        Map<String, String> map = event.getAttributes();
        Module module = this.getOrCreateModule(map);
        List<Artifact> artifacts = module.getArtifacts();
        if (artifacts == null) {
            module.setArtifacts(new ArrayList<Artifact>());
        }
        if ((excludedArtifacts = module.getExcludedArtifacts()) == null) {
            module.setExcludedArtifacts(new ArrayList<Artifact>());
        }
        org.apache.ivy.core.module.descriptor.Artifact pubArtifact = ((PublishEvent)event).getArtifact();
        Map<String, String> extraAttributes = pubArtifact.getExtraAttributes();
        String file = map.get("file");
        ModuleRevisionId mrid = pubArtifact.getModuleRevisionId();
        String moduleName = mrid.getName();
        String type = this.getType(pubArtifact);
        String name = pubArtifact.getName() + "-" + mrid.getRevision() + "." + pubArtifact.getExt();
        String fullPath = IvyResolverHelper.calculateArtifactPath(publisher, map, extraAttributes);
        int lastSlash = fullPath.lastIndexOf(47);
        if (lastSlash > 0 && lastSlash + 1 < fullPath.length()) {
            name = fullPath.substring(lastSlash + 1);
        }
        project.log("[buildinfo:collect] Collecting artifact " + name + " for module " + moduleName + " using file " + file, 2);
        if (this.isArtifactExist(module.getArtifacts(), name) || this.isArtifactExist(module.getExcludedArtifacts(), name)) {
            return;
        }
        ArtifactBuilder artifactBuilder = new ArtifactBuilder(name);
        artifactBuilder.type(type);
        File artifactFile = new File(file);
        Map<String, String> checksums = this.calculateFileChecksum(artifactFile);
        String md5 = checksums.get("MD5");
        String sha1 = checksums.get("SHA1");
        String sha256 = checksums.get("SHA-256");
        artifactBuilder.md5(md5).sha1(sha1).sha256(sha256);
        Artifact artifact = artifactBuilder.build();
        if (excludeArtifactsFromBuild && PatternMatcher.pathConflicts(fullPath, patterns)) {
            module.getExcludedArtifacts().add(artifact);
        } else {
            module.getArtifacts().add(artifact);
        }
        DeployDetails deployDetails = this.buildDeployDetails(artifactFile, artifact, this.ctx, map, extraAttributes);
        this.ctx.addDeployDetailsForModule(deployDetails);
        List<Module> contextModules = this.ctx.getModules();
        if (contextModules.indexOf(module) == -1) {
            this.ctx.addModule(module);
        }
    }

    private String getType(org.apache.ivy.core.module.descriptor.Artifact ivyArtifact) {
        return BuildInfoExtractorUtils.getTypeString(ivyArtifact.getType(), ivyArtifact.getExtraAttribute("classifier"), ivyArtifact.getExt());
    }

    private String getName(org.apache.ivy.core.module.descriptor.Artifact ivyArtifact) {
        return BuildInfoExtractorUtils.getTypeString(ivyArtifact.getType(), ivyArtifact.getExtraAttribute("classifier"), ivyArtifact.getExt());
    }

    private DeployDetails buildDeployDetails(File artifactFile, Artifact artifact, BuildContext ctx, Map<String, String> map, Map<String, String> extraAttributes) {
        String buildTimestamp;
        ArtifactoryClientConfiguration clientConf = ctx.getClientConf();
        DeployDetails.Builder builder = new DeployDetails.Builder().file(artifactFile).sha1(artifact.getSha1()).md5(artifact.getMd5()).packageType(DeployDetails.PackageType.IVY);
        builder.artifactPath(IvyResolverHelper.calculateArtifactPath(clientConf.publisher, map, extraAttributes));
        builder.targetRepository(clientConf.publisher.getRepoKey());
        if (StringUtils.isNotBlank(clientConf.info.getVcsRevision())) {
            builder.addProperty("vcs.revision", clientConf.info.getVcsRevision());
        }
        if (StringUtils.isNotBlank(clientConf.info.getVcsUrl())) {
            builder.addProperty("vcs.url", clientConf.info.getVcsUrl());
        }
        if (StringUtils.isNotBlank(clientConf.info.getBuildName())) {
            builder.addProperty("build.name", clientConf.info.getBuildName());
        }
        if (StringUtils.isNotBlank(clientConf.info.getBuildNumber())) {
            builder.addProperty("build.number", clientConf.info.getBuildNumber());
        }
        if (StringUtils.isBlank(buildTimestamp = clientConf.info.getBuildTimestamp())) {
            buildTimestamp = ctx.getBuildStartTime() + "";
        }
        builder.addProperty("build.timestamp", buildTimestamp);
        if (StringUtils.isNotBlank(clientConf.info.getParentBuildName())) {
            builder.addProperty("build.parentName", clientConf.info.getParentBuildName());
        }
        if (StringUtils.isNotBlank(clientConf.info.getParentBuildNumber())) {
            builder.addProperty("build.parentNumber", clientConf.info.getParentBuildNumber());
        }
        builder.addProperties(clientConf.publisher.getMatrixParams());
        return builder.build();
    }

    private Map<String, String> calculateFileChecksum(File file) {
        Map<String, String> checksums;
        try {
            checksums = FileChecksumCalculator.calculateChecksums(file, "MD5", "SHA1", "SHA-256");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return checksums;
    }

    private Dependency findDependencyInList(ModuleRevisionId id, String type, List<Dependency> moduleDependencies) {
        String idToFind = BuildInfoExtractorUtils.getModuleIdString(id.getOrganisation(), id.getName(), "");
        return CommonUtils.getFirstSatisfying(moduleDependencies, input -> input.getId().startsWith(idToFind) && input.getType().equals(type), null);
    }

    private Module findModule(List<Module> modules, String moduleKey) {
        return CommonUtils.getFirstSatisfying(modules, input -> input.getId().startsWith(moduleKey), null);
    }

    private Module getOrCreateModule(Map<String, String> attributes) {
        List<Module> modules = this.ctx.getModules();
        String org = attributes.get("organisation");
        String moduleName = attributes.get("module");
        String moduleKey = BuildInfoExtractorUtils.getModuleIdString(org, moduleName, "");
        String moduleId = BuildInfoExtractorUtils.getModuleIdString(org, moduleName, attributes.get("revision"));
        Module module = this.findModule(modules, moduleKey);
        if (module == null) {
            ModuleBuilder moduleBuilder = new ModuleBuilder().type(ModuleType.IVY).id(moduleId).repository(this.ctx.getClientConf().publisher.getRepoKey());
            module = moduleBuilder.build();
            modules.add(module);
        } else {
            module.setId(moduleId);
        }
        return module;
    }

    private boolean isArtifactExist(List<Artifact> artifacts, String artifactName) {
        return CommonUtils.isAnySatisfying(artifacts, input -> input.getName().equals(artifactName));
    }
}

