/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.repository.Proxy;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Named
@Component(role=ArtifactoryEclipseResolversHelper.class)
public class ArtifactoryEclipseResolversHelper {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    private List<ArtifactRepository> resolutionPluginRepositories = null;
    private List<RemoteRepository> resolutionRepositories = null;
    private RemoteRepository releaseRepository = null;
    private RemoteRepository snapshotRepository = null;

    void initResolutionRepositories(RepositorySystemSession session) {
        this.getResolutionRepositories(session);
    }

    List<RemoteRepository> getResolutionRepositories(RepositorySystemSession session) {
        if (this.resolutionRepositories == null) {
            ArrayList<RemoteRepository> tempRepositories = new ArrayList<RemoteRepository>();
            this.initResolutionHelper(session);
            String releaseRepoUrl = this.resolutionHelper.getRepoReleaseUrl();
            String snapshotRepoUrl = this.resolutionHelper.getRepoSnapshotUrl();
            org.eclipse.aether.repository.Authentication authentication = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getRepoUsername())) {
                authentication = new AuthenticationBuilder().addString("username", this.resolutionHelper.getRepoUsername()).addSecret("password", this.resolutionHelper.getRepoPassword()).build();
            }
            org.eclipse.aether.repository.Proxy proxy = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getProxyHost())) {
                org.eclipse.aether.repository.Authentication auth = new AuthenticationBuilder().addString("username", this.resolutionHelper.getProxyUsername()).addSecret("password", this.resolutionHelper.getProxyPassword()).build();
                proxy = new org.eclipse.aether.repository.Proxy(null, this.resolutionHelper.getProxyHost(), this.resolutionHelper.getProxyPort(), auth);
            }
            if (StringUtils.isNotBlank(snapshotRepoUrl)) {
                this.logger.debug("[buildinfo] Enforcing snapshot repository for resolution: " + snapshotRepoUrl);
                RepositoryPolicy releasePolicy = new RepositoryPolicy(false, "daily", "warn");
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(true, "daily", "warn");
                RemoteRepository.Builder builder = new RemoteRepository.Builder("artifactory-snapshot", "default", snapshotRepoUrl);
                builder.setReleasePolicy(releasePolicy);
                builder.setSnapshotPolicy(snapshotPolicy);
                if (authentication != null) {
                    this.logger.debug("[buildinfo] Enforcing repository authentication: " + authentication + " for snapshot resolution repository");
                    builder.setAuthentication(authentication);
                }
                if (proxy != null) {
                    this.logger.debug("[buildinfo] Enforcing proxy: " + proxy + " for snapshot resolution repository");
                    builder.setProxy(proxy);
                }
                this.snapshotRepository = builder.build();
                tempRepositories.add(this.snapshotRepository);
            }
            if (StringUtils.isNotBlank(releaseRepoUrl)) {
                this.logger.debug("[buildinfo] Enforcing release repository for resolution: " + releaseRepoUrl);
                boolean snapshotPolicyEnabled = this.snapshotRepository == null;
                String repositoryId = snapshotPolicyEnabled ? "artifactory-release-snapshot" : "artifactory-release";
                RepositoryPolicy releasePolicy = new RepositoryPolicy(true, "daily", "warn");
                RepositoryPolicy snapshotPolicy = new RepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
                RemoteRepository.Builder builder = new RemoteRepository.Builder(repositoryId, "default", releaseRepoUrl);
                builder.setReleasePolicy(releasePolicy);
                builder.setSnapshotPolicy(snapshotPolicy);
                if (authentication != null) {
                    this.logger.debug("[buildinfo] Enforcing repository authentication: " + authentication + " for release resolution repository");
                    builder.setAuthentication(authentication);
                }
                if (proxy != null) {
                    this.logger.debug("[buildinfo] Enforcing proxy: " + proxy + " for release resolution repository");
                    builder.setProxy(proxy);
                }
                this.releaseRepository = builder.build();
                tempRepositories.add(this.releaseRepository);
            }
            this.resolutionRepositories = tempRepositories;
        }
        return this.resolutionRepositories;
    }

    List<ArtifactRepository> getResolutionPluginRepositories(RepositorySystemSession session) {
        if (this.resolutionPluginRepositories == null) {
            ArrayList<ArtifactRepository> tempRepositories = new ArrayList<ArtifactRepository>();
            this.initResolutionHelper(session);
            String releaseRepoUrl = this.resolutionHelper.getRepoReleaseUrl();
            String snapshotRepoUrl = this.resolutionHelper.getRepoSnapshotUrl();
            Authentication authentication = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getRepoUsername())) {
                authentication = new Authentication(this.resolutionHelper.getRepoUsername(), this.resolutionHelper.getRepoPassword());
            }
            Proxy proxy = null;
            if (StringUtils.isNotBlank(this.resolutionHelper.getProxyHost())) {
                proxy = new Proxy();
                proxy.setHost(this.resolutionHelper.getProxyHost());
                proxy.setPort(this.resolutionHelper.getProxyPort());
                proxy.setUserName(this.resolutionHelper.getProxyUsername());
                proxy.setPassword(this.resolutionHelper.getProxyPassword());
            }
            if (StringUtils.isNotBlank(snapshotRepoUrl)) {
                this.logger.debug("[buildinfo] Enforcing snapshot repository for resolution: " + snapshotRepoUrl);
                ArtifactRepositoryPolicy releasePolicy = new ArtifactRepositoryPolicy(false, "daily", "warn");
                ArtifactRepositoryPolicy snapshotPolicy = new ArtifactRepositoryPolicy(true, "daily", "warn");
                MavenArtifactRepository snapshotPluginRepository = new MavenArtifactRepository("artifactory-snapshot", snapshotRepoUrl, new DefaultRepositoryLayout(), snapshotPolicy, releasePolicy);
                if (authentication != null) {
                    this.logger.debug("[buildinfo] Enforcing repository authentication: " + authentication + " for snapshot resolution repository");
                    snapshotPluginRepository.setAuthentication(authentication);
                }
                if (StringUtils.isNotBlank(this.resolutionHelper.getRepoUsername())) {
                    authentication = new Authentication(this.resolutionHelper.getRepoUsername(), this.resolutionHelper.getRepoPassword());
                }
                if (proxy != null) {
                    this.logger.debug("[buildinfo] Enforcing proxy: " + proxy + " for snapshot resolution repository");
                    snapshotPluginRepository.setProxy(proxy);
                }
                tempRepositories.add(snapshotPluginRepository);
            }
            if (StringUtils.isNotBlank(releaseRepoUrl)) {
                this.logger.debug("[buildinfo] Enforcing release repository for resolution: " + releaseRepoUrl);
                boolean snapshotPolicyEnabled = tempRepositories.isEmpty();
                String repositoryId = snapshotPolicyEnabled ? "artifactory-release-snapshot" : "artifactory-release";
                ArtifactRepositoryPolicy releasePolicy = new ArtifactRepositoryPolicy(true, "daily", "warn");
                ArtifactRepositoryPolicy snapshotPolicy = new ArtifactRepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
                MavenArtifactRepository releasePluginRepository = new MavenArtifactRepository(repositoryId, releaseRepoUrl, new DefaultRepositoryLayout(), snapshotPolicy, releasePolicy);
                if (authentication != null) {
                    this.logger.debug("[buildinfo] Enforcing repository authentication: " + authentication + " for release resolution repository");
                    releasePluginRepository.setAuthentication(authentication);
                }
                if (proxy != null) {
                    this.logger.debug("[buildinfo] Enforcing proxy: " + proxy + " for release resolution repository");
                    releasePluginRepository.setProxy(proxy);
                }
                tempRepositories.add(releasePluginRepository);
            }
            this.resolutionPluginRepositories = tempRepositories;
        }
        return this.resolutionPluginRepositories;
    }

    RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        if (this.snapshotRepository != null) {
            return this.snapshotRepository;
        }
        return this.releaseRepository;
    }

    RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        this.initResolutionRepositories(session);
        return this.releaseRepository;
    }

    private void initResolutionHelper(RepositorySystemSession session) {
        if (!this.resolutionHelper.isInitialized()) {
            Properties allMavenProps = new Properties();
            allMavenProps.putAll(session.getSystemProperties());
            allMavenProps.putAll(session.getUserProperties());
            this.resolutionHelper.init(allMavenProps);
        }
    }
}

