/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.project.DefaultProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Named
@Component(role=DefaultProjectBuilder.class, hint="default")
public class ArtifactoryProjectBuilder
extends DefaultProjectBuilder {
    @Requirement
    private ResolutionHelper resolutionHelper;

    @Override
    public List<ProjectBuildingResult> build(List<File> pomFiles, boolean recursive, ProjectBuildingRequest request) throws ProjectBuildingException {
        if (Boolean.parseBoolean(System.getProperties().getProperty("buildInfoConfig.artifactoryResolutionEnabled")) || Boolean.parseBoolean(System.getenv("buildInfoConfig.artifactoryResolutionEnabled"))) {
            if (!this.resolutionHelper.isInitialized()) {
                Properties allMavenProps = new Properties();
                allMavenProps.putAll((Map<?, ?>)request.getSystemProperties());
                allMavenProps.putAll((Map<?, ?>)request.getUserProperties());
                this.resolutionHelper.init(allMavenProps);
            }
            List<ArtifactRepository> repositories = this.getRepositories();
            request.setRemoteRepositories(repositories);
            request.setPluginArtifactRepositories(repositories);
        }
        return super.build(pomFiles, recursive, request);
    }

    private List<ArtifactRepository> getRepositories() {
        String releaseRepoUrl = this.resolutionHelper.getRepoReleaseUrl();
        String snapshotRepoUrl = this.resolutionHelper.getRepoSnapshotUrl();
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        if (StringUtils.isNotBlank(snapshotRepoUrl)) {
            ArtifactRepositoryPolicy snapshotPolicy = new ArtifactRepositoryPolicy(true, "daily", "warn");
            ArtifactRepositoryPolicy releasePolicy = new ArtifactRepositoryPolicy(false, "daily", "warn");
            repositories.add(new MavenArtifactRepository("artifactory-snapshot", snapshotRepoUrl, new DefaultRepositoryLayout(), snapshotPolicy, releasePolicy));
        }
        if (StringUtils.isNotBlank(releaseRepoUrl)) {
            boolean snapshotPolicyEnabled = StringUtils.isBlank(snapshotRepoUrl);
            String repositoryId = snapshotPolicyEnabled ? "artifactory-release-snapshot" : "artifactory-release";
            ArtifactRepositoryPolicy snapshotPolicy = new ArtifactRepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
            ArtifactRepositoryPolicy releasePolicy = new ArtifactRepositoryPolicy(true, "daily", "warn");
            repositories.add(new MavenArtifactRepository(repositoryId, releaseRepoUrl, new DefaultRepositoryLayout(), snapshotPolicy, releasePolicy));
        }
        return repositories;
    }
}

