/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.ci;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.extractor.ci.BaseBuildFileBean;

@XStreamAlias(value="dependency")
public class Dependency
extends BaseBuildFileBean {
    public static final String SCOPE_BUILD = "_build_";
    private String id;
    private Set<String> scopes;
    private String[][] requestedBy;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String[][] getRequestedBy() {
        return this.requestedBy;
    }

    public void setRequestedBy(String[][] requestedBy) {
        this.requestedBy = requestedBy;
    }

    public void addRequestedBy(String[] pathToModuleRoot) {
        this.requestedBy = ArrayUtils.add(this.requestedBy, pathToModuleRoot);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Dependency that = (Dependency)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!StringUtils.equals(this.remotePath, that.remotePath)) {
            return false;
        }
        if (!Objects.equals(this.scopes, that.scopes)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.requestedBy, (Object[])that.requestedBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.scopes, Arrays.deepHashCode((Object[])this.requestedBy), this.remotePath);
    }

    public org.jfrog.build.api.Dependency ToBuildDependency() {
        org.jfrog.build.api.Dependency result = new org.jfrog.build.api.Dependency();
        result.setId(this.id);
        result.setRequestedBy(this.requestedBy);
        result.setScopes(this.scopes);
        result.setType(this.type);
        result.setMd5(this.md5);
        result.setSha256(this.sha256);
        result.setSha1(this.sha1);
        result.setRemotePath(this.remotePath);
        result.setProperties(this.getProperties());
        return result;
    }

    public static Dependency ToBuildDependency(org.jfrog.build.api.Dependency dependency) {
        Dependency result = new Dependency();
        result.setId(dependency.getId());
        result.setRequestedBy(dependency.getRequestedBy());
        result.setScopes(dependency.getScopes());
        result.setType(dependency.getType());
        result.setMd5(dependency.getMd5());
        result.setSha256(dependency.getSha256());
        result.setSha1(dependency.getSha1());
        result.setRemotePath(dependency.getRemotePath());
        result.setProperties(dependency.getProperties());
        return result;
    }
}

