/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class CommonUtils {
    public static <K, V> Map<K, V> filterMapValues(Map<K, V> map, Predicate<V> predicate) {
        return map.entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> predicate.test(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> filterMapKeys(Map<K, V> map, Predicate<K> predicate) {
        return map.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> predicate.test(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> entriesOnlyOnLeftMap(Map<K, V> left, Map<K, V> right) {
        HashMap<K, V> difference = new HashMap<K, V>();
        difference.putAll(left);
        difference.putAll(right);
        difference.entrySet().removeAll(right.entrySet());
        return difference;
    }

    public static <T> List<T> concatLists(List<T> first, List<T> second) {
        return Stream.concat(first.stream(), second.stream()).collect(Collectors.toList());
    }

    public static <F, T> ArrayList<T> transformList(Iterable<F> iterable, Function<F, T> function) {
        ArrayList output = new ArrayList();
        iterable.forEach(t -> output.add(function.apply(t)));
        return output;
    }

    public static <T> T getFirstSatisfying(Collection<T> collection, Predicate<T> predicate, T defaultValue) {
        return (T)collection.stream().filter(Objects::nonNull).filter(predicate).findFirst().orElse(defaultValue);
    }

    public static <T> boolean isAnySatisfying(Collection<T> collection, Predicate<T> predicate) {
        return CommonUtils.getFirstSatisfying(collection, predicate, null) != null;
    }

    public static <T> Collection<T> filterCollection(Collection<T> unfiltered, Predicate<T> predicate) {
        return unfiltered.stream().filter(Objects::nonNull).filter(predicate).collect(Collectors.toList());
    }

    public static <T> T getLast(Collection<T> collection) {
        return collection.stream().reduce((first, second) -> second).orElse(null);
    }

    public static <T> T getOnlyElement(Collection<T> collection) {
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        throw new IllegalArgumentException("Collection was expected to have exactly one element, but has " + collection.size());
    }

    public static void writeByCharset(String from, File to, Charset charset) throws RuntimeException {
        try (BufferedWriter writer = Files.newBufferedWriter(to.toPath(), charset, new OpenOption[0]);){
            writer.write(from);
            writer.flush();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String readByCharset(File from, Charset charset) throws IOException {
        byte[] encoded = Files.readAllBytes(from.toPath());
        return new String(encoded, charset);
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        return new HashSet<E>(Arrays.asList(elements));
    }

    public static <T> Iterable<T> emptyIfNull(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyList() : iterable;
    }

    public static void handleJavaTmpdirProperty() {
        String tmpDirPath = FileUtils.getTempDirectoryPath();
        if (StringUtils.isNotBlank(tmpDirPath)) {
            if (FileUtils.getTempDirectory().exists()) {
                return;
            }
            try {
                Files.createDirectories(Paths.get(tmpDirPath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("The directory defined by the system property 'java.io.tmpdir' (" + tmpDirPath + ") doesn't exit. An attempt to create a directory in this path failed: ", e);
            }
        } else if (SystemUtils.IS_OS_UNIX) {
            System.setProperty("java.io.tmpdir", "/tmp");
        } else {
            throw new RuntimeException("java.io.tmpdir system property is missing!");
        }
    }
}

