/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.task;

import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.utils.process.ExternalProcess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.admin.ServerConfig;
import org.jfrog.bamboo.builder.BuilderDependencyHelper;
import org.jfrog.bamboo.builder.IvyDataHelper;
import org.jfrog.bamboo.builder.MavenAndIvyBuildInfoDataHelperBase;
import org.jfrog.bamboo.context.IvyBuildContext;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.task.BaseJavaBuildTask;
import org.jfrog.bamboo.util.PluginProperties;
import org.jfrog.bamboo.util.TaskUtils;
import org.jfrog.bamboo.util.Utils;

public class ArtifactoryIvyTask
extends BaseJavaBuildTask {
    public static final String TASK_NAME = "artifactoryIvyTask";
    public static final String EXECUTABLE_NAME = SystemUtils.IS_OS_WINDOWS ? "ant.bat" : "ant";
    private static final String IVY_KEY = "system.builder.ivy.";
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private final BuilderDependencyHelper dependencyHelper;
    private IvyBuildContext ivyBuildContext;
    private MavenAndIvyBuildInfoDataHelperBase ivyDataHelper;
    private String artifactoryPluginVersion;

    public ArtifactoryIvyTask(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        super(testCollationService, environmentVariableAccessor, processService);
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.dependencyHelper = new BuilderDependencyHelper("artifactoryIvyBuilder");
        ContainerManager.autowireComponent((Object)this.dependencyHelper);
    }

    @Override
    protected void initTask(@NotNull CommonTaskContext context) throws TaskException {
        super.initTask(context);
        HashMap<String, String> combinedMap = Maps.newHashMap();
        combinedMap.putAll((Map<String, String>)context.getConfigurationMap());
        combinedMap.putAll(((TaskContext)context).getBuildContext().getBuildDefinition().getCustomConfiguration());
        this.ivyBuildContext = new IvyBuildContext(combinedMap);
        this.initEnvironmentVariables(this.ivyBuildContext);
        this.aggregateBuildInfo = this.ivyBuildContext.shouldAggregateBuildInfo(context, this.ivyBuildContext.getArtifactoryServerId());
        this.artifactoryPluginVersion = Utils.getPluginVersion(this.pluginAccessor);
        this.ivyDataHelper = new IvyDataHelper(this.buildParamsOverrideManager, context, (PackageManagersContext)this.ivyBuildContext, this.environmentVariableAccessor, this.artifactoryPluginVersion, this.aggregateBuildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TaskResult runTask(@NotNull TaskContext context) throws TaskException {
        String antOpts;
        String subDirectory;
        String targets;
        String buildFile;
        String executable;
        String ivyDependenciesDir;
        this.logger.addBuildLogEntry("Bamboo Artifactory Plugin version: " + this.artifactoryPluginVersion);
        ErrorMemorisingInterceptor errorLines = new ErrorMemorisingInterceptor();
        this.logger.getInterceptorStack().add((LogInterceptor)errorLines);
        File rootDirectory = context.getRootDirectory();
        try {
            ivyDependenciesDir = this.extractIvyDependencies(this.ivyBuildContext.getArtifactoryServerId(), this.ivyBuildContext);
            log.info(this.logger.addBuildLogEntry("Ivy dependency directory found at: " + ivyDependenciesDir));
        }
        catch (IOException ioe) {
            ivyDependenciesDir = null;
            this.logger.addBuildLogEntry((LogEntry)new ErrorLogEntry("Error occurred while preparing Artifactory Ivy Runner dependencies. Build Info support is disabled: " + ioe.getMessage()));
            log.error("Error occurred while preparing Artifactory Ivy Runner dependencies. Build Info support is disabled.", (Throwable)ioe);
        }
        if (ivyDependenciesDir == null) {
            this.buildInfoLog.error("Ivy dependency directory not found.");
        }
        if (StringUtils.isBlank((String)(executable = TaskUtils.getExecutablePath(this.ivyBuildContext, this.capabilityContext, IVY_KEY, EXECUTABLE_NAME, TASK_NAME, this.containerized)))) {
            log.error(this.logger.addErrorLogEntry("Cannot find ivy executable"));
            return TaskResultBuilder.newBuilder((CommonTaskContext)context).failed().build();
        }
        if (StringUtils.isNotBlank((String)ivyDependenciesDir)) {
            this.createBuildInfoFiles(this.aggregateBuildInfo, this.ivyDataHelper);
        }
        ArrayList<String> command = Lists.newArrayList(executable);
        if (this.activateBuildInfoRecording) {
            command.add("-lib");
            command.add(Commandline.quoteArgument(ivyDependenciesDir));
            command.add("-listener");
            command.add(Commandline.quoteArgument("org.jfrog.build.extractor.listener.ArtifactoryBuildListener"));
            TaskUtils.appendBuildInfoPropertiesArgument(command, this.buildInfoPropertiesFile);
            this.ivyDataHelper.addPasswordsSystemProps(command, this.ivyBuildContext, context);
        }
        if (StringUtils.isNotBlank((String)(buildFile = this.ivyBuildContext.getBuildFile()))) {
            command.addAll(Arrays.asList("-f", buildFile));
        }
        if (StringUtils.isNotBlank((String)(targets = this.ivyBuildContext.getTargets()))) {
            String[] targetTokens = StringUtils.split((String)targets, (char)' ');
            command.addAll(Arrays.asList(targetTokens));
        }
        if (StringUtils.isNotBlank((String)(subDirectory = this.ivyBuildContext.getWorkingSubDirectory()))) {
            rootDirectory = new File(rootDirectory, subDirectory);
        }
        if (StringUtils.isNotBlank((String)(antOpts = this.ivyBuildContext.getAntOpts()))) {
            this.environmentVariables.put("ANT_OPTS", antOpts);
        }
        String jdkPath = this.getConfiguredJdkPath(this.buildParamsOverrideManager, this.ivyBuildContext, this.capabilityContext);
        this.environmentVariables.put("JAVA_HOME", jdkPath);
        ExternalProcess process = this.getExternalProcess(context, rootDirectory, command, this.environmentVariables);
        try {
            this.executeExternalProcess(this.logger, process, log);
            if (this.aggregateBuildInfo) {
                this.convertGeneratedBuildInfoToBuild();
            }
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)context).checkReturnCode(process).build();
            return taskResult;
        }
        finally {
            context.getBuildContext().getBuildResult().addBuildErrors(errorLines.getErrorStringList());
        }
    }

    @Override
    protected ServerConfig getUsageServerConfig() {
        return this.ivyDataHelper.getDeployServer();
    }

    @Override
    protected String getTaskUsageName() {
        return "ivy";
    }

    private String extractIvyDependencies(long artifactoryServerId, IvyBuildContext context) throws IOException {
        if (artifactoryServerId == -1L) {
            return null;
        }
        return this.dependencyHelper.downloadDependenciesAndGetPath(this.bambooTmp, TaskUtils.getPlanKey(this.customVariableContext), context, PluginProperties.getPluginProperty("ivy.dependency.file.name"));
    }
}

