/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.context;

import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jfrog.bamboo.context.ArtifactoryBuildContext;
import org.jfrog.bamboo.context.GradleBuildContext;
import org.jfrog.bamboo.context.Maven3BuildContext;
import org.jfrog.bamboo.release.action.ModuleVersionHolder;
import org.jfrog.bamboo.util.TaskDefinitionHelper;

public abstract class PackageManagersContext
extends ArtifactoryBuildContext {
    public static final String PUBLISHING_REPO_PARAM = "publishingRepo";
    public static final String DEPLOYER_USERNAME_PARAM = "deployerUsername";
    public static final String DEPLOYER_PASSWORD_PARAM = "deployerPassword";
    public static final String RESOLUTION_SERVER_ID_PARAM = "resolutionArtifactoryServerId";
    public static final String RESOLUTION_REPO_PARAM = "resolutionRepo";
    public static final String RESOLVER_USERNAME_PARAM = "resolverUsername";
    public static final String RESOLVER_PASSWORD_PARAM = "resolverPassword";
    public static final String USE_ARTIFACTORY_GRADLE_PLUGIN = "useArtifactoryGradlePlugin";
    public static final String PUBLISH_BUILD_INFO_PARAM = "publishBuildInfo";
    public static final String CAPTURE_BUILD_INFO = "captureBuildInfo";
    public static final String INCLUDE_ENV_VARS_PARAM = "includeEnvVars";
    public static final String ENV_VARS_INCLUDE_PATTERNS = "envVarsIncludePatterns";
    public static final String ENV_VARS_EXCLUDE_PATTERNS = "envVarsExcludePatterns";
    public static final String TEST_CHECKED = "testChecked";
    public static final String TEST_RESULT_DIRECTORY = "testResultsDirectory";
    public static final String TEST_DIRECTORY_OPTION = "testDirectoryOption";
    public static final String ENVIRONMENT_VARIABLES = "environmentVariables";
    public static final String BUILD_INFO_AGGREGATION = "buildInfoAggregation";
    public static final String PUBLISH_ARTIFACTS_PARAM = "publishArtifacts";
    public static final String PUBLISH_MAVEN_DESCRIPTORS_PARAM = "publishMavenDescriptors";
    public static final String PUBLISH_IVY_DESCRIPTORS_PARAM = "publishIvyDescriptors";
    public static final String USE_M2_COMPATIBLE_PATTERNS_PARAM = "useM2CompatiblePatterns";
    public static final String IVY_PATTERN_PARAM = "ivyPattern";
    public static final String ARTIFACT_PATTERN_PARAM = "artifactPattern";
    public static final String PUBLISH_INCLUDE_PATTERNS_PARAM = "publishIncludePatterns";
    public static final String PUBLISH_EXCLUDE_PATTERNS_PARAM = "publishExcludePatterns";
    public static final String FILTER_EXCLUDED_ARTIFACTS_FROM_BUILD_PARAM = "filterExcludedArtifactsFromBuild";
    public static final String ARTIFACT_SPECS_PARAM = "artifactSpecs";
    public static final String NO_RESOLUTION_REPO_KEY_CONFIGURED = "noResolutionRepoKeyConfigured";
    public static final String NO_PUBLISHING_REPO_KEY_CONFIGURED = "noPublishingRepoKeyConfigured";
    public static final String JDK = "buildJdk";
    public static final String EXECUTABLE = "executable";
    public static final String BASE_URL = "baseUrl";
    public static final String ENABLE_RELEASE_MANAGEMENT = "enableReleaseManagement";
    public static final String ACTIVATE_RELEASE_MANAGEMENT = "activateReleaseManagement";
    public static final String VCS_TAG_BASE = "vcsTagBase";
    public static final String GIT_RELEASE_BRANCH = "gitReleaseBranch";
    public static final String ALTERNATIVE_TASKS = "alternativeTasks";
    public static final String RELEASE_PROPS = "releaseProps";
    public static final String NEXT_INTEG_PROPS = "nextIntegProps";
    public static final String VCS_TYPE = "type";
    public static final String GIT_URL = "git.url";
    public static final String GIT_AUTHENTICATION_TYPE = "git.authenticationType";
    public static final String GIT_USERNAME = "git.username";
    public static final String GIT_PASSWORD = "git.password";
    public static final String GIT_SSH_KEY = "git.ssh.key";
    public static final String GIT_PASSPHRASE = "git.ssh.passphrase";
    public static final String PERFORCE_PORT = "p4.port";
    public static final String PERFORCE_CLIENT = "p4.client";
    public static final String PERFORCE_DEPOT = "p4.depot";
    public static final String PERFORCE_USERNAME = "p4.username";
    public static final String PERFORCE_PASSWORD = "p4.password";
    public static final String VCS_PREFIX = "artifactory.vcs.";
    public static final String ENV_VARS_TO_EXCLUDE = "*password*,*pwd*,*secret*,*security*,*key*,*token*";
    public final ReleaseManagementContext releaseManagementContext = new ReleaseManagementContext();

    public PackageManagersContext(String prefix, Map<String, String> env) {
        super(prefix, env);
    }

    public static PackageManagersContext createContextFromMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("No empty map allowed");
        }
        String value = PackageManagersContext.getBuilderValue(map);
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (StringUtils.startsWith((String)value, (String)"builder.artifactoryGradleBuilder.")) {
            return new GradleBuildContext(PackageManagersContext.sanitizeEntries(map));
        }
        if (StringUtils.startsWith((String)value, (String)"builder.artifactoryMaven3Builder.")) {
            return new Maven3BuildContext(PackageManagersContext.sanitizeEntries(map));
        }
        return null;
    }

    private static String getBuilderValue(Map<String, String> confMap) {
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            if (!StringUtils.startsWith((String)entry.getKey(), (String)"builder.")) continue;
            return entry.getKey();
        }
        return null;
    }

    private static Map<String, String> sanitizeEntries(Map<String, String> confMap) {
        HashMap<String, String> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            if (StringUtils.isBlank((String)entry.getValue())) {
                result.put(entry.getKey(), "");
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static List<String> getVcsFieldsToCopy() {
        return Arrays.asList("artifactory.vcs.type", "artifactory.vcs.git.authenticationType", "artifactory.vcs.git.username", "artifactory.vcs.git.password", "artifactory.vcs.git.url", "artifactory.vcs.git.ssh.passphrase", "artifactory.vcs.git.ssh.key", "artifactory.vcs.p4.client", "artifactory.vcs.p4.port", "artifactory.vcs.p4.depot", "artifactory.vcs.p4.username", "artifactory.vcs.p4.password");
    }

    public long getResolutionArtifactoryServerId() {
        String serverId = (String)this.env.get(this.prefix + RESOLUTION_SERVER_ID_PARAM);
        if (StringUtils.isBlank((String)serverId)) {
            return -1L;
        }
        return Long.parseLong(serverId);
    }

    public String getBaseUrl() {
        return (String)this.env.get(BASE_URL);
    }

    public String getEnvironmentVariables() {
        return (String)this.env.get(this.prefix + ENVIRONMENT_VARIABLES);
    }

    public String getExecutable() {
        return (String)this.env.get(this.prefix + EXECUTABLE);
    }

    public boolean isTestChecked() {
        return Boolean.parseBoolean((String)this.env.get(TEST_CHECKED));
    }

    public String getTestDirectory() {
        return (String)this.env.get(this.prefix + TEST_RESULT_DIRECTORY);
    }

    public String getTestDirectoryOption() {
        return (String)this.env.get(TEST_DIRECTORY_OPTION);
    }

    public String getPublishingRepo() {
        return (String)this.env.get(this.prefix + PUBLISHING_REPO_PARAM);
    }

    @Override
    public String getDeployerUsername() {
        return (String)this.env.get(this.prefix + DEPLOYER_USERNAME_PARAM);
    }

    @Override
    public String getDeployerPassword() {
        return (String)this.env.get(this.prefix + DEPLOYER_PASSWORD_PARAM);
    }

    @Override
    public String getResolverUsername() {
        return (String)this.env.get(this.prefix + RESOLVER_USERNAME_PARAM);
    }

    @Override
    public String getResolverPassword() {
        return (String)this.env.get(this.prefix + RESOLVER_PASSWORD_PARAM);
    }

    public String getJdkLabel() {
        return (String)this.env.get(this.prefix + JDK);
    }

    public boolean useArtifactoryGradlePlugin() {
        return Boolean.parseBoolean((String)this.env.get(this.prefix + USE_ARTIFACTORY_GRADLE_PLUGIN));
    }

    public boolean isPublishBuildInfo() {
        return Boolean.parseBoolean((String)this.env.get(PUBLISH_BUILD_INFO_PARAM));
    }

    public boolean isCaptureBuildInfo() {
        return Boolean.parseBoolean((String)this.env.get(CAPTURE_BUILD_INFO));
    }

    public boolean isIncludeEnvVars() {
        return Boolean.parseBoolean((String)this.env.get(INCLUDE_ENV_VARS_PARAM));
    }

    public String getEnvVarsIncludePatterns() {
        return (String)this.env.get(ENV_VARS_INCLUDE_PATTERNS);
    }

    public String getEnvVarsExcludePatterns() {
        return (String)this.env.get(ENV_VARS_EXCLUDE_PATTERNS);
    }

    public boolean isPublishArtifacts() {
        return Boolean.parseBoolean((String)this.env.get(PUBLISH_ARTIFACTS_PARAM));
    }

    public boolean isPublishMavenDescriptors() {
        return Boolean.parseBoolean((String)this.env.get(this.prefix + PUBLISH_MAVEN_DESCRIPTORS_PARAM));
    }

    public boolean isPublishIvyDescriptors() {
        return Boolean.parseBoolean((String)this.env.get(this.prefix + PUBLISH_IVY_DESCRIPTORS_PARAM));
    }

    public boolean isMaven2Compatible() {
        return Boolean.parseBoolean((String)this.env.get(USE_M2_COMPATIBLE_PATTERNS_PARAM));
    }

    public String getIvyPattern() {
        return (String)this.env.get(this.prefix + IVY_PATTERN_PARAM);
    }

    public String getArtifactPattern() {
        return (String)this.env.get(this.prefix + ARTIFACT_PATTERN_PARAM);
    }

    public String getIncludePattern() {
        return (String)this.env.get(this.prefix + PUBLISH_INCLUDE_PATTERNS_PARAM);
    }

    public String getExcludePattern() {
        return (String)this.env.get(this.prefix + PUBLISH_EXCLUDE_PATTERNS_PARAM);
    }

    public boolean isFilterExcludedArtifactsFromBuild() {
        return Boolean.parseBoolean((String)this.env.get(this.prefix + FILTER_EXCLUDED_ARTIFACTS_FROM_BUILD_PARAM));
    }

    public String getResolutionRepo() {
        return (String)this.env.get(this.prefix + RESOLUTION_REPO_PARAM);
    }

    public String getArtifactSpecs() {
        return (String)this.env.get(this.prefix + ARTIFACT_SPECS_PARAM);
    }

    public void resetDeployerContextToDefault() {
        this.env.put(this.prefix + "artifactoryServerId", "-1");
        this.env.put(this.prefix + DEPLOYER_USERNAME_PARAM, "");
        this.env.put(this.prefix + DEPLOYER_PASSWORD_PARAM, "");
        this.env.put(USE_M2_COMPATIBLE_PATTERNS_PARAM, "true");
        this.env.put(this.prefix + IVY_PATTERN_PARAM, "");
        this.env.put(this.prefix + ARTIFACT_PATTERN_PARAM, "");
        this.env.put(this.prefix + FILTER_EXCLUDED_ARTIFACTS_FROM_BUILD_PARAM, "false");
        this.env.put(PUBLISH_ARTIFACTS_PARAM, "false");
        this.env.put(ENABLE_RELEASE_MANAGEMENT, "false");
        this.env.put(ENV_VARS_EXCLUDE_PATTERNS, ENV_VARS_TO_EXCLUDE);
    }

    public void resetPublishBuildInfo() {
        this.env.put(PUBLISH_BUILD_INFO_PARAM, "false");
    }

    public void resetResolverContextToDefault() {
        this.env.put(this.prefix + RESOLUTION_SERVER_ID_PARAM, "-1");
        this.env.put(this.prefix + RESOLVER_USERNAME_PARAM, "");
        this.env.put(this.prefix + RESOLVER_PASSWORD_PARAM, "");
        this.env.put(this.prefix + RESOLUTION_REPO_PARAM, "");
    }

    private List<String> splitAndTrim(String releaseProps) {
        ArrayList<String> tokens = Lists.newArrayList();
        for (String token : StringUtils.split((String)releaseProps, (String)",")) {
            if (!StringUtils.isNotBlank((String)token)) continue;
            tokens.add(token.trim());
        }
        return tokens;
    }

    public boolean shouldAggregateBuildInfo(@NotNull CommonTaskContext taskContext) {
        List taskDefinitions;
        if (this.isCaptureBuildInfo()) {
            return true;
        }
        if (this.isPublishBuildInfo() && TaskDefinitionHelper.isBuildPublishTaskExists(taskDefinitions = ((TaskContext)taskContext).getBuildContext().getRuntimeTaskDefinitions())) {
            this.resetPublishBuildInfo();
            return true;
        }
        return false;
    }

    public class ReleaseManagementContext {
        public static final String CREATE_VCS_TAG = "createVcsTag";
        public static final String USE_RELEASE_BRANCH = "useReleaseBranch";
        public static final String RELEASE_BRANCH = "releaseBranch";
        public static final String STAGING_COMMENT = "stagingComment";
        public static final String TAG_URL = "tagUrl";
        public static final String TAG_COMMENT = "tagComment";
        public static final String NEXT_DEVELOPMENT_COMMENT = "nextDevelopmentComment";
        public static final String REPO_KEY = "release.management.repoKey";

        public boolean isActivateReleaseManagement() {
            return Boolean.parseBoolean((String)PackageManagersContext.this.env.get(PackageManagersContext.ACTIVATE_RELEASE_MANAGEMENT));
        }

        public void setActivateReleaseManagement(boolean value) {
            PackageManagersContext.this.env.put(PackageManagersContext.ACTIVATE_RELEASE_MANAGEMENT, String.valueOf(value));
        }

        public String getTagUrl() {
            return (String)PackageManagersContext.this.env.get(TAG_URL);
        }

        public String getRepoKey() {
            return (String)PackageManagersContext.this.env.get(REPO_KEY);
        }

        public String getStagingComment() {
            return (String)PackageManagersContext.this.env.get(STAGING_COMMENT);
        }

        public boolean isUseReleaseBranch() {
            return Boolean.parseBoolean((String)PackageManagersContext.this.env.get(USE_RELEASE_BRANCH));
        }

        public String getReleaseBranch() {
            return (String)PackageManagersContext.this.env.get(RELEASE_BRANCH);
        }

        public String getTagComment() {
            return (String)PackageManagersContext.this.env.get(TAG_COMMENT);
        }

        public boolean isCreateVcsTag() {
            return Boolean.parseBoolean((String)PackageManagersContext.this.env.get(CREATE_VCS_TAG));
        }

        public String getNextDevelopmentComment() {
            return (String)PackageManagersContext.this.env.get(NEXT_DEVELOPMENT_COMMENT);
        }

        public List<ModuleVersionHolder> filterPropsForRelease(Map<String, String> props) {
            String nextIntegProps;
            ArrayList<ModuleVersionHolder> result = Lists.newArrayList();
            String releaseProps = (String)PackageManagersContext.this.env.get(PackageManagersContext.this.prefix + PackageManagersContext.RELEASE_PROPS);
            if (StringUtils.isNotBlank((String)releaseProps)) {
                ArrayList split = Lists.newArrayList(PackageManagersContext.this.splitAndTrim(releaseProps));
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    if (!Iterables.contains(split, entry.getKey())) continue;
                    result.add(new ModuleVersionHolder(entry.getKey(), entry.getValue(), true));
                }
            }
            if (StringUtils.isNotBlank((String)(nextIntegProps = (String)PackageManagersContext.this.env.get(PackageManagersContext.this.prefix + PackageManagersContext.NEXT_INTEG_PROPS)))) {
                ArrayList split = Lists.newArrayList(PackageManagersContext.this.splitAndTrim(nextIntegProps));
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    String propertyKey = entry.getKey();
                    if (!Iterables.contains(split, propertyKey)) continue;
                    try {
                        ModuleVersionHolder existingReleaseProp = Iterables.find(result, holder -> holder != null && holder.getKey().equals(propertyKey));
                        existingReleaseProp.setReleaseProp(false);
                    }
                    catch (NoSuchElementException e) {
                        result.add(new ModuleVersionHolder(propertyKey, entry.getValue(), false));
                    }
                }
            }
            return result;
        }

        public boolean isReleaseMgmtEnabled() {
            return Boolean.parseBoolean((String)PackageManagersContext.this.env.get(PackageManagersContext.ENABLE_RELEASE_MANAGEMENT));
        }

        public String getVcsTagBase() {
            return (String)PackageManagersContext.this.env.get(PackageManagersContext.this.prefix + PackageManagersContext.VCS_TAG_BASE);
        }

        public String getGitReleaseBranch() {
            return (String)PackageManagersContext.this.env.get(PackageManagersContext.this.prefix + PackageManagersContext.GIT_RELEASE_BRANCH);
        }

        public String getAlternativeTasks() {
            return (String)PackageManagersContext.this.env.get(PackageManagersContext.this.prefix + PackageManagersContext.ALTERNATIVE_TASKS);
        }

        public String getReleaseProps() {
            return (String)PackageManagersContext.this.env.get(PackageManagersContext.this.prefix + PackageManagersContext.RELEASE_PROPS);
        }

        public String getNextIntegProps() {
            return (String)PackageManagersContext.this.env.get(PackageManagersContext.this.prefix + PackageManagersContext.NEXT_INTEG_PROPS);
        }
    }
}

