/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration.util;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TaskConfiguratorHelperImpl {
    public void addJdkRequirement(@NotNull Set<Requirement> requirements, @NotNull TaskDefinition taskDefinition, @NotNull String cfgJdkLabel) {
        this.addSystemRequirementFromConfiguration(requirements, taskDefinition, cfgJdkLabel, "system.jdk");
    }

    public void addSystemRequirementFromConfiguration(@NotNull Set<Requirement> requirements, @NotNull TaskDefinition taskDefinition, @NotNull String cfgKey, @NotNull String requirementPrefix) {
        String builderLabel = (String)taskDefinition.getConfiguration().get(cfgKey);
        if (builderLabel != null) {
            requirements.add((Requirement)new RequirementImpl(requirementPrefix + "." + builderLabel, true, ".*"));
        }
    }

    public void populateContextWithConfiguration(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition, @NotNull Iterable<String> keys) {
        for (String key : keys) {
            context.put(key, taskDefinition.getConfiguration().get(key));
        }
    }

    public void populateTaskConfigMapWithActionParameters(@NotNull Map<String, String> config, @NotNull ActionParametersMap params, @NotNull Iterable<String> keys) {
        for (String key : keys) {
            config.put(key, params.getString(key));
        }
    }
}

