/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jfrog.bamboo.configuration.AbstractArtifactoryConfiguration;
import org.jfrog.bamboo.configuration.util.TaskConfigurationValidations;
import org.jfrog.bamboo.context.CollectBuildIssuesContext;

public class ArtifactoryCollectBuildIssuesConfiguration
extends AbstractArtifactoryConfiguration {
    public static final String CFG_CONFIG_SOURCE_TASK_CONFIGURATION = "taskConfiguration";
    private static final String KEY = "artifactoryCollectBuildIssuesBuilder";
    private static final Set<String> FIELDS_TO_COPY = CollectBuildIssuesContext.getFieldsToCopy();
    private static final String CFG_CONFIG_SOURCE_FILE = "file";
    private static final Map<String, String> CFG_CONFIG_SOURCE_OPTIONS = ImmutableMap.of("taskConfiguration", "Task Configuration", "file", "File");

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.populateConfigContext(context);
        context.put("serverConfigManager", this.serverConfigManager);
        context.put("selectedServerId", -1);
        context.put("build", context.get("plan"));
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.populateConfigContext(context);
        this.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
        context.put("selectedServerId", context.get("artifactory.task.collectBuildIssues.artifactoryServerId"));
        context.put("serverConfigManager", this.serverConfigManager);
        ArtifactoryCollectBuildIssuesConfiguration.populateDefaultBuildNameNumberInBuildContext(context);
        Map taskConfiguration = taskDefinition.getConfiguration();
        CollectBuildIssuesContext taskContext = new CollectBuildIssuesContext(taskConfiguration);
        if (StringUtils.isBlank(taskContext.getDeployerOverrideCredentialsChoice()) && StringUtils.isNoneBlank(taskContext.getUsername(), taskContext.getPassword())) {
            context.put("deployer.overrideCredentialsChoice", "usernamePassword");
        }
    }

    private void populateConfigContext(@NotNull Map<String, Object> context) {
        context.put("configSourceOptions", CFG_CONFIG_SOURCE_OPTIONS);
        context.put("artifactory.task.collectBuildIssues.config.source", CFG_CONFIG_SOURCE_TASK_CONFIGURATION);
    }

    @Override
    protected String getKey() {
        return KEY;
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map<String, String> configMap = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(configMap, params, FIELDS_TO_COPY);
        this.decryptFields(configMap);
        return configMap;
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        TaskConfigurationValidations.validateArtifactoryServerProvidedAndValid("artifactory.task.collectBuildIssues.artifactoryServerId", this.serverConfigManager, params, errorCollection);
        TaskConfigurationValidations.validateBuildNameNumber("artifactory.task.buildName", "artifactory.task.buildNumber", params, errorCollection);
    }
}

