/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.bamboo.builder;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.bamboo.context.PackageManagersContext;
import org.jfrog.bamboo.util.PluginProperties;

public class BuilderDependencyHelper
implements Serializable {
    private AdministrationConfiguration administrationConfiguration;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final String builderKey;

    public BuilderDependencyHelper(String builderKey) {
        this.builderKey = builderKey;
    }

    public String downloadDependenciesAndGetPath(File bambooTemp, String planKey, PackageManagersContext context, String dependencyName) throws IOException {
        File pluginDir;
        File builderDependencyDir;
        File[] planTempFiles;
        String pluginKey = PluginProperties.getPluginKey();
        String pluginDescriptorKey = PluginProperties.getPluginDescriptorKey();
        if (bambooTemp == null) {
            return null;
        }
        File planTemp = new File(bambooTemp, planKey);
        if (!planTemp.exists()) {
            planTemp.mkdir();
        }
        if (null != (planTempFiles = planTemp.listFiles())) {
            for (File buildDirChild : planTempFiles) {
                String buildDirChildName = buildDirChild.getName();
                if (!buildDirChildName.startsWith(pluginDescriptorKey) || buildDirChildName.equals(pluginKey) && !buildDirChildName.endsWith("-SNAPSHOT")) continue;
                FileUtils.deleteQuietly(buildDirChild);
                buildDirChild.delete();
            }
        }
        if ((builderDependencyDir = new File(pluginDir = new File(planTemp, pluginKey), this.builderKey)).isDirectory()) {
            List<String> files = Arrays.asList(builderDependencyDir.list());
            if (!files.isEmpty() && files.contains(dependencyName)) {
                return builderDependencyDir.getCanonicalPath();
            }
        } else {
            builderDependencyDir.mkdirs();
        }
        String bambooBaseUrl = this.getBambooBaseUrl(context);
        bambooBaseUrl = StringUtils.stripEnd((String)bambooBaseUrl, (String)"/");
        if (StringUtils.isNotBlank((String)bambooBaseUrl)) {
            StringBuilder builder = new StringBuilder(bambooBaseUrl);
            if (!bambooBaseUrl.endsWith("/")) {
                builder.append("/");
            }
            String dependencyBaseUrl = builder.append("download/resources/").append(pluginDescriptorKey).append("/builder/dependencies/").toString();
            try {
                this.downloadDependencies(dependencyBaseUrl, builderDependencyDir, dependencyName);
                return builderDependencyDir.getCanonicalPath();
            }
            catch (IOException ioe) {
                FileUtils.deleteDirectory(builderDependencyDir);
                throw ioe;
            }
        }
        return null;
    }

    public void setAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        this.administrationConfiguration = administrationConfiguration;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    private String getBambooBaseUrl(PackageManagersContext context) {
        if (this.administrationConfiguration != null) {
            return this.administrationConfiguration.getBaseUrl();
        }
        if (this.administrationConfigurationAccessor != null) {
            return this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
        }
        if (StringUtils.isNotBlank((String)context.getBaseUrl())) {
            return context.getBaseUrl();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadDependencies(String dependencyBaseUrl, File builderDependencyDir, String dependencyFileName) throws IOException {
        HttpClient client = new HttpClient();
        String dependencyUrl = dependencyBaseUrl + dependencyFileName;
        GetMethod getMethod = new GetMethod(dependencyUrl);
        try {
            int responseStatus;
            try {
                responseStatus = client.executeMethod((HttpMethod)getMethod);
            }
            catch (IOException e) {
                throw new IOException("Failed while invoking URL: " + dependencyUrl + "  " + e.getMessage());
            }
            if (responseStatus == 404) {
                throw new IOException("Unable to find required dependency: " + dependencyUrl);
            }
            if (responseStatus != 200) {
                throw new IOException("Error while requesting required dependency: " + dependencyUrl + ". Status: " + responseStatus + ", Message: " + getMethod.getStatusText());
            }
            try (InputStream responseBodyAsStream = getMethod.getResponseBodyAsStream();){
                if (responseBodyAsStream == null) {
                    throw new IOException("Requested dependency: " + dependencyUrl + ", but received a null response stream.");
                }
                File file = new File(builderDependencyDir, dependencyFileName);
                if (file.isFile()) {
                    return;
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    IOUtils.copy(responseBodyAsStream, (OutputStream)fileOutputStream);
                }
            }
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

