/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.io.XmlPlexusConfigurationReader;

public class PlexusTools {
    public static PlexusConfiguration buildConfiguration(String resourceName, Reader configuration) throws PlexusConfigurationException {
        try {
            XmlPlexusConfigurationReader reader = new XmlPlexusConfigurationReader();
            PlexusConfiguration result = reader.read(configuration);
            return result;
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusConfigurationException("PlexusConfigurationException building configuration from: " + resourceName, e);
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("IO error building configuration from: " + resourceName, e);
        }
    }

    public static PlexusConfiguration buildConfiguration(String configuration) throws PlexusConfigurationException {
        return PlexusTools.buildConfiguration("<String Memory Resource>", new StringReader(configuration));
    }

    public static ComponentDescriptor<?> buildComponentDescriptor(String configuration, ClassRealm realm) throws PlexusConfigurationException {
        return PlexusTools.buildComponentDescriptor(PlexusTools.buildConfiguration(configuration), realm);
    }

    public static ComponentDescriptor<?> buildComponentDescriptor(PlexusConfiguration configuration) throws PlexusConfigurationException {
        return PlexusTools.buildComponentDescriptorImpl(configuration, null);
    }

    public static ComponentDescriptor<?> buildComponentDescriptor(PlexusConfiguration configuration, ClassRealm realm) throws PlexusConfigurationException {
        if (realm == null) {
            throw new NullPointerException("realm is null");
        }
        return PlexusTools.buildComponentDescriptorImpl(configuration, realm);
    }

    private static ComponentDescriptor<?> buildComponentDescriptorImpl(PlexusConfiguration configuration, ClassRealm realm) throws PlexusConfigurationException {
        PlexusConfiguration[] requirements;
        ComponentDescriptor<Object> cd2;
        String implementation = configuration.getChild("implementation").getValue();
        if (implementation == null) {
            throw new PlexusConfigurationException("implementation is null");
        }
        try {
            if (realm != null) {
                Class<?> implementationClass = realm.loadClass(implementation);
                cd2 = new ComponentDescriptor(implementationClass, realm);
            } else {
                cd2 = new ComponentDescriptor();
                cd2.setImplementation(implementation);
            }
        }
        catch (Throwable e) {
            throw new PlexusConfigurationException("Can not load implementation class " + implementation + " from realm " + realm, e);
        }
        cd2.setRole(configuration.getChild("role").getValue());
        cd2.setRoleHint(configuration.getChild("role-hint").getValue());
        cd2.setVersion(configuration.getChild("version").getValue());
        cd2.setComponentType(configuration.getChild("component-type").getValue());
        cd2.setInstantiationStrategy(configuration.getChild("instantiation-strategy").getValue());
        cd2.setLifecycleHandler(configuration.getChild("lifecycle-handler").getValue());
        cd2.setComponentProfile(configuration.getChild("component-profile").getValue());
        cd2.setComponentComposer(configuration.getChild("component-composer").getValue());
        cd2.setComponentConfigurator(configuration.getChild("component-configurator").getValue());
        cd2.setComponentFactory(configuration.getChild("component-factory").getValue());
        cd2.setDescription(configuration.getChild("description").getValue());
        cd2.setAlias(configuration.getChild("alias").getValue());
        String s2 = configuration.getChild("isolated-realm").getValue();
        if (s2 != null) {
            cd2.setIsolatedRealm(s2.equals("true"));
        }
        cd2.setConfiguration(configuration.getChild("configuration"));
        for (PlexusConfiguration requirement : requirements = configuration.getChild("requirements").getChildren("requirement")) {
            ComponentRequirement cr;
            PlexusConfiguration[] hints = requirement.getChild("role-hints").getChildren("role-hint");
            if (hints != null && hints.length > 0) {
                cr = new ComponentRequirementList();
                LinkedList<String> hintList = new LinkedList<String>();
                for (PlexusConfiguration hint : hints) {
                    hintList.add(hint.getValue());
                }
                ((ComponentRequirementList)cr).setRoleHints(hintList);
            } else {
                cr = new ComponentRequirement();
                cr.setRoleHint(requirement.getChild("role-hint").getValue());
            }
            cr.setRole(requirement.getChild("role").getValue());
            cr.setOptional(Boolean.parseBoolean(requirement.getChild("optional").getValue()));
            cr.setFieldName(requirement.getChild("field-name").getValue());
            cd2.addRequirement(cr);
        }
        return cd2;
    }

    public static ComponentSetDescriptor buildComponentSet(PlexusConfiguration c) throws PlexusConfigurationException {
        return PlexusTools.buildComponentSet(c, null);
    }

    public static ComponentSetDescriptor buildComponentSet(PlexusConfiguration c, ClassRealm realm) throws PlexusConfigurationException {
        PlexusConfiguration[] dependencies;
        PlexusConfiguration[] components;
        ComponentSetDescriptor csd = new ComponentSetDescriptor();
        for (PlexusConfiguration component : components = c.getChild("components").getChildren("component")) {
            csd.addComponentDescriptor(PlexusTools.buildComponentDescriptorImpl(component, realm));
        }
        for (PlexusConfiguration d : dependencies = c.getChild("dependencies").getChildren("dependency")) {
            ComponentDependency cd2 = new ComponentDependency();
            cd2.setArtifactId(d.getChild("artifact-id").getValue());
            cd2.setGroupId(d.getChild("group-id").getValue());
            String type = d.getChild("type").getValue();
            if (type != null) {
                cd2.setType(type);
            }
            cd2.setVersion(d.getChild("version").getValue());
            csd.addDependency(cd2);
        }
        return csd;
    }

    public static void writeConfiguration(PrintStream out, PlexusConfiguration configuration) throws PlexusConfigurationException {
        PlexusTools.writeConfiguration(out, configuration, "");
    }

    private static void writeConfiguration(PrintStream out, PlexusConfiguration configuration, String indent) throws PlexusConfigurationException {
        out.print(indent + "<" + configuration.getName());
        String[] atts = configuration.getAttributeNames();
        if (atts.length > 0) {
            for (String att : atts) {
                out.print("\n" + indent + "  " + att + "='" + configuration.getAttribute(att) + "'");
            }
        }
        PlexusConfiguration[] pc = configuration.getChildren();
        if (configuration.getValue() != null && configuration.getValue().trim().length() > 0 || pc.length > 0) {
            out.print(">" + (configuration.getValue() == null ? "" : configuration.getValue().trim()));
            if (pc.length > 0) {
                out.println();
                for (PlexusConfiguration aPc : pc) {
                    PlexusTools.writeConfiguration(out, aPc, indent + "  ");
                }
                out.print(indent);
            }
            out.println("</" + configuration.getName() + ">");
        } else {
            out.println("/>");
        }
    }
}

