/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.Os;
import org.slf4j.Logger;

public final class CLIReportingUtils {
    public static final long MB = 0x100000L;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    public static final String BUILD_VERSION_PROPERTY = "version";

    public static String showVersion() {
        String ls = System.lineSeparator();
        Properties properties = CLIReportingUtils.getBuildProperties();
        StringBuilder version = new StringBuilder(256);
        version.append(MessageUtils.buffer().strong(CLIReportingUtils.createMavenVersionString(properties))).append(ls);
        version.append(CLIReportingUtils.reduce(properties.getProperty("distributionShortName") + " home: " + System.getProperty("maven.home", "<unknown Maven home>"))).append(ls);
        version.append("Java version: ").append(System.getProperty("java.version", "<unknown Java version>")).append(", vendor: ").append(System.getProperty("java.vendor", "<unknown vendor>")).append(", runtime: ").append(System.getProperty("java.home", "<unknown runtime>")).append(ls);
        version.append("Default locale: ").append(Locale.getDefault()).append(", platform encoding: ").append(System.getProperty("file.encoding", "<unknown encoding>")).append(ls);
        version.append("OS name: \"").append(Os.OS_NAME).append("\", version: \"").append(Os.OS_VERSION).append("\", arch: \"").append(Os.OS_ARCH).append("\", family: \"").append(Os.OS_FAMILY).append('\"');
        return version.toString();
    }

    public static String showVersionMinimal() {
        Properties properties = CLIReportingUtils.getBuildProperties();
        String version = CLIReportingUtils.reduce(properties.getProperty(BUILD_VERSION_PROPERTY));
        return version != null ? version : "<version unknown>";
    }

    static String createMavenVersionString(Properties buildProperties) {
        String timestamp = CLIReportingUtils.reduce(buildProperties.getProperty("timestamp"));
        String version = CLIReportingUtils.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = CLIReportingUtils.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = CLIReportingUtils.reduce(buildProperties.getProperty("distributionName"));
        String msg = distributionName + " ";
        msg = msg + (version != null ? version : "<version unknown>");
        if (rev != null || timestamp != null) {
            msg = msg + " (";
            msg = msg + (rev != null ? rev : "");
            if (StringUtils.isNotBlank(timestamp)) {
                String ts = CLIReportingUtils.formatTimestamp(Long.parseLong(timestamp));
                msg = msg + (rev != null ? "; " : "") + ts;
            }
            msg = msg + ")";
        }
        return msg;
    }

    private static String reduce(String s2) {
        return s2 != null ? (s2.startsWith("${") && s2.endsWith("}") ? null : s2) : null;
    }

    static Properties getBuildProperties() {
        Properties properties = new Properties();
        try (InputStream resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
        return properties;
    }

    public static void showError(Logger logger, String message, Throwable e, boolean showStackTrace) {
        if (showStackTrace) {
            logger.error(message, e);
        } else {
            logger.error(message);
            if (e != null) {
                logger.error(e.getMessage());
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    logger.error("Caused by: {}", (Object)cause.getMessage());
                }
            }
        }
    }

    public static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return sdf.format(new Date(timestamp));
    }

    public static String formatDuration(long duration) {
        long ms = duration % 1000L;
        long s2 = duration / 1000L % 60L;
        long m3 = duration / 60000L % 60L;
        long h2 = duration / 3600000L % 24L;
        long d = duration / 86400000L;
        String format = d > 0L ? "%d d %02d:%02d h" : (h2 > 0L ? "%2$02d:%3$02d h" : (m3 > 0L ? "%3$02d:%4$02d min" : "%4$d.%5$03d s"));
        return String.format(format, d, h2, m3, s2, ms);
    }
}

