/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public final class MatcherHelper {
    private MatcherHelper() {
    }

    public static boolean matches(PatternMatcher m3, String expression, String input) {
        return m3.getMatcher(expression).matches(input);
    }

    public static boolean matches(PatternMatcher m3, ModuleId exp, ModuleId mid) {
        return MatcherHelper.matches(m3, exp.getOrganisation(), mid.getOrganisation()) && MatcherHelper.matches(m3, exp.getName(), mid.getName());
    }

    public static boolean matches(PatternMatcher m3, ModuleRevisionId exp, ModuleRevisionId mrid) {
        return MatcherHelper.matches(m3, exp.getOrganisation(), mrid.getOrganisation()) && MatcherHelper.matches(m3, exp.getName(), mrid.getName()) && MatcherHelper.matches(m3, exp.getRevision(), mrid.getRevision());
    }

    public static boolean matches(PatternMatcher m3, ArtifactId exp, ArtifactId aid) {
        return MatcherHelper.matches(m3, exp.getModuleId(), aid.getModuleId()) && MatcherHelper.matches(m3, exp.getName(), aid.getName()) && MatcherHelper.matches(m3, exp.getExt(), aid.getExt()) && MatcherHelper.matches(m3, exp.getType(), aid.getType());
    }

    public static boolean isExact(PatternMatcher m3, ModuleRevisionId exp) {
        return MatcherHelper.isExact(m3, exp.getOrganisation()) && MatcherHelper.isExact(m3, exp.getName()) && MatcherHelper.isExact(m3, exp.getRevision());
    }

    public static boolean isExact(PatternMatcher m3, ModuleId exp) {
        return MatcherHelper.isExact(m3, exp.getOrganisation()) && MatcherHelper.isExact(m3, exp.getName());
    }

    public static boolean isExact(PatternMatcher m3, String exp) {
        return m3.getMatcher(exp).isExact();
    }
}

