/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.function.BiPredicate;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.common.function.FunctionWithException;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.DeleteClientOptions;
import com.perforce.p4java.option.server.GetClientTemplateOptions;
import com.perforce.p4java.option.server.SwitchClientViewOptions;
import com.perforce.p4java.option.server.UpdateClientOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IClientDelegator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ClientDelegator
extends BaseDelegator
implements IClientDelegator {
    public ClientDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public IClient getClient(String clientName) throws ConnectionException, RequestException, AccessException {
        Validate.notBlank(clientName, "Null or empty client name passed in updateClient()", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, new String[]{"-o", clientName}, null);
        return ClientDelegator.getClientOrNullFromHelixResultMap(resultMaps, null, this.server, new BiPredicate<Map<String, Object>, GetClientTemplateOptions>(){

            @Override
            public boolean test(Map<String, Object> map, GetClientTemplateOptions opts) {
                return ResultMapParser.isExistClientOrLabelOrUser(map);
            }
        }, P4JavaExceptions.rethrowFunction(new FunctionWithException<Map<String, Object>, Boolean>(){

            @Override
            public Boolean apply(Map<String, Object> map) throws P4JavaException {
                return !ResultMapParser.handleErrorStr(map) && !ResultMapParser.isInfoMessage(map);
            }
        }));
    }

    @Override
    public IClient getClient(@Nonnull IClientSummary clientSummary) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(clientSummary);
        return this.getClient(clientSummary.getName());
    }

    @Override
    public IClient getClientTemplate(String clientName) throws ConnectionException, RequestException, AccessException {
        return this.getClientTemplate(clientName, false);
    }

    @Override
    public IClient getClientTemplate(String clientName, boolean allowExistent) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getClientTemplate(clientName, new GetClientTemplateOptions(allowExistent));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public IClient getClientTemplate(@Nonnull String clientName, GetClientTemplateOptions getClientTemplateOptions) throws P4JavaException {
        Validate.notBlank(clientName, "Null or empty client name passed in updateClient()", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)getClientTemplateOptions, null, new String[]{"-o", clientName}, (IServer)this.server), null);
        return ClientDelegator.getClientOrNullFromHelixResultMap(resultMaps, getClientTemplateOptions, this.server, new BiPredicate<Map<String, Object>, GetClientTemplateOptions>(){

            @Override
            public boolean test(Map<String, Object> map, GetClientTemplateOptions opts) {
                return ResultMapParser.isNonExistClientOrLabelOrUser(map) || Objects.nonNull(opts) && opts.isAllowExistent();
            }
        }, P4JavaExceptions.rethrowFunction(new FunctionWithException<Map<String, Object>, Boolean>(){

            @Override
            public Boolean apply(Map<String, Object> map) throws P4JavaException {
                return !ResultMapParser.handleErrorStr(map) && !ResultMapParser.isInfoMessage(map);
            }
        }));
    }

    @Override
    public String createClient(@Nonnull IClient newClient) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(newClient);
        ClientDelegator.replaceWithUnderscoreIfClientNameContainsWhitespacesOrTabs(newClient);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(newClient));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public void createTempClient(@Nonnull IClient newClient) throws ConnectionException, AccessException, RequestException {
        Validate.notNull(newClient);
        ClientDelegator.replaceWithUnderscoreIfClientNameContainsWhitespacesOrTabs(newClient);
        this.server.setCurrentClient(newClient);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, new String[]{"-x", "-i"}, InputMapper.map(newClient));
        for (Map<String, Object> resultMap : resultMaps) {
            ResultMapParser.handleErrorStr(resultMap);
        }
    }

    @Override
    public String updateClient(@Nonnull IClient client) throws ConnectionException, RequestException, AccessException {
        Validate.notNull(client);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, new String[]{"-i"}, InputMapper.map(client));
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public String updateClient(@Nonnull IClient client, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.updateClient(client, new UpdateClientOptions(force));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String updateClient(@Nonnull IClient client, UpdateClientOptions opts) throws P4JavaException {
        Validate.notNull(client);
        Validate.notBlank(client.getName(), "Null or empty client name passed in updateClient()", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, "-i", (IServer)this.server), InputMapper.map(client));
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }

    @Override
    public String deleteClient(String clientName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteClient(clientName, new DeleteClientOptions(force));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteClient(String clientName, DeleteClientOptions opts) throws P4JavaException {
        Validate.notBlank(clientName, "Null or empty client name passed in updateClient()", new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, new String[]{"-d", clientName}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public String switchClientView(String templateClientName, String targetClientName, SwitchClientViewOptions opts) throws P4JavaException {
        Validate.notBlank(templateClientName, "Template client name shouldn't blank", new Object[0]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("-s", "-t", templateClientName));
        if (StringUtils.isNotBlank(targetClientName)) {
            args.add(targetClientName);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, args.toArray(new String[args.size()]), (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public String switchStreamView(String streamPath, String targetClientName, SwitchClientViewOptions opts) throws P4JavaException {
        Validate.notBlank(streamPath, "Stream path shouldn't blank", new Object[0]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("-s", "-S", streamPath));
        if (StringUtils.isNotBlank(targetClientName)) {
            args.add(targetClientName);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENT, Parameters.processParameters((Options)opts, null, args.toArray(new String[args.size()]), (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    private static void replaceWithUnderscoreIfClientNameContainsWhitespacesOrTabs(IClient newClient) {
        String TABS = "\t";
        String name = newClient.getName();
        if (StringUtils.containsAny((CharSequence)name, " ", "\t")) {
            String newClientName = StringUtils.replacePattern(name, "\\s", "_");
            newClient.setName(newClientName);
        }
    }

    private static IClient getClientOrNullFromHelixResultMap(@Nullable List<Map<String, Object>> resultMaps, @Nullable GetClientTemplateOptions opts, @Nonnull IOptionsServer server, @Nonnull BiPredicate<Map<String, Object>, GetClientTemplateOptions> conditions, @Nonnull Function<Map<String, Object>, Boolean> handle) throws AccessException, RequestException {
        Client client = null;
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map) || !handle.apply(map).booleanValue() || !conditions.test(map, opts)) continue;
                client = new Client(server, map);
            }
        }
        return client;
    }
}

