/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IExtension;
import com.perforce.p4java.impl.generic.core.ExtensionSummary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Extension
extends ExtensionSummary
implements IExtension {
    private String extDescription;
    private String extMaxScriptTime;
    private String extMaxScriptMem;
    private String owner;
    private String update;
    private String description;
    private Map<String, String> extConfig;
    private List<String> extAllowedGroups;
    private String extP4USER;
    private String extDebug;

    public Extension() {
    }

    public Extension(Map<String, Object> map) {
        super(map, false);
        if (map != null) {
            try {
                Object extAllowedGroups;
                this.extDescription = (String)map.get("ExtDescription");
                this.extMaxScriptTime = (String)map.get("ExtMaxScriptTime");
                this.extMaxScriptMem = (String)map.get("ExtMaxScriptMem");
                this.owner = (String)map.get("Owner");
                this.update = (String)map.get("Update");
                this.description = (String)map.get("Description");
                Object extConfig = map.get("ExtConfig");
                if (extConfig != null) {
                    HashMap<String, String> configMap = new HashMap<String, String>();
                    String configStr = (String)extConfig;
                    StringTokenizer configLines = new StringTokenizer(configStr, "\n");
                    while (configLines.hasMoreTokens()) {
                        String str = configLines.nextToken();
                        String[] pairs = StringUtils.split(str, ": ", 2);
                        String key = pairs[0];
                        String value = "";
                        if (pairs.length > 1) {
                            value = pairs[1];
                        }
                        configMap.put(key, value);
                    }
                    this.extConfig = configMap;
                }
                if ((extAllowedGroups = map.get("ExtAllowedGroups")) instanceof List) {
                    List unknown = (List)extAllowedGroups;
                    this.extAllowedGroups = unknown.stream().map(String::valueOf).collect(Collectors.toList());
                }
                this.extP4USER = (String)map.get("ExtP4USER");
                this.extDebug = (String)map.get("ExtDebug");
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in Extension constructor: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
            }
        }
    }

    @Override
    public String getExtDescription() {
        return this.extDescription;
    }

    @Override
    public String getExtMaxScriptTime() {
        return this.extMaxScriptTime;
    }

    @Override
    public String getExtMaxScriptMem() {
        return this.extMaxScriptMem;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getUpdate() {
        return this.update;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, String> getExtConfig() {
        return this.extConfig;
    }

    @Override
    public List<String> getExtAllowedGroups() {
        return this.extAllowedGroups;
    }

    @Override
    public String getExtP4USER() {
        return this.extP4USER;
    }

    @Override
    public String getExtDebug() {
        return this.extDebug;
    }

    @Override
    public void setExtDescription(String extDescription) {
        this.extDescription = extDescription;
    }

    @Override
    public void setExtMaxScriptTime(String extMaxScriptTime) {
        this.extMaxScriptTime = extMaxScriptTime;
    }

    @Override
    public void setExtMaxScriptMem(String extMaxScriptMem) {
        this.extMaxScriptMem = extMaxScriptMem;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public void setUpdate(String update) {
        this.update = update;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setExtConfig(Map<String, String> extConfig) {
        this.extConfig = extConfig;
    }

    @Override
    public void setExtAllowedGroups(List<String> extAllowedGroups) {
        this.extAllowedGroups = extAllowedGroups;
    }

    @Override
    public void setExtP4USER(String extP4USER) {
        this.extP4USER = extP4USER;
    }

    @Override
    public void setExtDebug(String extDebug) {
        this.extDebug = extDebug;
    }
}

