/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.ServerFactory;
import com.perforce.p4java.server.callback.IParallelCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DefaultParallelSync
implements IParallelCallback {
    @Override
    public boolean transmit(CommandEnv cmdEnv, int threads, HashMap<String, String> flags, ArrayList<String> args) {
        Thread[] parallelSyncThreads = new Thread[threads];
        try {
            int x;
            for (x = 0; x < threads; ++x) {
                parallelSyncThreads[x] = new Thread(this.createRunnable(cmdEnv, x, flags, args));
                parallelSyncThreads[x].start();
            }
            for (x = 0; x < threads; ++x) {
                parallelSyncThreads[x].join();
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private Runnable createRunnable(final CommandEnv cmdEnv, int thread, HashMap<String, String> flags, final List<String> args) {
        class RunnableSync
        implements Runnable {
            RunnableSync() {
            }

            @Override
            public void run() {
                IServer server = null;
                try {
                    Properties props = new Properties(cmdEnv.getServer().getProperties());
                    server = ServerFactory.getOptionsServer(cmdEnv.getServer().getServerAddressDetails().getUri(), props);
                    server.setCurrentServerInfo(cmdEnv.getServer().getCurrentServerInfo());
                    server.setUserName(cmdEnv.getServer().getUserName());
                    server.setCurrentClient(cmdEnv.getServer().getCurrentClient());
                    server.setWorkingDirectory(cmdEnv.getServer().getWorkingDirectory());
                    server.setTrustFilePath(cmdEnv.getServer().getTrustFilePath());
                    server.setTicketsFilePath(cmdEnv.getServer().getTicketsFilePath());
                    server.setCharsetName(cmdEnv.getServer().getCharsetName());
                    server.connect();
                    server.setAuthTicket(cmdEnv.getServer().getAuthTicket());
                    Map[] results = server.execMapCmd("transmit", args.toArray(new String[0]), null);
                    DefaultParallelSync.this.handleResults(results, cmdEnv);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (server != null && server.isConnected()) {
                        try {
                            server.disconnect();
                        }
                        catch (P4JavaException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        }
        return new RunnableSync();
    }

    private synchronized void handleResults(Map<String, Object>[] results, CommandEnv cmdEnv) {
        if (results != null) {
            for (Map<String, Object> item : results) {
                cmdEnv.handleResult(item);
            }
        }
    }
}

