/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.atlassian.plugin.spring.scanner.util.BeanDefinitionChecker;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;

public class ClassIndexBeanDefinitionScanner {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry registry;
    private final String profileName;
    private final Integer autowireDefault;
    private final BundleContext bundleContext;

    public ClassIndexBeanDefinitionScanner(BeanDefinitionRegistry registry, String profileName, Integer autowireDefault, BundleContext bundleContext) {
        this.registry = registry;
        this.profileName = profileName;
        this.autowireDefault = autowireDefault;
        this.bundleContext = bundleContext;
    }

    protected Set<BeanDefinitionHolder> doScan() {
        LinkedHashSet<BeanDefinitionHolder> beanDefinitions = new LinkedHashSet<BeanDefinitionHolder>();
        Map<String, BeanDefinition> namesAndDefinitions = this.findCandidateComponents();
        for (Map.Entry<String, BeanDefinition> nameAndDefinition : namesAndDefinitions.entrySet()) {
            if (!BeanDefinitionChecker.needToRegister(nameAndDefinition.getKey(), nameAndDefinition.getValue(), this.registry)) continue;
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(nameAndDefinition.getValue(), nameAndDefinition.getKey());
            beanDefinitions.add(definitionHolder);
            this.registerBeanDefinition(definitionHolder, this.registry);
        }
        return beanDefinitions;
    }

    public Map<String, BeanDefinition> findCandidateComponents() {
        HashMap<String, BeanDefinition> candidates = new HashMap<String, BeanDefinition>();
        TreeSet<String> beanTypeAndNames = new TreeSet<String>();
        String[] profileNames = AnnotationIndexReader.splitProfiles(this.profileName);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String fileToRead : AnnotationIndexReader.getIndexFilesForProfiles(profileNames, "component")) {
            beanTypeAndNames.addAll(AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, contextClassLoader, this.bundleContext));
        }
        for (String beanTypeAndName : beanTypeAndNames) {
            String[] typeAndName = StringUtils.split((String)beanTypeAndName, (String)"#");
            String beanClassName = typeAndName[0];
            String beanName = "";
            if (typeAndName.length > 1) {
                beanName = typeAndName[1];
            }
            if (StringUtils.isBlank((String)beanName)) {
                beanName = Introspector.decapitalize(ClassUtils.getShortName((String)beanClassName));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Found candidate bean '%s' from class '%s'", beanName, beanClassName));
            }
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)beanClassName);
            if (null != this.autowireDefault) {
                beanDefinitionBuilder.setAutowireMode(this.autowireDefault.intValue());
            }
            candidates.put(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
        return candidates;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
    }
}

