/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.kantega.samllib.spi.ServiceProviderSpi;

public class CookieUtil {
    private static final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
    public static final String LAST_ACCOUNT_COOKIE = "idp_last_account";
    public static final String MANUAL_LOGIN_AFTER_LOGOUT = "manual_login_after_logout";

    private static String getCookieString(String cookieName, Object cookieValue, String discoverPath) {
        long maxAge = TimeUnit.DAYS.toMillis(365L);
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date expiresDate = new Date(System.currentTimeMillis() + maxAge);
        return cookieName + "=\"" + cookieValue.toString() + "\"; Version: 1; Comment=HttpOnly; Max-Age=" + maxAge + "; Expires=" + df.format(expiresDate) + "; Path=" + discoverPath + ";";
    }

    public static void setLastIdpAccountCookie(String idpId, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(true);
        String username = (String)session.getAttribute(USERNAME_ATTR);
        session.removeAttribute(USERNAME_ATTR);
        String cookieVal = username == null ? idpId : idpId + ":" + username;
        String discoverPath = request.getContextPath() + "/plugins/servlet/no.kantega.saml";
        response.addHeader("Set-Cookie", CookieUtil.getCookieString(LAST_ACCOUNT_COOKIE, cookieVal, discoverPath));
    }

    public static void setTraditionalLoginCookie(HttpServletRequest req, HttpServletResponse response) {
        response.addHeader("Set-Cookie", CookieUtil.getCookieString("hasUsedTraditionalLogin", true, "/"));
    }

    public static Cookie getCookie(HttpServletRequest req, String cookieName) {
        try {
            return (Cookie)((Stream)Option.of((Object)req.getCookies()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> cookie.getName().equals(cookieName)).head();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static void removeCookie(HttpServletRequest req, HttpServletResponse response, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            return;
        }
    }

    public static Option<String> getPreviouslyKnownLoginUsername(HttpServletRequest req) {
        return ((Stream)Option.of((Object)req.getCookies()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> LAST_ACCOUNT_COOKIE.equals(cookie.getName())).map(Cookie::getValue).map(value -> value.contains(":") ? value.substring(value.indexOf(":") + 1) : "").headOption();
    }

    public static Option<String> getPreviouslyKnownLoginId(HttpServletRequest req) {
        return ((Stream)Option.of((Object)req.getCookies()).map(Stream::of).getOrElse((Object)Stream.empty())).filter(cookie -> LAST_ACCOUNT_COOKIE.equals(cookie.getName())).map(Cookie::getValue).map(value -> value.contains(":") ? value.substring(0, value.indexOf(":")) : value).headOption();
    }

    public static void keepUsernameInSession(HttpServletRequest req, String username) {
        if (username != null) {
            req.getSession().setAttribute(USERNAME_ATTR, (Object)username);
        } else {
            req.getSession().removeAttribute(USERNAME_ATTR);
        }
    }
}

