/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.util;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.util.concurrent.NotNull;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptInjector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final WebResourceManager webResourceManager;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private String disableJsPath = null;
    private String disableCssPath = null;
    private String samlJsPath = null;
    private String runtime = null;
    private String contextPath = null;

    public ScriptInjector(WebResourceManager webResourceManager, TemplateRenderer templateRenderer, KerbConfManager kerbConfManager, IdpConfManager idpConfManager, HostApp hostApp) {
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = kerbConfManager;
        this.webResourceManager = webResourceManager;
        this.idpConfManager = idpConfManager;
        this.hostApp = hostApp;
    }

    @NotNull
    public StringWriter prepareInjectScript(boolean isTraditionalLoginDisabled, boolean enableFederatedSSO, boolean manualLogin, boolean shouldDisableRedirect, int samlRedirectDelay, String emailFromHeader, String jsmSignupEmailUnblockedList, String jsmUrlFormUrlparts) throws IOException {
        StringWriter inject = new StringWriter();
        this.log.debug("Writing js and css enhancment. isTraditionalLoginDisabled: " + isTraditionalLoginDisabled + " enableFederatedSSO: " + enableFederatedSSO + " manualLogin: " + manualLogin + " samlRedirectDelay: " + samlRedirectDelay);
        this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-login");
        this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-disable-login");
        this.runtime = this.appendResource(inject, this.runtime, "src=\"(.*" + PluginKey.getPluginKeyBasepart() + ":runtime.*\\.js).*");
        this.contextPath = this.appendResource(inject, this.contextPath, "src=\"(.*com.atlassian.plugins.atlassian-plugins-webresource-plugin:context-path.*\\.js).*");
        if (isTraditionalLoginDisabled) {
            this.disableJsPath = this.appendResource(inject, this.disableJsPath, "src=\"(.*disable-login.*\\.js).*");
            this.disableCssPath = this.appendResource(inject, this.disableCssPath, "href=\"(.*disable-login.*\\.css).*");
        }
        if (enableFederatedSSO) {
            this.samlJsPath = this.appendResource(inject, this.samlJsPath, "src=\"(.*saml-login.*\\.js).*");
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
            model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
            model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
            model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
            model.put("shouldLoginManually", manualLogin);
            model.put("shouldDisableRedirect", shouldDisableRedirect);
            model.put("shouldDoSsoAfterLogout", this.idpConfManager.isAnyProviderForcingReLoginAfterLogout());
            model.put("loginPageUrl", this.hostApp.getLoginPage());
            model.put("redirectProgressDelay", samlRedirectDelay + "s");
            model.put("useIdpPriority", this.idpConfManager.isUseIdpPriority());
            if (StringUtils.isNotBlank((String)emailFromHeader) || StringUtils.isNotBlank((String)jsmSignupEmailUnblockedList)) {
                model.put("emailFromHeader", emailFromHeader);
                model.put("jsmSignupEmailUnblockedList", jsmSignupEmailUnblockedList);
                model.put("jsmUrlFormUrlparts", jsmUrlFormUrlparts);
                this.templateRenderer.render("templates/atlaskerb/jsm-signup-email.vm", model, (Writer)inject);
            }
            this.templateRenderer.render("templates/atlaskerb/saml-login.vm", model, (Writer)inject);
        }
        return inject;
    }

    private String appendResource(StringWriter inject, String presetValue, String searchGroup) {
        String resources = this.webResourceManager.getRequiredResources(UrlMode.RELATIVE);
        String src = presetValue != null ? presetValue : ScriptInjector.interpretRegexAndReturnGroup(resources, searchGroup);
        if (src != null) {
            if (src.endsWith(".js")) {
                inject.append("<script src=\"").append(src).append("\"></script>");
            } else {
                inject.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(src).append("\">");
            }
        }
        return src;
    }

    private static String interpretRegexAndReturnGroup(String text, String regexPattern) {
        Matcher m = Pattern.compile(regexPattern).matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

