/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class JiraMobileFilter
implements Filter {
    private final boolean isJira;
    private final IdpConfManager idpConfManager;
    private final WebResourceManager webResourceManager;
    private final TemplateRenderer templateRenderer;
    private final HostApp hostApp;

    @Inject
    public JiraMobileFilter(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport WebResourceManager webResourceManager, IdpConfManager idpConfManager, HostAppFactory hostApp) {
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.hostApp = hostApp.getInstance();
        this.idpConfManager = idpConfManager;
        this.isJira = applicationProperties.getDisplayName().equalsIgnoreCase("jira");
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isJira) {
            chain.doFilter(request, response);
            return;
        }
        final HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        new PluginKey();
        this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":entrypoint-saml-login");
        final boolean manualLogin = this.hostApp.shouldLoginManually(req, resp) && !this.idpConfManager.isAnyProviderForcingReLoginAfterLogout();
        chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper(resp){

            public PrintWriter getWriter() throws IOException {
                return new InjectingPrintWriter(super.getWriter(), req.getContextPath(), manualLogin, JiraMobileFilter.this.idpConfManager.getRedirectProgressDelay());
            }
        });
    }

    public void destroy() {
    }

    private class InjectingPrintWriter
    extends PrintWriter {
        private final String contextPath;
        private final boolean manualLogin;
        private final int redirectDelay;

        public InjectingPrintWriter(PrintWriter writer, String contextPath, boolean manualLogin, int redirectDelay) {
            super(writer);
            this.contextPath = contextPath;
            this.manualLogin = manualLogin;
            this.redirectDelay = redirectDelay;
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            StringWriter writer = new StringWriter();
            this.appendScript(writer, PluginKey.getPluginKeyBasepart() + ":entrypoint-saml-login/saml-login.js");
            try {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("shouldLoginManually", this.manualLogin);
                model.put("redirectProgressDelay", this.redirectDelay + "s");
                model.put("useIdpPriority", JiraMobileFilter.this.idpConfManager.isUseIdpPriority());
                JiraMobileFilter.this.templateRenderer.render("templates/atlaskerb/saml-login.vm", model, (Writer)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String out = csq.toString();
            return super.append(out.replace("</body>", writer + "</body>"));
        }

        private void appendScript(StringWriter inject, String file) {
            String src = this.contextPath + "/download/resources/" + file;
            inject.append("<script src=\"").append(src).append("\"></script>");
        }
    }
}

