/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.model.Directory;

public class RemoteAddressesAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public RemoteAddressesAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "remoteAddresses");
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/connector/remote-addresses.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("id");
        String address = req.getParameter("address");
        Directory directory = this.connectorConfManager.getDirectory(id);
        if (directory != null) {
            if (req.getParameter("remove") != null) {
                this.connectorConfManager.removeRemoteAddress(directory.getId(), address);
            } else {
                this.connectorConfManager.addRemoteAddress(directory.getId(), address);
            }
            resp.sendRedirect("remote-addresses?id=" + id);
        } else {
            resp.sendError(404);
        }
    }
}

