/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.azure.AzureDirectory;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;

public class ConfigureAvatarsAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public ConfigureAvatarsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.showPage(req, resp);
    }

    private void showPage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null || !dir.getKind().equals("AZURE_AD")) {
            resp.sendError(404);
            return;
        }
        AzureDirectory azureDir = (AzureDirectory)dir;
        model.put("platformSupportsAvatars", this.hostApp.supportsAvatars(this.applicationProperties));
        model.put("currentConnector", azureDir);
        model.put("isAvatarFetchActive", azureDir.isAvatarFetchActive());
        model.put("avatarFetchFrequency", azureDir.getAvatarFetchFrequency());
        model.put("avatarLastFetchDate", azureDir.getAvatarLastFetchDate());
        model.put("topMenu", "connectors");
        model.put("menuItem", "configure-avatars");
        model.put("connectorType", this.connectorConfManager.getConnectorTypes().get(dir.getKind()));
        com.atlassian.crowd.embedded.api.Directory cwd = new CrowdDirectoryFinder(this.hostApp).findDirectory(id);
        model.put("crowdDirectory", cwd);
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/connector/configure-avatars.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String id = req.getParameter("id");
        Directory directory = this.connectorConfManager.getDirectory(id);
        boolean avatarFetchEnabled = req.getParameter("chk-avatar-fetch-enabled") != null;
        int syncFrequency = -1;
        if (req.getParameter("txt-sync-frequency") != null) {
            try {
                syncFrequency = Integer.parseInt(req.getParameter("txt-sync-frequency"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (directory == null) {
            resp.sendError(404);
            return;
        }
        if (syncFrequency != -1) {
            ((AzureDirectory)directory).setAvatarFetchFrequency(syncFrequency);
        }
        ((AzureDirectory)directory).setAvatarFetchActive(avatarFetchEnabled);
        this.connectorConfManager.saveOrEdit(directory);
        this.showPage(req, resp);
    }
}

