/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.utils.ContextAware;
import org.kantega.atlaskerb.utils.IOUtils;

public class HttpUrlUtils {
    public static boolean applicationUsesHttps(ApplicationProperties appProps) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> new URI(appProps.getBaseUrl(UrlMode.ABSOLUTE))).mapTry((CheckedFunction1 & Serializable)uri -> uri.getScheme().equalsIgnoreCase("https")).getOrElse((Object)false);
    }

    public static String getTargetLinkUrl(String urlString, String baseUrl) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> urlString).mapTry(URI::new).filterTry(uri -> uri.isAbsolute() ? HttpUrlUtils.validateAbsoluteUri(uri, baseUrl) : HttpUrlUtils.validateRelativeUri(uri)).map(URI::toString).getOrNull();
    }

    private static boolean validateAbsoluteUri(URI uri, String baseUrl) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> uri).mapTry(URI::toURL).filterTry(url -> Array.of((Object[])new String[]{"http", "https"}).contains((Object)url.getProtocol())).mapTry(URL::toString).filterTry(urlString -> StringUtils.startsWith((CharSequence)urlString, (CharSequence)baseUrl)).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"javascript:")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"<script")).mapTry((CheckedFunction1 & Serializable)urlString -> true).getOrElse((Object)false);
    }

    private static boolean validateRelativeUri(URI uri) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> uri).mapTry(URI::toString).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"://")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"javascript:")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, (CharSequence)"<script")).mapTry((CheckedFunction1 & Serializable)urlString -> true).getOrElse((Object)false);
    }

    public static boolean validateURI(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            return scheme != null && (scheme.equals("https") || scheme.equals("http"));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValidURI(String maybeUri) throws URISyntaxException, NullPointerException {
        URI uri = new URI(maybeUri);
        String scheme = uri.getScheme();
        return scheme != null && (scheme.equals("https") || scheme.equals("http"));
    }

    public static Try<URI> tryNormalizeURI(String taintedURI) {
        return Try.of((CheckedFunction0 & Serializable)() -> taintedURI).mapTry((CheckedFunction1 & Serializable)uri -> uri.replaceAll("\\s+", "")).mapTry(URI::new).mapTry(URI::normalize);
    }

    public static String stripPrefixFromUri(String uriPath, String maybePrefix) {
        String prefix = (String)Option.of((Object)maybePrefix).getOrElse((Object)"");
        return (String)Try.of((CheckedFunction0 & Serializable)() -> uriPath).mapTry((CheckedFunction1 & Serializable)uri -> uri.startsWith(prefix) ? uri.replaceFirst(prefix, "") : uri).flatMapTry(HttpUrlUtils::tryNormalizeURI).mapTry(URI::getPath).getOrElse((Object)uriPath);
    }

    public static String addPrefixIfNotInPath(String uriPath, String prefix) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> uriPath).map(HttpUrlUtils::sanitizeUrlForTrailingSlashes).mapTry((CheckedFunction1 & Serializable)uri -> uri.startsWith(prefix) ? uri : prefix + uri).flatMapTry(HttpUrlUtils::tryNormalizeURI).mapTry(URI::getPath).getOrElse((Object)uriPath);
    }

    public static String extractAuthority(String url) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> new URI(url)).map(URI::getAuthority).getOrElse((Object)"");
    }

    public static boolean isRemoteIpValveConfigured() {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().contains("RemoteIpValve")) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystemAdmin(UserManager userManager, HttpServletRequest request) {
        UserKey remoteUser = userManager.getRemoteUserKey(request);
        return remoteUser != null && userManager.isSystemAdmin(remoteUser);
    }

    public static String getInternalPath(String uri, String contextPath) {
        if (uri == null || contextPath == null) {
            return "";
        }
        return uri.substring(contextPath.length());
    }

    public static String stripQueryStringFromInternalPath(String internalPath) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> internalPath).mapTry((CheckedFunction1 & Serializable)uri -> uri.split("\\?")[0]).getOrElse((Object)internalPath);
    }

    public static String stripQueryStringFromUri(HttpServletRequest request) {
        return (String)Try.of(() -> ((HttpServletRequest)request).getRequestURI()).mapTry((CheckedFunction1 & Serializable)uri -> uri.split("\\?")[0]).getOrElse((Object)request.getRequestURI());
    }

    public static String getInternalPath(HttpServletRequest req) {
        if (req == null) {
            return "";
        }
        return HttpUrlUtils.getInternalPath(req.getRequestURI(), req.getContextPath());
    }

    public static String contextAwarePath(HttpServletRequest req, String path) {
        return ContextAware.of(req).path(path);
    }

    private static boolean isAuthHeaderValueBasic(String authzHeaderValue) {
        return StringUtils.startsWithIgnoreCase((CharSequence)authzHeaderValue, (CharSequence)"Basic");
    }

    public static boolean requestHasBasicAuthHeader(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (!HttpUrlUtils.isAuthHeaderValueBasic(header)) continue;
            return true;
        }
        return false;
    }

    public static String getBasicAuthHeader(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (!HttpUrlUtils.isAuthHeaderValueBasic(header)) continue;
            return header;
        }
        return null;
    }

    public static Option<Tuple2<String, String>> credentialsWithBasicAuthentication(HttpServletRequest req) {
        Enumeration headers = req.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String basic = (String)headers.nextElement();
            if (!headers.hasMoreElements() || !HttpUrlUtils.isAuthHeaderValueBasic(basic)) continue;
            String basicBase64Encoded = basic + " " + (String)headers.nextElement();
            return HttpUrlUtils.getCredentialsFromBasicAuthHeader(basicBase64Encoded);
        }
        return Option.none();
    }

    public static Option<Tuple2<String, String>> credentialsWithBasicAuthSingleHeader(HttpServletRequest request) {
        return Option.of((Object)request).map(req -> req.getHeader("Authorization")).flatMap(HttpUrlUtils::getCredentialsFromBasicAuthHeader);
    }

    public static Option<String> extractUsernameFromBasicAuthHeader(HttpServletRequest request) {
        return Option.of((Object)request).map(req -> req.getHeader("Authorization")).flatMap(HttpUrlUtils::getCredentialsFromBasicAuthHeader).map(Tuple2::_1);
    }

    public static Option<String> extractApiTokenFromBasicAuthHeader(HttpServletRequest request) {
        return HttpUrlUtils.credentialsWithBasicAuthSingleHeader(request).map(Tuple2::_2);
    }

    public static Option<Tuple2<String, String>> getCredentialsFromBasicAuthHeader(String authHeader) {
        return Option.of((Object)authHeader).filter(HttpUrlUtils::isAuthHeaderValueBasic).map(basicAuthHeader -> StringUtils.substringAfter((String)basicAuthHeader, (String)" ")).map(basicAuthBody -> Base64.decodeBase64((byte[])basicAuthBody.getBytes(StandardCharsets.UTF_8))).map(bytes -> StringUtils.toEncodedString((byte[])bytes, (Charset)StandardCharsets.UTF_8)).filter(credentials -> credentials.contains(":")).map(credentials -> Tuple.of((Object)StringUtils.substringBefore((String)credentials, (String)":"), (Object)StringUtils.substringAfter((String)credentials, (String)":"))).map(tuple -> tuple.map(String::trim, String::trim)).filter(tuple -> StringUtils.isNotBlank((CharSequence)((CharSequence)tuple._1())));
    }

    public static Option<String> getUsernameFromBasicAuthHeader(HttpServletRequest request) {
        return Option.of((Object)request).map(req -> req.getHeader("Authorization")).flatMap(HttpUrlUtils::getCredentialsFromBasicAuthHeader).map(Tuple2::_1);
    }

    public static Option<String> getUsernameFromBasicAuthHeader(String authHeader) {
        return HttpUrlUtils.getCredentialsFromBasicAuthHeader(authHeader).map(Tuple2::_1);
    }

    public static String sanitizeUrlForTrailingSlashes(String url) {
        return (String)Option.of((Object)url).toTry().mapTry((CheckedFunction1 & Serializable)u -> u.endsWith("/") ? u.substring(0, u.length() - 1) : u).getOrElse((Object)url);
    }

    public static boolean isValidAndNonEmptyUri(String maybeValidUri) {
        return (Boolean)Option.of((Object)maybeValidUri).filter(StringUtils::isNotBlank).filter(StringUtils::isNotEmpty).map(HttpUrlUtils::validateURI).getOrElse((Object)false);
    }

    public static String transformToAbsoluteUrl(String url, ApplicationProperties applicationProperties) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            try {
                return UriBuilder.fromUri((String)applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).path(url).build(new Object[0]).toURL().toString();
            }
            catch (MalformedURLException ee) {
                return null;
            }
        }
        return url;
    }

    public static InputStream urlToInputStream(String url) {
        return (InputStream)Try.of((CheckedFunction0 & Serializable)() -> url).mapTry(URL::new).mapTry(URL::openStream).orElse(Try.of(IOUtils::getEmptyInputStream)).getOrElse((Object)IOUtils.getEmptyInputStream());
    }

    public static String urlEncode(String value) throws UnsupportedEncodingException {
        return value == null ? "" : URLEncoder.encode(value, StandardCharsets.UTF_8.name());
    }

    public static String urlDecode(String value) throws UnsupportedEncodingException {
        return value == null ? "" : URLDecoder.decode(value, StandardCharsets.UTF_8.name());
    }

    public static Try<String> tryUrlEncode(String value) {
        return Try.of((CheckedFunction0 & Serializable)() -> HttpUrlUtils.urlEncode(value));
    }

    public static String getLastParameter(String parameterName, HttpServletRequest req) {
        String value = null;
        String[] pValues = req.getParameterValues(parameterName);
        if (pValues.length > 0) {
            value = pValues[pValues.length - 1];
        }
        return value;
    }

    public static void buildQueryString(StringBuffer queryString, String parameterName, HttpServletRequest req) {
        String value = HttpUrlUtils.getLastParameter(parameterName, req);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            queryString.append(queryString.length() == 0 ? "?" : "&");
            queryString.append(parameterName + "=" + value);
        }
    }

    public static boolean querystringHas(String queryStringPart, HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), (CharSequence)queryStringPart);
    }

    public static String getRequestBaseUrl(HttpServletRequest req) {
        String uriWithoutContextPath = req.getRequestURI().replaceFirst(req.getContextPath(), "");
        return StringUtils.replace((String)req.getRequestURL().toString(), (String)uriWithoutContextPath, (String)"");
    }

    public static void sendSaveSuccess(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().print("<html>Settings was saved</html>");
    }

    public static void sendSaveError(HttpServletResponse response, Exception e) throws IOException {
        response.setStatus(500);
        response.getWriter().print(String.format("<html>Settings was not saved. Error was:<br> %s</html>", e));
    }

    public static String getRemoteIpXForwardedFor(HttpServletRequest req) {
        String forwardedFor = req.getHeader("[IP::client_addr]");
        if (forwardedFor != null) {
            return forwardedFor;
        }
        forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            return forwardedFor;
        }
        return req.getRemoteAddr();
    }

    public static HttpServletRequest removeAuthHeader(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){
            private Set<String> headerNameSet;

            public Enumeration<String> getHeaderNames() {
                if (this.headerNameSet == null) {
                    this.headerNameSet = new HashSet<String>();
                    Enumeration wrappedHeaderNames = super.getHeaderNames();
                    while (wrappedHeaderNames.hasMoreElements()) {
                        String headerName = (String)wrappedHeaderNames.nextElement();
                        if ("Authorization".equalsIgnoreCase(headerName)) continue;
                        this.headerNameSet.add(headerName);
                    }
                }
                return Collections.enumeration(this.headerNameSet);
            }

            public Enumeration<String> getHeaders(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return Collections.emptyEnumeration();
                }
                return super.getHeaders(name);
            }

            public String getHeader(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return null;
                }
                return super.getHeader(name);
            }
        };
    }
}

