/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpsConfigServlet
extends RequireAdminServlet {
    private final TemplateRenderer templateRenderer;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private static final Logger log = LoggerFactory.getLogger(IdpsConfigServlet.class);

    @Inject
    public IdpsConfigServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
    }

    private Collection<JSONObject> convertToSafeDrafts(Collection<JSONObject> drafts) {
        return io.vavr.collection.List.ofAll(drafts).filter(draft -> !draft.isEmpty()).map(draft -> draft.optJSONObject("commonWizardState")).filter(commonWizardState -> !commonWizardState.isEmpty()).map(commonWizardState -> {
            String name = commonWizardState.optString("display_name", "Unnamed draft");
            name = StringUtils.isBlank((CharSequence)name) ? "Unnamed draft" : name;
            String timestamp = commonWizardState.optString("timestamp", "");
            String formattedTimestamp = (String)DateTimeUtil.getDateTimeString(timestamp).getOrElse((Object)timestamp);
            String id = commonWizardState.optString("idp_id", "");
            JSONObject draft = new JSONObject();
            draft.put("name", (Object)name);
            draft.put("timestamp", (Object)formattedTimestamp);
            draft.put("id", (Object)id);
            return draft;
        }).filter(safeDraft -> !safeDraft.getString("id").isEmpty()).asJava();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        this.idpConfManager.readState();
        Map<String, Object> model = this.newModel(req);
        model.put("menuItem", "providerList");
        model.put("topMenu", "SAML");
        model.put("providerKinds", IdpConfiguration.Kind.values());
        model.put("providers", this.idpConfManager.getSortedIdentityProviders());
        model.put("drafts", this.convertToSafeDrafts(this.idpConfManager.getDrafts()));
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("idpConfManager", this.idpConfManager);
        model.put("dateUtils", new DateUtils());
        model.put("dateTool", new DateTool());
        model.put("samlUtils", new SamlUtils(this.idpConfManager, req));
        model.put("useIdpPriority", this.idpConfManager.isUseIdpPriority());
        model.put("isUseIcon", this.idpConfManager.isUseIcon());
        model.put("baseBackupUrl", req.getContextPath() + "/download/resources/" + this.kerbConfManager.getLicenseManager().getPluginKey() + "/images/svg/");
        model.put("baseIconUrl", req.getContextPath() + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart() + "/providers/");
        model.put("countEnabledProviders", this.idpConfManager.getIdentityProviders().stream().filter(IdpConfiguration::isEnabled).count());
        model.put("isRequireLogin", this.kerbConfManager.isRequireLogin());
        if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
            model.put("license", this.kerbConfManager.getLicenseManager().getLicense().get());
        }
        List<IdpConfiguration.RedirectPolicy> exclusiveRedirectPolicies = Arrays.asList(IdpConfiguration.RedirectPolicy.HARD, IdpConfiguration.RedirectPolicy.ALL);
        Collection idpConfigurations = this.idpConfManager.getIdentityProviders().stream().filter(IdpConfiguration::isEnabled).collect(Collectors.toList());
        List exclusiveConfigurations = idpConfigurations.stream().filter(config -> exclusiveRedirectPolicies.contains((Object)config.getRedirectProperties().getRedirectPolicy())).collect(Collectors.toList());
        List activeNonExclusiveConfigurations = idpConfigurations.stream().filter(config -> {
            if (config.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.NONE) {
                return false;
            }
            return !exclusiveConfigurations.contains(config);
        }).collect(Collectors.toList());
        if (exclusiveConfigurations.size() > 0) {
            model.put("exclusiveConfigurations", exclusiveConfigurations);
            if (exclusiveConfigurations.size() > 1) {
                model.put("warningMultipleExclusiveConfigurations", true);
            }
            if (activeNonExclusiveConfigurations.size() > 0) {
                model.put("warningUnusedActiveConfigurations", true);
                model.put("activeNonExclusiveConfigurations", activeNonExclusiveConfigurations);
            }
        }
        model.put("countInstantRedirect", idpConfigurations.stream().filter(idp -> idp.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.HARD).count());
        model.put("countAutomaticRedirect", idpConfigurations.stream().filter(idp -> idp.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.ALL).count());
        model.put("infoAutomaticRedirects", this.idpConfManager.getIdentityProviders().stream().anyMatch(idp -> idp.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.ALL || idp.getRedirectProperties().getRedirectPolicy() == IdpConfiguration.RedirectPolicy.HARD));
        model.put("directoryById", this.directoryById(this.userLookupService.getActiveUserDirectories()));
        this.templateRenderer.render("templates/idps-main.vm", model, (Writer)resp.getWriter());
    }

    private Map<Long, Directory> directoryById(List<Directory> activeUserDirectories) {
        HashMap<Long, Directory> directories = new HashMap<Long, Directory>();
        for (Directory directory : activeUserDirectories) {
            directories.put(directory.getId(), directory);
        }
        return directories;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String useIdpPriority;
        String increasePriority;
        String decreasePriority;
        String toggleEnabled;
        String removeDraft;
        String removeIdp = req.getParameter("removeIdp");
        if (removeIdp != null) {
            this.idpConfManager.removeIdentityProvider(removeIdp);
            this.idpConfManager.validateAndUpdateIdpPriorities();
            try {
                this.idpConfManager.removeDraft(removeIdp);
            }
            catch (Throwable e) {
                return;
            }
        }
        if ((removeDraft = req.getParameter("removeDraft")) != null) {
            this.idpConfManager.removeDraft(removeDraft);
        }
        if ((toggleEnabled = req.getParameter("toggle-enabled-idp")) != null) {
            IdpConfiguration existing = this.idpConfManager.getIdentityProviderById(toggleEnabled);
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(existing);
            builder.setEnabled(!existing.isEnabled());
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        if ((decreasePriority = req.getParameter("decrease-priority")) != null) {
            this.changeIdpPriority(decreasePriority, false);
        }
        if ((increasePriority = req.getParameter("increase-priority")) != null) {
            this.changeIdpPriority(increasePriority, true);
        }
        if ((useIdpPriority = req.getParameter("use-idp-priority")) != null) {
            this.idpConfManager.setUseIdpPriority("true".equals(useIdpPriority));
        }
        if (this.idpConfManager.getIdentityProviders().isEmpty() && this.idpConfManager.getDrafts().isEmpty()) {
            resp.sendRedirect("dashboard");
        } else {
            resp.sendRedirect("providers");
        }
    }

    private void changeIdpPriority(String identityProviderId, boolean increasePriority) {
        IdpConfiguration selectedIdpConfiguration = this.idpConfManager.getIdentityProviderById(identityProviderId);
        if (selectedIdpConfiguration == null) {
            log.debug("changeIdpPriority: selectedIdpConfiguration is null.");
        } else {
            int currentPriority = selectedIdpConfiguration.getIdpPriority();
            int targetPriority = increasePriority ? currentPriority - 1 : currentPriority + 1;
            for (IdpConfiguration idpConfiguration : this.idpConfManager.getIdentityProviders()) {
                if (idpConfiguration == null) {
                    log.debug("changeIdpPriority: A idpConfiguration found while iterating is null.");
                    continue;
                }
                if (idpConfiguration.getIdpPriority() != targetPriority) continue;
                IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(idpConfiguration);
                builder.setIdpPriority(currentPriority);
                this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
                IdpConfigurationBuilder<?, ?> selectedIdpBuilder = IdpConfigurationBuilder.ofGeneric(selectedIdpConfiguration);
                selectedIdpBuilder.setIdpPriority(targetPriority);
                this.idpConfManager.updateIdpConfiguration((IdpConfiguration)selectedIdpBuilder.build());
            }
        }
        this.idpConfManager.validateAndUpdateIdpPriorities();
    }

    public static class SamlUtils {
        private final IdpConfManager idpConfManager;
        private final HttpServletRequest req;

        public SamlUtils(IdpConfManager idpConfManager, HttpServletRequest req) {
            this.idpConfManager = idpConfManager;
            this.req = req;
        }

        public String getLoginUrl(SamlIdpConfiguration configuration) {
            return this.idpConfManager.getServiceProviderLoginUrl(this.req, configuration.getId());
        }

        public String getTestUrl(SamlIdpConfiguration configuration) {
            return this.idpConfManager.getServiceProviderTestUrl(this.req, configuration.getId());
        }

        public String knownDomainList(Set<String> domains) {
            if (domains != null) {
                StringBuilder sb = new StringBuilder();
                Iterator<String> iterator = domains.iterator();
                while (iterator.hasNext()) {
                    String domain = iterator.next();
                    sb.append("@").append(domain);
                    if (!iterator.hasNext()) continue;
                    sb.append(" or ");
                }
                return sb.toString();
            }
            return "";
        }
    }

    public static class DateUtils {
        public long daysUntil(Date date) {
            long diff = date.getTime() - System.currentTimeMillis();
            return diff / 86400000L;
        }
    }
}

