/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LastUserAgentsCache {
    private static final String CACHE_KEY = "kssoLogLastUserAgentsCache";
    private final Cache<String, Boolean> userAgentCache;
    private final int MAX_ENTRIES = 100;

    @Inject
    public LastUserAgentsCache(@ComponentImport CacheManager cacheManager) {
        this.userAgentCache = cacheManager.getCache(CACHE_KEY, null, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaCopy().expireAfterWrite(30L, TimeUnit.DAYS).maxEntries(100).build());
    }

    public void clear() {
        this.userAgentCache.removeAll();
    }

    public void put(String userAgent) {
        if (StringUtils.isBlank((CharSequence)userAgent) || this.userAgentCache.containsKey((Object)userAgent)) {
            return;
        }
        this.userAgentCache.put((Object)userAgent, (Object)true);
    }

    public Collection<String> getValues() {
        return this.userAgentCache.getKeys();
    }

    public List<String> lastUserAgents() {
        return this.getValues().stream().limit(100L).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }
}

