/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.Tuple;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.RequireLoggedInUserServlet;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.apitokens.ApiTokenV570;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.UserManagerUtils;

public class ApiTokenUserServlet
extends RequireLoggedInUserServlet {
    private final ApiTokenService apiTokenService;
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final KerbConfManager kerbConfManager;
    private final UserLookupService userLookupService;

    @Inject
    public ApiTokenUserServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket.getUserManager(), bucket.getLoginUriProvider());
        this.apiTokenService = apiTokenService;
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.userLookupService = bucket.getUserLookupService();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (HttpUrlUtils.isSystemAdmin(this.userManager, req)) {
            resp.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart() + "/api-tokens");
            return;
        }
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-user.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, Object> protoModel = new HashMap<String, Object>();
        if ("delete".equals(req.getParameter("operation"))) {
            Option.of((Object)Tuple.of((Object)Option.of((Object)req.getParameter("tokenId")).getOrElse((Object)""), (Object)UserManagerUtils.extractUsername(this.userManager.getRemoteUser(req)).getOrElse((Object)"")).apply(this.apiTokenService::findTokenByIdAndUsername)).forEach(this.apiTokenService::delete);
            this.buildModelAndRenderTemplate(req, resp, protoModel);
        } else {
            Option<String> maybeToken = this.apiTokenService.createAndPersistToken(req);
            if (maybeToken.isDefined()) {
                protoModel.put("newApiToken", maybeToken.get());
            }
            this.buildModelAndRenderTemplate(req, resp, protoModel);
        }
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> protoModel) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-user.vm", model, (Writer)resp.getWriter());
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> buildModel(HttpServletRequest req) {
        block2: {
            model = this.newModel(req);
            model.put("displayName", this.applicationProperties.getDisplayName());
            model.put("durationOptions", ApiTokenUtil.DatePair.getDurationOptionsRestricted(this.kerbConfManager.getApiTokensUserMaxTimeRestriction()));
            model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
            maybeUsername = UserManagerUtils.extractUsername(this.userManager.getRemoteUser(req));
            if (this.kerbConfManager.getApiTokenUserPermission() != ApiTokenUtil.TokenUserPermission.USER_GROUPS) break block2;
            if (((Boolean)maybeUsername.map((Function<String, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, isApiTokenUserInAllowedGroups(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)((ApiTokenService)this.apiTokenService)).getOrElse((Object)false)).booleanValue()) ** GOTO lbl-1000
        }
        if (this.kerbConfManager.getApiTokenUserPermission() == ApiTokenUtil.TokenUserPermission.ALL_USERS) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        userApiTokenEnabled = v0;
        model.put("isUserApiTokenEnabled", userApiTokenEnabled);
        model.put("username", maybeUsername.getOrNull());
        model.put("tokens", this.getTokensRepresentation(req));
        return model;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation(HttpServletRequest req) {
        return ((io.vavr.collection.List)UserManagerUtils.extractUsername(this.userManager.getRemoteUser(req)).map(this.apiTokenService::findTokensByUsername).map(io.vavr.collection.List::ofAll).getOrElse((Object)io.vavr.collection.List.empty())).map(apiToken -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenV570)apiToken, this.userManager, this.apiTokenService)).asJava();
    }
}

