/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.cache.LastUserAgentsCache;
import org.kantega.atlaskerb.jaas.JaasConfig;
import org.kantega.atlaskerb.kerberos.Stats;
import org.kantega.atlaskerb.rest.resource.api.usercleanup.utils.CleanupMode;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.simplericity.serberuhs.SpNego;
import org.simplericity.serberuhs.keytab.KeytabInfo;
import org.simplericity.serberuhs.keytab.KeytabParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KerbConfManager
implements DebugInfo {
    private static final String KEYTAB_INFO_KEY = "keytabInfo";
    private static final String key = "atlaskerb";
    private static final String oldDisableLoginFileName = "disable_username_password_login.txt";
    private static final String disableTraditionalLoginFileName = "prevent_username_password_login.txt";
    private static final String disableJsmLoginFileName = "prevent_jsm_username_password_login.txt";
    private static final String disableBasicAuthFileName = "disable_basic_auth_rest.txt";
    private static final String enableCsrfOriginCheckFileName = "enable_csrf_origin_check.txt";
    public static final String[] defaultDisabledUserAgents = Arrays.asList("HttpClient", "Java/", "JIRA-", "JIRA/", "Bitbucket-", "Confluence-", "Confluence/", "FishEye-", "Bamboo-", "Axis/", "Monitoring Agent", "BB10", "BlackBerry", "AtlassianMobileApp", "AtlassianCompanion", "GoEdit").toArray(new String[0]);
    public final String restApiRestrictedFilename = "restrict_rest_api_to_api_tokens.txt";
    final String oldTraditionalLoginEnabledJsdContent = "isTraditionalLoginEnabledJSD=true";
    final String traditionalLoginDisabledJsmContent = "The existence of this file disables traditional username / password login for the Jira Service Management portal. If you need to enable traditional login for JSM, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String oldBasicAuthDisabledContent = "isBasicAuthDisabled=true";
    final String basicAuthDisabledContent = "The existence of this file disables Basic Auth with username and password on the REST interface. Now only Kerberos, OAuth, Personal access tokens or Kantega SSO API tokens are valid options for authenticating with the REST API.If you need to enable basic auth, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String completeLockdownContent = "completeLockdown=true";
    final String traditionalLoginDisabledFileContent = "The existence of this file disables traditional username / password login. If you need to enable traditional login, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String csrfOriginCheckFileContent = "The existence of this file enables CSRF origin checks and it is recommended to keep it due to security concerns. If you need to disable CSRF origin checks, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String restApiRestrictedToApiTokenFileContent = "The existence of this file disables certain REST endpoints to only work with API token authentication. This may affect login mechanisms or other Atlassian functionality if not configured carefully. If you need to restore the original functionality, delete this file. No server restart is required. It may take up to one minute for the change to take effect.";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;
    private final PluginLicenseManager licenseManager;
    private final Stats stats;
    private final Cache<String, Object> oneMinuteCache;
    private final Cache<String, Subject> subjectCache;
    private final LastUserAgentsCache lastUserAgentsCache;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HomeDirectoryResolver homeDirectoryResolver;

    @Inject
    public KerbConfManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginMetadataManager pluginMetadataManager, LastUserAgentsCache lastUserAgentsCache) {
        this.applicationProperties = applicationProperties;
        this.licenseManager = licenseManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.stats = new Stats();
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
        this.oneMinuteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.subjectCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.lastUserAgentsCache = lastUserAgentsCache;
    }

    public static DecodedKerberosToken decodeKerberosToken(String tokenString) throws Exception {
        if (tokenString == null || !tokenString.startsWith("Negotiate ") || tokenString.length() < 11) {
            return null;
        }
        byte[] token = Base64.decodeBase64((byte[])StandardCharsets.UTF_8.encode(tokenString.substring("Negotiate ".length())).array());
        byte[] kerberosToken = new SpNego().getKerberosToken(token);
        return DecodedKerberosToken.fromToken((byte[])kerberosToken);
    }

    private static String nullsafe(Object param) {
        return param == null ? null : param.toString();
    }

    public String getPluginRootAbsoluteUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/" + PluginKey.getPluginKeyBasepart();
    }

    public String getPluginRootUri() {
        return "/plugins/servlet/" + PluginKey.getPluginKeyBasepart();
    }

    public static Properties getBuildInfo() {
        Properties buildInfo = new Properties();
        try (InputStream is = KerbConfManager.class.getResourceAsStream("/build-info.properties");){
            buildInfo.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buildInfo;
    }

    public boolean isLicenseDefined() {
        return this.licenseManager.getLicense().isDefined();
    }

    public Stats getStats() {
        return this.stats;
    }

    public Subject getSubject(DecodedKerberosToken decodedKerberosToken) {
        if (decodedKerberosToken == null) {
            return null;
        }
        Keytab keytab = new Keytab(this.getKeytabInfos());
        String tokenPrincipal = this.getPrincipalForSubject(decodedKerberosToken, keytab);
        try {
            return (Subject)this.subjectCache.get((Object)tokenPrincipal, () -> (Subject)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)ComponentLocator.class.getClassLoader(), () -> {
                JaasConfig config = new JaasConfig(this.getKeytabFile(), tokenPrincipal);
                CallbackHandler cbh = callbacks -> this.log.info("{} callbacks: {}", (Object)callbacks.length, (Object)callbacks);
                LoginContext ctx = new LoginContext(key, null, cbh, config);
                ctx.login();
                return ctx.getSubject();
            }));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to obtain Subject", e);
        }
    }

    public DecodedKerberosToken decodeKerberosToken(HttpServletRequest request) throws Exception {
        String atz = request.getHeader("Authorization");
        if (atz == null) {
            return null;
        }
        if (!atz.startsWith("Negotiate")) {
            return null;
        }
        return KerbConfManager.decodeKerberosToken(atz);
    }

    private String getPrincipalForSubject(DecodedKerberosToken decodedKerberosToken, Keytab keytab) {
        String tokenPrincipal = decodedKerberosToken.getService() + "/" + decodedKerberosToken.getHost() + "@" + decodedKerberosToken.getRealm();
        String oldConfiguredPrincipal = (String)this.settings().get(KEYS.PRINCIPAL.key);
        if (oldConfiguredPrincipal != null && keytab.getEntries().size() == 1 && !oldConfiguredPrincipal.equals(tokenPrincipal)) {
            return oldConfiguredPrincipal;
        }
        return tokenPrincipal;
    }

    public synchronized void flushKeytabCaches() {
        this.oneMinuteCache.invalidate((Object)KEYTAB_INFO_KEY);
        this.subjectCache.invalidateAll();
    }

    public boolean isUserNameAttributeLookupEnabled() {
        Object userNameAttributeLookupEnabled = this.settings().get(KEYS.USERNAME_ATTR_LOOKUP_ENABLED.key);
        return "true".equals(userNameAttributeLookupEnabled) || "true".equals(this.settings().get(KEYS.USER_PRINCIPAL_ATTR_LOOKUP_ENABLED.key));
    }

    public void setUserNameAttributeLookupEnabled(boolean userNameAttributeLookupEnabled) {
        this.settings().put(KEYS.USERNAME_ATTR_LOOKUP_ENABLED.key, (Object)Boolean.toString(userNameAttributeLookupEnabled));
        this.settings().remove(KEYS.USER_PRINCIPAL_ATTR_LOOKUP_ENABLED.key);
    }

    public boolean isKerberosEnabled() {
        return !"false".equals(this.settings().get(KEYS.KERBEROS_ENABLED.key));
    }

    public void setKerberosEnabled(boolean manualLoginLogEnabled) {
        this.settings().put(KEYS.KERBEROS_ENABLED.key, (Object)Boolean.toString(manualLoginLogEnabled));
    }

    public boolean showWelcomeMessage() {
        return !"false".equals(this.settings().get(KEYS.SHOW_WELCOME_MESSAGE.key));
    }

    public void setShowWelcomeMessage(boolean showWelcomeMessage) {
        this.settings().put(KEYS.SHOW_WELCOME_MESSAGE.key, (Object)Boolean.toString(showWelcomeMessage));
    }

    public boolean isManualLoginLogEnabled() {
        return "true".equals(this.settings().get(KEYS.MANUAL_LOGIN_LOG_ENABLED.key));
    }

    public void setManualLoginLogEnabled(boolean manualLoginLogEnabled) {
        this.settings().put(KEYS.MANUAL_LOGIN_LOG_ENABLED.key, (Object)Boolean.toString(manualLoginLogEnabled));
    }

    public boolean isCollectUserAgentsEnabled() {
        return "true".equals(this.settings().get(KEYS.COLLECT_LAST_USER_AGENTS_LIST_ENABLED.key));
    }

    public void setCollectUserAgentsEnabled(boolean collectUserAgentsEnabled) {
        this.settings().put(KEYS.COLLECT_LAST_USER_AGENTS_LIST_ENABLED.key, (Object)Boolean.toString(collectUserAgentsEnabled));
    }

    public boolean isRequireLogin() {
        return "true".equals(this.settings().get(KEYS.REQUIRE_LOGIN_ENABLED.key));
    }

    public void setRequireLogin(boolean requireLogin) {
        this.settings().put(KEYS.REQUIRE_LOGIN_ENABLED.key, (Object)Boolean.toString(requireLogin));
    }

    public boolean isForceLogin() {
        return "true".equals(this.settings().get(KEYS.SEND_TO_LOGIN_ENABLED.key));
    }

    public void setForceLogin(boolean sendToLoginEnabledConfigured) {
        this.settings().put(KEYS.SEND_TO_LOGIN_ENABLED.key, (Object)Boolean.toString(sendToLoginEnabledConfigured));
    }

    @Deprecated
    public boolean oldIsTraditionalLoginDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabled", () -> {
                File disableLoginFile = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                return disableLoginFile.exists() && disableLoginFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking username password disable status", e.getCause());
            return false;
        }
    }

    @Deprecated
    public boolean oldIsTraditionalLoginDisabledJSD() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabledJSD", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file);
                    return !fileContents.contains("isTraditionalLoginEnabledJSD=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isTraditionalLoginDisabled status", e.getCause());
            return true;
        }
    }

    @Deprecated
    public boolean oldIsBasicAuthDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isBasicAuthDisabled", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), oldDisableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    return fileContents.contains("isBasicAuthDisabled=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking old isBasicAuthDisabled status", e.getCause());
            return false;
        }
    }

    public boolean isTraditionalLoginPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableTraditionalLoginFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isTraditionalLoginDisabled status", e.getCause());
            return true;
        }
    }

    public boolean isTraditionalLoginJsmPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginJsmPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableJsmLoginFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking disable traditional login jsm status", e.getCause());
            return true;
        }
    }

    public boolean isBasicAuthPrevented() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isBasicAuthPrevented", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableBasicAuthFileName);
                return file.exists() && file.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isBasicAuthPrevented status", e.getCause());
            return false;
        }
    }

    public boolean setTraditionalLoginPrevented(boolean traditionalLoginPrevented) {
        return this.addOrDeleteFile(traditionalLoginPrevented, disableTraditionalLoginFileName, "The existence of this file disables traditional username / password login. If you need to enable traditional login, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.", "setTraditionalLoginPrevented");
    }

    public boolean setTraditionalLoginJsmPrevented(boolean traditionalLoginJsmPrevented) {
        return this.addOrDeleteFile(traditionalLoginJsmPrevented, disableJsmLoginFileName, "The existence of this file disables traditional username / password login for the Jira Service Management portal. If you need to enable traditional login for JSM, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.", "setTraditionalLoginJsmPrevented");
    }

    public boolean setBasicAuthPrevented(boolean basicAuthPrevented) {
        return this.addOrDeleteFile(basicAuthPrevented, disableBasicAuthFileName, "The existence of this file disables Basic Auth with username and password on the REST interface. Now only Kerberos, OAuth, Personal access tokens or Kantega SSO API tokens are valid options for authenticating with the REST API.If you need to enable basic auth, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.", "setBlockBasicAuth");
    }

    public boolean setBasicAuthEnabled(boolean basicAuthEnabled) {
        return this.addOrDeleteFile(!basicAuthEnabled, disableBasicAuthFileName, "The existence of this file disables Basic Auth with username and password on the REST interface. Now only Kerberos, OAuth, Personal access tokens or Kantega SSO API tokens are valid options for authenticating with the REST API.If you need to enable basic auth, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.", "setBlockBasicAuth");
    }

    private boolean addOrDeleteFile(boolean shouldFileExist, String fileName, String fileContent, String method) {
        String action;
        String string = action = !shouldFileExist ? "create" : "delete";
        if (StringUtils.isBlank((CharSequence)fileName)) {
            this.log.error("No file to write to. Abort " + action + " file for " + method);
        }
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), fileName);
            if (shouldFileExist) {
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])((String)Option.of((Object)fileContent).getOrElse((Object)"")).getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
            return true;
        }
        catch (IOException e) {
            this.log.error("Unable to " + action + " file: " + fileName, (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Something failed when trying to" + action + " file: " + fileName, (Throwable)e);
        }
        return false;
    }

    public boolean isCsrfOriginCheckEnabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isCsrfOriginCheckDisabled", () -> {
                File enableCsrfOriginCheckFile = new File(this.homeDirectoryResolver.getHomeDirectory(), enableCsrfOriginCheckFileName);
                return enableCsrfOriginCheckFile.exists() && enableCsrfOriginCheckFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking CSRF origin check status", e.getCause());
            return false;
        }
    }

    public boolean setCsrfOriginCheckEnabled(boolean csrfOriginCheckEnabled) {
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), enableCsrfOriginCheckFileName);
            if (csrfOriginCheckEnabled) {
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])"The existence of this file enables CSRF origin checks and it is recommended to keep it due to security concerns. If you need to disable CSRF origin checks, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.".getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
            return true;
        }
        catch (IOException e) {
            String action = csrfOriginCheckEnabled ? "create" : "delete";
            this.log.error("Unable to " + action + " file: " + enableCsrfOriginCheckFileName, (Throwable)e);
        }
        catch (Exception e) {
            String action = csrfOriginCheckEnabled ? "create" : "delete";
            this.log.error("Something failed when trying to" + action + " file: " + enableCsrfOriginCheckFileName, (Throwable)e);
        }
        return false;
    }

    public void setRestApiRestrictedToApiTokens(boolean restApiRestricted, boolean completeLockdown) {
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), "restrict_rest_api_to_api_tokens.txt");
            if (restApiRestricted) {
                String content = "The existence of this file disables certain REST endpoints to only work with API token authentication. This may affect login mechanisms or other Atlassian functionality if not configured carefully. If you need to restore the original functionality, delete this file. No server restart is required. It may take up to one minute for the change to take effect.";
                if (completeLockdown) {
                    content = content + "\n\ncompleteLockdown=true";
                }
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])content.getBytes(StandardCharsets.UTF_8));
            } else {
                Files.deleteIfExists(Paths.get(file.getPath(), new String[0]));
            }
            this.oneMinuteCache.invalidateAll();
        }
        catch (IOException e) {
            String action = restApiRestricted ? "create" : "delete";
            this.log.error("Unable to " + action + " file: " + "restrict_rest_api_to_api_tokens.txt", (Throwable)e);
        }
        catch (Exception e) {
            String action = restApiRestricted ? "create" : "delete";
            this.log.error("Something failed when trying to" + action + " file: " + "restrict_rest_api_to_api_tokens.txt", (Throwable)e);
        }
    }

    public void flushOneMinuteCache() {
        this.oneMinuteCache.invalidateAll();
    }

    public boolean isRestApiRestrictedToApiTokens() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isRestApiRestrictedToApiTokens", () -> {
                File restApiRestrictedFile = new File(this.homeDirectoryResolver.getHomeDirectory(), "restrict_rest_api_to_api_tokens.txt");
                return restApiRestrictedFile.exists() && restApiRestrictedFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isRestApiRestrictedToTokens status", e.getCause());
            return false;
        }
    }

    public boolean isRestApiCompleteLockdown() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isRestApiCompleteLockdown", () -> {
                File restApiRestrictedFile = new File(this.homeDirectoryResolver.getHomeDirectory(), "restrict_rest_api_to_api_tokens.txt");
                if (restApiRestrictedFile.exists() && restApiRestrictedFile.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)restApiRestrictedFile, (Charset)StandardCharsets.UTF_8);
                    return fileContents.contains("completeLockdown=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isRestApiCompleteLockdown status", e.getCause());
            return false;
        }
    }

    @Nullable
    public String getLockedRestApiErrorPageMessage() {
        return (String)this.settings().get(KEYS.LOCKED_REST_API_ERROR_PAGE_MESSAGE.key);
    }

    public void setLockedRestApiErrorPageMessage(String message) {
        Option.of((Object)message).peek(msg -> this.settings().put(KEYS.LOCKED_REST_API_ERROR_PAGE_MESSAGE.key, msg));
    }

    public String getTemplateLockedRestApiErrorPageMessage() {
        return String.format("REST URL <requested REST URL> has been blocked for non-API token access by your Administrator in Kantega SSO. To open this endpoint, either do so under Rest API access in Kantega SSO, or remove the file %s on the server", "restrict_rest_api_to_api_tokens.txt");
    }

    public String getDefaultLockedRestApiErrorPageMessage(String maybeRequestUri) {
        String requestedUri = (String)Option.of((Object)maybeRequestUri).getOrElse((Object)"<REST API endpoint>");
        return String.format("The REST URL %s has been blocked for non-API token access by your Administrator in Kantega SSO. To open this endpoint, either do so under Rest API access in Kantega SSO, or remove the file '%s' on the server", requestedUri, "restrict_rest_api_to_api_tokens.txt");
    }

    public String getKerberosHomeDirectoryPath() {
        if (this.homeDirectoryResolver != null && this.homeDirectoryResolver.getHomeDirectory() != null) {
            return this.homeDirectoryResolver.getHomeDirectory().getPath();
        }
        return "";
    }

    public String getErrorPageMessage() {
        if (this.settings().get(KEYS.ERROR_PAGE_MESSAGE.key) != null) {
            return (String)this.settings().get(KEYS.ERROR_PAGE_MESSAGE.key);
        }
        return this.getDefaultErrorPageMessage();
    }

    public void setErrorPageMessage(String message) {
        this.settings().put(KEYS.ERROR_PAGE_MESSAGE.key, (Object)message);
    }

    public String getTraditionalLoginDisabledDefaultMessage() {
        return "<html><body><h2 style=\"padding-top:20px\">Username / password login is disabled by your administrator.</h2> \n\n<br><br>Return to the <a href=\"%s%s\">login page</a> and try again.</body></html>";
    }

    public String getTraditionalLoginDisabledMessage() {
        if (this.settings().get(KEYS.TRADITIONALLOGINDISABLEDMESSAGE.key) != null) {
            return (String)this.settings().get(KEYS.TRADITIONALLOGINDISABLEDMESSAGE.key);
        }
        return this.getTraditionalLoginDisabledDefaultMessage();
    }

    public void setTraditionalLoginDisabledMessage(String message) {
        this.settings().put(KEYS.TRADITIONALLOGINDISABLEDMESSAGE.key, (Object)message);
    }

    public String getAllTraditionalLoginDisabledDefaultMessage() {
        return "Username / password login is disabled by your administrator";
    }

    public String getAllTraditionalLoginDisabledMessage() {
        if (this.settings().get(KEYS.ALLTRADITIONALLOGINDISABLEDMESSAGE.key) != null) {
            return (String)this.settings().get(KEYS.ALLTRADITIONALLOGINDISABLEDMESSAGE.key);
        }
        return this.getAllTraditionalLoginDisabledDefaultMessage();
    }

    public void setAllTraditionalLoginDisabledMessage(String message) {
        this.settings().put(KEYS.ALLTRADITIONALLOGINDISABLEDMESSAGE.key, (Object)message);
    }

    public String getSamlLoginUsernamePlaceholder() {
        if (this.settings().get(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key) != null) {
            return (String)this.settings().get(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key);
        }
        return this.getDefaultSamlLoginUsernamePlaceholder();
    }

    public void setSamlLoginUsernamePlaceholder(String placeholder) {
        this.settings().put(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key, (Object)placeholder);
    }

    public String getUsernameFieldText() {
        if (this.settings().get(KEYS.USERNAME_FIELD_TEXT.key) != null) {
            return (String)this.settings().get(KEYS.USERNAME_FIELD_TEXT.key);
        }
        return this.getDefaultUsernameFieldText();
    }

    public void setUsernameFieldText(String usernameFieldText) {
        this.settings().put(KEYS.USERNAME_FIELD_TEXT.key, (Object)usernameFieldText);
    }

    public String getDefaultUsernameFieldText() {
        return "Username";
    }

    public String getNextButtonText() {
        if (this.settings().get(KEYS.NEXT_BUTTON_TEXT.key) != null) {
            return (String)this.settings().get(KEYS.NEXT_BUTTON_TEXT.key);
        }
        return this.getDefaultNextButtonText();
    }

    public void setNextButtonText(String nextButtonText) {
        this.settings().put(KEYS.NEXT_BUTTON_TEXT.key, (Object)nextButtonText);
    }

    public String getDefaultNextButtonText() {
        return "Next";
    }

    public String getIdpListTitleText() {
        if (this.settings().get(KEYS.IDP_LIST_TITLE_TEXT.key) != null) {
            return (String)this.settings().get(KEYS.IDP_LIST_TITLE_TEXT.key);
        }
        return this.getDefaultIdpListTitleText();
    }

    public void setIdpListTitleText(String idpListTitleText) {
        this.settings().put(KEYS.IDP_LIST_TITLE_TEXT.key, (Object)idpListTitleText);
    }

    public String getDefaultIdpListTitleText() {
        return "Log in with";
    }

    public String getDefaultSamlLoginUsernamePlaceholder() {
        return "user.name@example.com";
    }

    public String getDefaultErrorPageMessage() {
        return "This can occur for a variety of reasons, but most likely you just need to try logging in again. If this fails, please try closing your browser completely before trying again. If the issue persists, please contact your administrator.";
    }

    public String[] getHeaderUsernameIpUnblockedList() {
        return ListParseUtils.parseArrayFromNewlines((String)this.settings().get(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key));
    }

    public void setHeaderUsernameIpUnblockedList(String unblockedlist) {
        if (unblockedlist != null && unblockedlist.isEmpty()) {
            unblockedlist = null;
        }
        this.settings().put(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key, (Object)unblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public String getHeaderUsernameIpUnblockedListAsString() {
        return (String)this.settings().get(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key);
    }

    public String getHeaderUsernameAttribute() {
        return (String)this.settings().get(KEYS.HEADER_USERNAME_ATTRIBUTE.key);
    }

    public void setHeaderUsernameAttribute(String username) {
        if (username != null && username.isEmpty()) {
            username = null;
        }
        this.settings().put(KEYS.HEADER_USERNAME_ATTRIBUTE.key, (Object)username);
        this.oneMinuteCache.invalidateAll();
    }

    public String getHeaderEmailAttribute() {
        return (String)this.settings().get(KEYS.HEADER_EMAIL_ATTRIBUTE.key);
    }

    public void setHeaderEmailAttribute(String email) {
        if (email != null && email.isEmpty()) {
            email = null;
        }
        this.settings().put(KEYS.HEADER_EMAIL_ATTRIBUTE.key, (Object)email);
        this.oneMinuteCache.invalidateAll();
    }

    public String getJsmSignupEmailUnblockedList() {
        return (String)this.settings().get(KEYS.JSM_SIGNUP_EMAIL_UNBLOCKEDLIST.key);
    }

    public void setJsmSignupEmailUnblockedList(String unblockedList) {
        if (unblockedList != null && unblockedList.isEmpty()) {
            unblockedList = null;
        }
        this.settings().put(KEYS.JSM_SIGNUP_EMAIL_UNBLOCKEDLIST.key, (Object)unblockedList);
        this.oneMinuteCache.invalidateAll();
    }

    public String getJsmSignupFormUrlparts() {
        return (String)this.settings().get(KEYS.JSM_SIGNUP_FORM_URLPARTS.key);
    }

    public void setJsmSignupFormUrlparts(String urlPart) {
        if (urlPart != null && urlPart.isEmpty()) {
            urlPart = null;
        }
        this.settings().put(KEYS.JSM_SIGNUP_FORM_URLPARTS.key, (Object)urlPart);
        this.oneMinuteCache.invalidateAll();
    }

    public boolean isHeaderauthUseXForwardedFor() {
        Object isHeaderauthUseXForwardedFor = this.settings().get(KEYS.HEADERAUTH_USE_X_FORWARDED_FOR.key);
        return "true".equals(isHeaderauthUseXForwardedFor);
    }

    public void setHeaderauthUseXForwardedFor(boolean headerauthUseXForwardedFor) {
        this.settings().put(KEYS.HEADERAUTH_USE_X_FORWARDED_FOR.key, (Object)Boolean.toString(headerauthUseXForwardedFor));
    }

    public void addPreemptiveAuthExcludedPaths(String url) {
        Set<String> urls = this.getRequireLoginExcludedPaths();
        urls.add(url);
        this.settings().put(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void removePreemptiveAuthExcludedPaths(String url) {
        Set<String> urls = this.getRequireLoginExcludedPaths();
        urls.remove(url);
        this.settings().put(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public Set<String> getRequireLoginExcludedPaths() {
        return ListParseUtils.parseSetFromCommaSeparated((String)this.settings().get(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key));
    }

    public Set<String> getRestExcludedPaths() {
        String excludedPaths = (String)this.settings().get(KEYS.REST_EXCLUDED_PATHS.key);
        if (excludedPaths == null || excludedPaths.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(excludedPaths.split(",")));
    }

    public void setRestExcludedPaths(Set<String> excludedPaths) {
        StringBuilder sb = new StringBuilder();
        for (String path : excludedPaths) {
            if (!StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
                path = "/" + path;
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(path);
        }
        this.settings().put(KEYS.REST_EXCLUDED_PATHS.key, (Object)sb.toString());
    }

    public boolean isBitbucketScmUrlsEnabled() {
        Object bitbucketScmUrlsEnabled = this.settings().get(KEYS.BITBUCKET_SCM_URLS_ENABLED.key);
        return "true".equals(bitbucketScmUrlsEnabled);
    }

    public void setBitbucketScmUrlsEnabled(boolean bitbucketScmUrlsEnabled) {
        this.settings().put(KEYS.BITBUCKET_SCM_URLS_ENABLED.key, (Object)Boolean.toString(bitbucketScmUrlsEnabled));
    }

    public boolean isBitbucketScmUrlsUsed() {
        Object bitbucketScmUrlsEnabled = this.settings().get(KEYS.BITBUCKET_SCM_URLS_ENABLED.key);
        return bitbucketScmUrlsEnabled != null;
    }

    public boolean isBitbucketKerberosScmUrlsDefault() {
        return "true".equals(this.settings().get(KEYS.BITBUCKET_SCM_URLS_DEFAULT.key));
    }

    public void setBitbucketKerberosScmUrlsDefault(boolean bitbucketKerberosScmUrlsDefault) {
        this.settings().put(KEYS.BITBUCKET_SCM_URLS_DEFAULT.key, (Object)Boolean.toString(bitbucketKerberosScmUrlsDefault));
    }

    public String getBitbucketKerberosScmUrlTypes() {
        return (String)this.settings().get(KEYS.BITBUCKET_SCM_URL_TYPES.key);
    }

    public void setBitbucketKerberosScmUrlTypes(String bitbucketKerberosScmUrlTypes) {
        this.settings().put(KEYS.BITBUCKET_SCM_URL_TYPES.key, (Object)bitbucketKerberosScmUrlTypes);
    }

    public boolean isKerberosRestAuthEnabled() {
        Object jiraRestAuthEnabled = this.settings().get(KEYS.JIRA_REST_AUTH_ENABLED.key);
        Object restAuthEnabled = this.settings().get(KEYS.REST_AUTH_ENABLED.key);
        return "true".equals(jiraRestAuthEnabled) || "true".equals(restAuthEnabled);
    }

    public boolean isKerberosRestFromBrowserEnabled() {
        Object restFromBrowser = this.settings().get(KEYS.KERBEROS_REST_FROM_BROWSER_ENABLED.key);
        return "true".equals(restFromBrowser);
    }

    public void setKerberosRestFromBrowserEnabled(boolean browserKerberosRestAuthEnabled) {
        this.settings().put(KEYS.KERBEROS_REST_FROM_BROWSER_ENABLED.key, (Object)Boolean.toString(browserKerberosRestAuthEnabled));
    }

    public void setKerberosRestAuthEnabled(boolean restAuthEnabled) {
        this.settings().put(KEYS.REST_AUTH_ENABLED.key, (Object)Boolean.toString(restAuthEnabled));
        this.settings().remove(KEYS.JIRA_REST_AUTH_ENABLED.key);
    }

    public boolean isBitbucketKerberosScmUrlsEnabled() {
        Object bitbucketScmUrlsEnabled = this.settings().get(KEYS.BITBUCKET_KERBEROS_SCM_URLS_ENABLED.key);
        return "true".equals(bitbucketScmUrlsEnabled);
    }

    public void setBitbucketKerberosScmUrlsEnabled(boolean bitbucketKerberosScmUrlsEnabled) {
        this.settings().put(KEYS.BITBUCKET_KERBEROS_SCM_URLS_ENABLED.key, (Object)Boolean.toString(bitbucketKerberosScmUrlsEnabled));
    }

    public boolean isWebdavEnabled() {
        return "true".equals(this.settings().get(KEYS.WEBDAV_ENABLED.key));
    }

    public void setWebdavEnabled(boolean webdavEnabled) {
        this.settings().put(KEYS.WEBDAV_ENABLED.key, (Object)Boolean.toString(webdavEnabled));
    }

    public String getCleanupRuleJSONString(CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            return (String)this.settings().get(KEYS.USER_CLEANUP_RULE.key);
        }
        return (String)this.settings().get(KEYS.JSM_CLEANUP_RULE.key);
    }

    public void setCleanupRuleJSONString(String cleanupRuleJson, CleanupMode cleanupMode) {
        if (cleanupMode.equals((Object)CleanupMode.USERS)) {
            this.settings().put(KEYS.USER_CLEANUP_RULE.key, (Object)cleanupRuleJson);
        } else {
            this.settings().put(KEYS.JSM_CLEANUP_RULE.key, (Object)cleanupRuleJson);
        }
    }

    public boolean isClientFailureCollectionEnabled() {
        return "true".equals(this.settings().get(KEYS.FAILURE_COLLECTION.key));
    }

    public void setClientFailureCollectionEnabled(boolean enabled) {
        this.settings().put(KEYS.FAILURE_COLLECTION.key, (Object)Boolean.toString(enabled));
    }

    public void setHomeDirectoryResolver(HomeDirectoryResolver homeDirectoryResolver) {
        this.homeDirectoryResolver = homeDirectoryResolver;
    }

    public boolean isKeytabConfigured() {
        File keytabFile = this.getKeytabFile();
        if (keytabFile == null) {
            return false;
        }
        return keytabFile.exists() && keytabFile.isFile();
    }

    public boolean isKeytabUploaded() {
        return "true".equals(this.settings().get(KEYS.KEYTAB_UPLOADED.key));
    }

    public File getKeytabFile() {
        if (this.isKeytabUploaded()) {
            return this.getUploadedKeytabFile();
        }
        String keytabFile = KerbConfManager.nullsafe(this.settings().get(KEYS.KEYTAB_FILE.key));
        return keytabFile == null ? null : new File(keytabFile);
    }

    public void setKeytabFile(File path) {
        this.settings().put(KEYS.KEYTAB_FILE.key, (Object)path.getAbsolutePath());
        this.settings().put(KEYS.KEYTAB_UPLOADED.key, (Object)"false");
        this.settings().remove(KEYS.PRINCIPAL.key);
        this.flushKeytabCaches();
    }

    public Set<String> getRequiredGroups() {
        String requiredGroups = (String)this.settings().get(KEYS.REQUIRED_GROUP.key);
        if (StringUtils.isBlank((CharSequence)requiredGroups)) {
            return Collections.emptySet();
        }
        String[] groups = requiredGroups.trim().split("\\n");
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = groups[i].trim();
        }
        return new TreeSet<String>(Arrays.asList(groups));
    }

    public void setRequiredGroups(String requiredGroups) {
        if (StringUtils.isBlank((CharSequence)requiredGroups)) {
            this.settings().remove(KEYS.REQUIRED_GROUP.key);
        } else {
            this.settings().put(KEYS.REQUIRED_GROUP.key, (Object)requiredGroups);
        }
    }

    public String getCrowdAutoAddGroups() {
        return (String)this.settings().get(KEYS.CROWD_AUTO_ADD_GROUPS.key);
    }

    public void setCrowdAutoAddGroups(String crowdAutoAddGroups) {
        this.settings().put(KEYS.CROWD_AUTO_ADD_GROUPS.key, (Object)crowdAutoAddGroups);
    }

    public String getAdditionalUserSuffix() {
        return (String)this.settings().get(KEYS.ADDITIONAL_USER_SUFFIX.key);
    }

    public void setAdditionalUserSuffix(String additionalUserSuffix) {
        this.settings().put(KEYS.ADDITIONAL_USER_SUFFIX.key, (Object)additionalUserSuffix);
    }

    public String getRegexLookup() {
        return (String)this.settings().get(KEYS.REGEX_LOOKUP.key);
    }

    public void setRegexLookup(String regexLookup) {
        this.settings().put(KEYS.REGEX_LOOKUP.key, (Object)regexLookup);
    }

    public String getRegexReplacement() {
        return (String)this.settings().get(KEYS.REGEX_REPLACEMENT.key);
    }

    public void setRegexReplacement(String regexReplacement) {
        this.settings().put(KEYS.REGEX_REPLACEMENT.key, (Object)regexReplacement);
    }

    public boolean isRegexLookupEnabled() {
        return "true".equals(this.settings().get(KEYS.REGEX_LOOKUP_ENABLED.key));
    }

    public boolean isOnlyRegexTransformationLookup() {
        return "true".equals(this.settings().get(KEYS.ONLY_REGEX_TRANSFORMATION_LOOKUP.key));
    }

    public void setOnlyRegexTransformationLookup(boolean enabled) {
        this.settings().put(KEYS.ONLY_REGEX_TRANSFORMATION_LOOKUP.key, (Object)Boolean.toString(enabled));
    }

    public void setRegexLookupEnabled(boolean enabled) {
        this.settings().put(KEYS.REGEX_LOOKUP_ENABLED.key, (Object)Boolean.toString(enabled));
    }

    public List<KeytabInfo> getKeytabInfos() {
        try {
            return (List)this.oneMinuteCache.get((Object)KEYTAB_INFO_KEY, () -> {
                File file = this.getKeytabFile();
                if (file != null && file.exists() && file.isFile()) {
                    try (FileInputStream is = new FileInputStream(file);){
                        List list = new KeytabParser().parse((InputStream)is);
                        return list;
                    }
                }
                return Collections.emptyList();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed reading keytab info", e);
        }
    }

    public Map<String, String> getSettings() {
        PluginSettings settings = this.settings();
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys : KEYS.values()) {
            Object value = settings.get(keys.key);
            if (!(value instanceof String)) continue;
            result.put(keys.key, (String)value);
        }
        return result;
    }

    public void restoreSettings(Properties props) {
        PluginSettings settings = this.settings();
        for (KEYS keys : KEYS.values()) {
            settings.remove(keys.key);
        }
        for (KEYS keys : KEYS.values()) {
            String value = props.getProperty(keys.key);
            if (value == null) continue;
            settings.put(keys.key, (Object)value);
        }
    }

    public synchronized void flushCaches() {
        this.oneMinuteCache.invalidateAll();
        this.flushKeytabCaches();
    }

    PluginSettings settings() {
        PluginSettings settingsForKey;
        String dn = this.applicationProperties.getDisplayName().toLowerCase();
        if ((dn.contains("jira") || dn.contains("confluence")) && KerbConfManager.settingsForKeyHasProperties(settingsForKey = this.pluginSettingsFactory.createSettingsForKey(key))) {
            return settingsForKey;
        }
        return this.pluginSettingsFactory.createGlobalSettings();
    }

    public static boolean settingsForKeyHasProperties(PluginSettings settingsForKey) {
        return settingsForKey.get(KEYS.KEYTAB_UPLOADED.key) != null || settingsForKey.get(KEYS.KEYTAB_FILE.key) != null;
    }

    public PluginLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public String getRemoteIpAddress(HttpServletRequest req) {
        String remoteAddr = req.getRemoteAddr();
        String forwardedFor = req.getHeader("x-forwarded-for");
        if (forwardedFor != null && !forwardedFor.equals(remoteAddr) && this.getPreferredProxyHeader() != null) {
            this.log.trace("Using x-forwarded-for IP address");
            String[] forwardedIps = forwardedFor.split(",");
            return forwardedIps[0].trim();
        }
        return remoteAddr;
    }

    public Set<String> getDisabledUserAgents() {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        HashSet<String> set = new HashSet<String>(Arrays.asList(defaultDisabledUserAgents));
        set.addAll(this.getCustomDisabledUserAgents());
        return set;
    }

    public void addCustomDisabledUserAgent(String userAgent) {
        Set<String> userAgents = this.getCustomDisabledUserAgents();
        userAgents.add(userAgent);
        this.settings().put(KEYS.CUSTOM_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(userAgents));
    }

    public void removeCustomDisabledUserAgent(String userAgent) {
        Set<String> urls = this.getCustomDisabledUserAgents();
        urls.remove(userAgent);
        this.settings().put(KEYS.CUSTOM_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(urls));
    }

    public Set<String> getCustomDisabledUserAgents() {
        return new TreeSet<String>(ListParseUtils.parseSetFromNewlines((String)this.settings().get(KEYS.CUSTOM_DISABLED_USER_AGENTS.key)));
    }

    public void addIdpDisabledUserAgent(String userAgent) {
        Set<String> userAgents = this.getIdpDisabledUserAgents();
        userAgents.add(userAgent);
        this.settings().put(KEYS.IDP_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(userAgents));
    }

    public void removeIdpDisabledUserAgent(String userAgent) {
        Set<String> urls = this.getIdpDisabledUserAgents();
        urls.remove(userAgent);
        this.settings().put(KEYS.IDP_DISABLED_USER_AGENTS.key, ListParseUtils.iterableToLineSeparatedString.apply(urls));
    }

    public Set<String> getIdpDisabledUserAgents() {
        return new TreeSet<String>(ListParseUtils.parseSetFromNewlines((String)this.settings().get(KEYS.IDP_DISABLED_USER_AGENTS.key)));
    }

    public boolean isIdpDisabledUserAgent(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        for (String idpDisabledUserAgent : this.getIdpDisabledUserAgents()) {
            if (!userAgent.contains(idpDisabledUserAgent)) continue;
            return true;
        }
        return false;
    }

    public IpRestrictionConfig getIpRestrictionConfig() {
        try {
            return (IpRestrictionConfig)this.oneMinuteCache.get((Object)IpRestrictionConfig.class.getName(), () -> new IpRestrictionConfig(this.settings()));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Couldn't read restriction configuration", e);
        }
    }

    public Object get(KEYS key) {
        return this.settings().get(key.key);
    }

    public void putAndInvalidateCache(KEYS key, Object value) {
        this.settings().put(key.key, value);
        this.oneMinuteCache.invalidateAll();
    }

    public void put(KEYS key, Object value) {
        this.settings().put(key.key, value);
    }

    public void removeUpdateFailures() {
        this.settings().remove(KEYS.CONFIG_UPDATE_FAILURES.key);
    }

    public PluginSettingsFactory getPluginSettingsFactory() {
        return this.pluginSettingsFactory;
    }

    public String getPreferredProxyHeader() {
        return (String)this.settings().get(KEYS.PREFERRED_PROXY_HEADER.key);
    }

    public void setPreferredProxyHeader(String preferredProxyHeader) {
        this.settings().put(KEYS.PREFERRED_PROXY_HEADER.key, (Object)preferredProxyHeader);
    }

    public void setGlobalIpUnblockedList(String unblockedlist) {
        if (unblockedlist != null && unblockedlist.isEmpty()) {
            unblockedlist = null;
        }
        this.settings().put(KEYS.GLOBAL_IP_UNBLOCKEDLIST.key, (Object)unblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setGlobalIpBlockedList(String blockedlist) {
        if (blockedlist != null && blockedlist.isEmpty()) {
            blockedlist = null;
        }
        this.settings().put(KEYS.GLOBAL_IP_BLOCKEDLIST.key, (Object)blockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setGlobalIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings().put(KEYS.GLOBAL_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.name());
        this.oneMinuteCache.invalidateAll();
    }

    public void setRestIpUnblockedList(String ipUnblockedlist) {
        if (ipUnblockedlist != null && ipUnblockedlist.isEmpty()) {
            ipUnblockedlist = null;
        }
        this.settings().put(KEYS.REST_IP_UNBLOCKEDLIST.key, (Object)ipUnblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setRestIpBlockedlist(String blockedlist) {
        if (blockedlist != null && blockedlist.isEmpty()) {
            blockedlist = null;
        }
        this.settings().put(KEYS.REST_IP_BLOCKEDLIST.key, (Object)blockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setRestIpRestrictionType(IpRestrictionType type) {
        this.settings().put(KEYS.REST_IP_RESTRICTION_TYPE.key, (Object)type.name());
        this.oneMinuteCache.invalidateAll();
    }

    public void setCustomDisabledUserAgents(String[] userAgents) {
        if (userAgents != null && userAgents.length == 0) {
            userAgents = null;
        }
        this.settings().put(KEYS.CUSTOM_DISABLED_USER_AGENTS.key, (Object)StringUtils.join((Object[])userAgents, (String)"\n"));
        this.oneMinuteCache.invalidateAll();
    }

    public boolean isRemembermeCookieEnabled() {
        return "true".equals(this.settings().get(KEYS.REMEMBERME_COOKIE_ENABLED.key));
    }

    public void setRemembermeCookieEnabled(boolean value) {
        this.settings().put(KEYS.REMEMBERME_COOKIE_ENABLED.key, (Object)Boolean.toString(value));
    }

    public boolean isLdapFilterEncoding() {
        return !"false".equals(this.settings().get(KEYS.LDAP_FILTER_ENCODING.key));
    }

    public void setLdapFilterEncoding(boolean value) {
        this.settings().put(KEYS.LDAP_FILTER_ENCODING.key, (Object)Boolean.toString(value));
    }

    public boolean isApiTokensEnabled() {
        return "true".equals(this.settings().get(KEYS.API_TOKENS_ENABLED.key));
    }

    public void setApiTokensEnabled(boolean value) {
        this.settings().put(KEYS.API_TOKENS_ENABLED.key, (Object)Boolean.toString(value));
    }

    public ApiTokenUtil.TokenUserPermission getApiTokenUserPermission() {
        String tokenUserPermission = (String)this.settings().get(KEYS.API_TOKEN_USER_PERMISSION.key);
        if (tokenUserPermission != null) {
            return ApiTokenUtil.TokenUserPermission.valueOf(tokenUserPermission);
        }
        ApiTokenUtil.TokenUserPermission allUsers = this.checkOldConfigUserPermission();
        if (allUsers != null) {
            return allUsers;
        }
        return ApiTokenUtil.TokenUserPermission.NO_USERS;
    }

    public void setApiTokenUserPermission(ApiTokenUtil.TokenUserPermission value) {
        this.settings().put(KEYS.API_TOKEN_USER_PERMISSION.key, (Object)value.name());
    }

    @Nullable
    private ApiTokenUtil.TokenUserPermission checkOldConfigUserPermission() {
        String oldConfigTokenUserPermission = (String)this.settings().get(KEYS.USER_API_TOKEN_ENABLED.key);
        if (oldConfigTokenUserPermission != null && "true".equals(this.settings().get(KEYS.USER_API_TOKEN_ENABLED.key))) {
            return ApiTokenUtil.TokenUserPermission.ALL_USERS;
        }
        return null;
    }

    public List<String> getApiTokenAllowedUserGroups() {
        String commaSeparatedAllowedGroups = (String)this.settings().get(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key);
        return ListParseUtils.parseListFromCommaSeparated(commaSeparatedAllowedGroups);
    }

    public void setApiTokenAllowedUserGroups(String commaSeparatedAllowedGroups) {
        if (StringUtils.isBlank((CharSequence)commaSeparatedAllowedGroups)) {
            this.settings().remove(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key);
        } else {
            this.settings().put(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key, (Object)commaSeparatedAllowedGroups);
        }
    }

    public void setApiTokenIpUnblockedList(String unblockedlist) {
        this.settings().put(KEYS.API_TOKEN_IP_UNBLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)unblockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setApiTokenIpBlockedList(String blockedlist) {
        this.settings().put(KEYS.API_TOKEN_IP_BLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)blockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setApiTokenIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings().put(KEYS.API_TOKEN_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.name());
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpUnblockedList(String unblockedlist) {
        this.settings().put(KEYS.BASIC_AUTH_IP_UNBLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)unblockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpBlockedList(String blockedlist) {
        this.settings().put(KEYS.BASIC_AUTH_IP_BLOCKEDLIST.key, (Object)StringUtils.trimToNull((String)blockedlist));
        this.oneMinuteCache.invalidateAll();
    }

    public void setBasicAuthIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings().put(KEYS.BASIC_AUTH_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.name());
        this.oneMinuteCache.invalidateAll();
    }

    public long getApiTokensUserMaxTimeRestriction() {
        Try<Long> maybeRestriction = ApiTokenUtil.Validation.tryParseTokenTimeLimit((String)this.settings().get(KEYS.API_TOKEN_USER_MAX_TIME_RESTRICTION.key));
        return (Long)maybeRestriction.getOrElse((Object)-1L);
    }

    public void setApiTokensUserMaxTimeRestriction(String maxAllowedTime) {
        Try<Long> maxAllowed = ApiTokenUtil.Validation.tryParseTokenTimeLimit(maxAllowedTime);
        if (maxAllowed.isSuccess()) {
            this.settings().put(KEYS.API_TOKEN_USER_MAX_TIME_RESTRICTION.key, (Object)((Long)maxAllowed.get()).toString());
        }
    }

    public boolean isSSOEnabledForUserAvatar() {
        return "true".equals(this.settings().get(KEYS.SSO_ENABLED_FOR_USER_AVATAR.key));
    }

    public void setSSOEnabledForUserAvatar(boolean isSSOEnabledForUserAvatar) {
        this.settings().put(KEYS.SSO_ENABLED_FOR_USER_AVATAR.key, (Object)Boolean.toString(isSSOEnabledForUserAvatar));
    }

    public boolean isUserAgentEnabled(String userAgent) {
        return this.isUserAgentEnabled(userAgent, this.getDisabledUserAgents());
    }

    public boolean isUserAgentEnabledByCustomList(String userAgent) {
        return this.isUserAgentEnabled(userAgent, this.getCustomDisabledUserAgents());
    }

    public boolean isUserAgentEnabledByDefaultList(String userAgent) {
        return this.isUserAgentEnabled(userAgent, new HashSet<String>(Arrays.asList(defaultDisabledUserAgents)));
    }

    private boolean isUserAgentEnabled(String userAgent, Set<String> listOfDisabledUserAgentNames) {
        if (userAgent == null) {
            return false;
        }
        if (listOfDisabledUserAgentNames != null) {
            for (String disabledUserAgent : listOfDisabledUserAgentNames) {
                if (!userAgent.contains(disabledUserAgent)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized void setKeytabContent(byte[] bytes) {
        File keytabFile = this.getUploadedKeytabFile();
        if (keytabFile.getParentFile().mkdirs()) {
            this.log.debug("Created new file for keytab content");
        }
        try {
            FileUtils.writeByteArrayToFile((File)keytabFile, (byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PluginSettings settings = this.settings();
        settings.put(KEYS.KEYTAB_UPLOADED.key, (Object)"true");
        settings.remove(KEYS.KEYTAB_FILE.key);
        settings.remove(KEYS.PRINCIPAL.key);
        this.flushKeytabCaches();
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void resetConfiguration() {
        PluginSettings settings = this.settings();
        for (KEYS key : KEYS.values()) {
            settings.remove(key.key);
        }
    }

    private File getUploadedKeytabFile() {
        return new File(this.homeDirectoryResolver.getHomeDirectory(), "kerberos.keytab");
    }

    public boolean isJsmInstalled() {
        if ("JIRA".equals(this.applicationProperties.getDisplayName())) {
            for (Plugin plugin : this.pluginAccessor.getPlugins()) {
                String key = plugin.getKey();
                if (key == null || !key.startsWith("com.atlassian.servicedesk")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isKerberosJsmEnabled() {
        Object kerberosJsmEnabled = this.settings().get(KEYS.KERBEROS_JSM_ENABLED.key);
        return "true".equals(kerberosJsmEnabled) || kerberosJsmEnabled == null;
    }

    public void setKerberosJsmEnabled(boolean kerberosJsmEnabled) {
        this.settings().put(KEYS.KERBEROS_JSM_ENABLED.key, (Object)Boolean.toString(kerberosJsmEnabled));
    }

    public boolean isKerberosKnowledgeBaseEnabled() {
        Object kerberosKnowledgeBaseEnabled = this.settings().get(KEYS.KERBEROS_KNOWLEDGEBASE_ENABLED.key);
        return "true".equals(kerberosKnowledgeBaseEnabled) || kerberosKnowledgeBaseEnabled == null;
    }

    public void setKerberosKnowledgeBaseEnabled(boolean kerberosKnowledgeBaseEnabled) {
        this.settings().put(KEYS.KERBEROS_KNOWLEDGEBASE_ENABLED.key, (Object)Boolean.toString(kerberosKnowledgeBaseEnabled));
    }

    public boolean isLicenseExpiryNotificationsSnoozed() {
        try {
            String snoozeTimestamp = (String)this.settings().get(KEYS.LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE.key);
            if (snoozeTimestamp != null) {
                return DateTime.now().isBefore((ReadableInstant)new DateTime((Object)snoozeTimestamp));
            }
        }
        catch (Exception e) {
            this.log.warn("Exception while checking if license expiry notifications are snoozed:", (Throwable)e);
        }
        return false;
    }

    public void setLicenseExpiryNotificationsSnooze(DateTime timestamp) {
        if (!this.isLicenseExpiryNotificationsSnoozed()) {
            this.settings().put(KEYS.LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE.key, (Object)timestamp.toString());
        }
    }

    public long howManyDaysUntilKssoLicenseExpiry() {
        String expiryDate = ((DateTime)((PluginLicense)this.licenseManager.getLicense().get()).getMaintenanceExpiryDate().get()).toString();
        ZonedDateTime expiryDateLocal = ZonedDateTime.parse(expiryDate);
        ZonedDateTime now = ZonedDateTime.now();
        return Duration.between(now, expiryDateLocal).toDays();
    }

    public Option<Version> getSavedKssoConfigVersion() {
        return Option.of((Object)((String)this.settings().get(KEYS.KSSO_CONFIG_VERSION.key))).map(Version::new);
    }

    public static Option<Version> getRunningKssoVersion() {
        return Option.of((Object)KerbConfManager.getBuildInfo()).map(buildInfo -> buildInfo.getProperty("build.version")).map(Version::new);
    }

    public void setKssoConfigVersion(Version version) {
        if (version != null && StringUtils.isNotBlank((CharSequence)version.stringValue)) {
            this.log.debug("Setting KSSO config version from {} to {}", this.getSavedKssoConfigVersion().map(Version::stringValue).getOrElse((Object)"<unknown>"), (Object)version.stringValue);
            this.settings().put(KEYS.KSSO_CONFIG_VERSION.key, (Object)version.stringValue);
        }
    }

    public void darkFeatureRemoveKssoConfigVersion() {
        this.log.debug("Dark feature: remove the KSSO config version {} ", this.getSavedKssoConfigVersion().map(Version::stringValue).getOrElse((Object)"<unknown>"));
        this.settings().remove(KEYS.KSSO_CONFIG_VERSION.key);
    }

    public void updateKssoVersionInConfig() {
        KerbConfManager.getRunningKssoVersion().peek(this::setKssoConfigVersion);
    }

    public boolean isAnySettingsConfigured() {
        return io.vavr.collection.List.of((Object[])KEYS.values()).exists(key -> Option.of((Object)this.settings().get(key.key)).isDefined());
    }

    public boolean hasKerberosFolder() {
        return Files.exists(this.getHomeDirectoryResolver().getHomeDirectory().toPath(), new LinkOption[0]);
    }

    public boolean isUserdetailsInCommentsEnabled() {
        Object kerberosKnowledgeBaseEnabled = this.settings().get(KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key);
        return "true".equals(kerberosKnowledgeBaseEnabled);
    }

    public void setUserdetailsInCommentsEnabled(boolean userdetailsInComments) {
        this.settings().put(KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key, (Object)Boolean.toString(userdetailsInComments));
    }

    public Set<String> getAllowTraditionalLoginGroups() {
        try {
            String loginGroups = (String)this.oneMinuteCache.get((Object)"getAllowTraditionalLoginGroups", () -> Option.of((Object)this.settings().get(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated(loginGroups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getAllowTraditionalLoginGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public void setAllowTraditionalLoginGroups(Set<String> groups) {
        this.settings().put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void addAllowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getAllowTraditionalLoginGroups();
        groups.add(group);
        this.settings().put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeAllowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getAllowTraditionalLoginGroups();
        groups.remove(group);
        this.settings().put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyAllowTraditionalLoginGroups() {
        Set<String> groups = this.getAllowTraditionalLoginGroups();
        this.settings().remove(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return groups;
    }

    public Set<String> getAllowKerberosLoginGroups() {
        return ListParseUtils.parseSetFromCommaSeparated((String)this.settings().get(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key));
    }

    public void setAllowKerberosLoginGroups(Set<String> groups) {
        this.settings().put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public void addAllowKerberosLoginGroups(String group) {
        Set<String> groups = this.getAllowKerberosLoginGroups();
        groups.add(group);
        this.settings().put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public void removeAllowKerberosLoginGroups(String group) {
        Set<String> groups = this.getAllowKerberosLoginGroups();
        groups.remove(group);
        this.settings().put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public Set<String> emptyAllowKerberosLoginGroups() {
        Set<String> groups = this.getAllowKerberosLoginGroups();
        this.settings().remove(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key);
        return groups;
    }

    public Set<String> getDisallowTraditionalLoginGroups() {
        try {
            String loginGroups = (String)this.oneMinuteCache.get((Object)"getDisallowTraditionalLoginGroups", () -> Option.of((Object)this.settings().get(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated(loginGroups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getAllowTraditionalLoginGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public Set<String> getDisallowKerberosLoginGroups() {
        return ListParseUtils.parseSetFromCommaSeparated((String)this.settings().get(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key));
    }

    public void addDisallowKerberosLoginGroups(String group) {
        Set<String> groups = this.getDisallowKerberosLoginGroups();
        groups.add(group);
        this.settings().put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public void setDisallowKerberosLoginGroups(Set<String> groups) {
        this.settings().put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public void removeDisallowKerberosLoginGroups(String group) {
        Set<String> groups = this.getDisallowKerberosLoginGroups();
        groups.remove(group);
        this.settings().put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
    }

    public Set<String> emptyDisallowKerberosLoginGroups() {
        Set<String> urls = this.getDisallowKerberosLoginGroups();
        this.settings().remove(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key);
        return urls;
    }

    public void setDisallowTraditionalLoginGroups(Set<String> groups) {
        this.settings().put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void addDisallowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getDisallowTraditionalLoginGroups();
        groups.add(group);
        this.settings().put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeDisallowTraditionalLoginGroups(String group) {
        Set<String> groups = this.getDisallowTraditionalLoginGroups();
        groups.remove(group);
        this.settings().put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyDisallowTraditionalLoginGroups() {
        Set<String> urls = this.getDisallowTraditionalLoginGroups();
        this.settings().remove(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return urls;
    }

    public Set<String> getAllowBasicAuthGroups() {
        try {
            String loginGroups = (String)this.oneMinuteCache.get((Object)"getAllowBasicAuthGroups", () -> Option.of((Object)this.settings().get(KEYS.ALLOW_BASIC_AUTH_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated(loginGroups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getAllowBasicAuthGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public void setAllowBasicAuthGroups(Set<String> groups) {
        this.settings().put(KEYS.ALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void addAllowBasicAuthGroups(String group) {
        Set<String> groups = this.getAllowBasicAuthGroups();
        groups.add(group);
        this.settings().put(KEYS.ALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeAllowBasicAuthGroups(String group) {
        Set<String> groups = this.getAllowBasicAuthGroups();
        groups.remove(group);
        this.settings().put(KEYS.ALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyAllowBasicAuthGroups() {
        Set<String> groups = this.getAllowBasicAuthGroups();
        this.settings().remove(KEYS.ALLOW_BASIC_AUTH_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return groups;
    }

    public Set<String> getDisallowBasicAuthGroups() {
        try {
            String groups = (String)this.oneMinuteCache.get((Object)"getDisallowBasicAuthGroups", () -> Option.of((Object)this.settings().get(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key)).getOrElse((Object)""));
            return ListParseUtils.parseSetFromCommaSeparated(groups);
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking getDisallowBasicAuthGroups status", e.getCause());
            return new HashSet<String>();
        }
    }

    public void setDisallowBasicAuthGroups(Set<String> groups) {
        this.settings().put(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void addDisallowBasicAuthGroups(String group) {
        Set<String> groups = this.getDisallowBasicAuthGroups();
        groups.add(group);
        this.settings().put(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public void removeDisallowBasicAuthGroups(String group) {
        Set<String> groups = this.getDisallowBasicAuthGroups();
        groups.remove(group);
        this.settings().put(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups));
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> emptyDisallowBasicAuthGroups() {
        Set<String> groups = this.getDisallowBasicAuthGroups();
        this.settings().remove(KEYS.DISALLOW_BASIC_AUTH_GROUPS.key);
        this.oneMinuteCache.invalidateAll();
        return groups;
    }

    public Set<String> getApiTokenAccessUrls() {
        return ListParseUtils.parseSetFromCommaSeparated((String)this.settings().get(KEYS.API_TOKEN_ACCESS_URLS.key));
    }

    public void addApiTokenAccessUrls(String url) {
        Set<String> urls = this.getApiTokenAccessUrls();
        urls.add(url);
        this.settings().put(KEYS.API_TOKEN_ACCESS_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void removeApiTokenAccessUrls(String url) {
        Set<String> urls = this.getApiTokenAccessUrls();
        urls.remove(url);
        url = url.replaceAll("\\?", "\ufffd");
        urls.remove(url);
        this.settings().put(KEYS.API_TOKEN_ACCESS_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public Set<String> getForcedSsoUrls() {
        return ListParseUtils.parseSetFromCommaSeparated((String)this.settings().get(KEYS.FORCED_SSO_URLS.key));
    }

    public void addForcedSsoUrls(String url) {
        Set<String> urls = this.getForcedSsoUrls();
        urls.add(url);
        this.settings().put(KEYS.FORCED_SSO_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void removeForcedSsoUrls(String url) {
        Set<String> urls = this.getForcedSsoUrls();
        urls.remove(url);
        this.settings().put(KEYS.FORCED_SSO_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public boolean isMsTeamsAuthenticationEnabled() {
        Object msTeamsAuthenticationEnabled = this.settings().get(KEYS.MS_TEAMS_AUTHENTICATION_ENABLED.key);
        return "true".equals(msTeamsAuthenticationEnabled);
    }

    public void setMsTeamsAuthenticationEnabled(boolean msTeamsAuthenticationEnabled) {
        this.settings().put(KEYS.MS_TEAMS_AUTHENTICATION_ENABLED.key, (Object)Boolean.toString(msTeamsAuthenticationEnabled));
    }

    public boolean isMsTeamsSecurityHeadersEnabled() {
        Object msTeamsSecurityHeadersEnabled = this.settings().get(KEYS.MS_TEAMS_SECURITY_HEADERS_ENABLED.key);
        return "true".equals(msTeamsSecurityHeadersEnabled);
    }

    public void setMsTeamsSecurityHeadersEnabled(boolean msTeamsSecurityHeadersEnabled) {
        this.settings().put(KEYS.MS_TEAMS_SECURITY_HEADERS_ENABLED.key, (Object)Boolean.toString(msTeamsSecurityHeadersEnabled));
    }

    public String getMsTeamsClientId() {
        return (String)this.settings().get(KEYS.MS_TEAMS_CLIENT_ID.key);
    }

    public void setMsTeamsClientId(String msTeamsClientId) {
        if (msTeamsClientId != null && msTeamsClientId.isEmpty()) {
            msTeamsClientId = null;
        }
        this.settings().put(KEYS.MS_TEAMS_CLIENT_ID.key, (Object)msTeamsClientId);
        this.oneMinuteCache.invalidateAll();
    }

    public String getMsTeamsSecret() {
        return (String)this.settings().get(KEYS.MS_TEAMS_SECRET.key);
    }

    public void setMsTeamsSecret(String msTeamsSecret) {
        if (msTeamsSecret != null && msTeamsSecret.isEmpty()) {
            msTeamsSecret = null;
        }
        this.settings().put(KEYS.MS_TEAMS_SECRET.key, (Object)msTeamsSecret);
        this.oneMinuteCache.invalidateAll();
    }

    public Set<String> getSecurityHeaderAllowedHostNames() {
        return ListParseUtils.parseSetFromCommaSeparated((String)this.settings().get(KEYS.SECURITY_HEADER_ALLOWED_HOST_NAMES.key));
    }

    public void removeSecurityHeaderAllowedHostNames(String url) {
        Set<String> urls = this.getSecurityHeaderAllowedHostNames();
        urls.remove(url);
        this.settings().put(KEYS.SECURITY_HEADER_ALLOWED_HOST_NAMES.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public void addSecurityHeaderAllowedHostNames(String url) {
        Set<String> urls = this.getSecurityHeaderAllowedHostNames();
        urls.add(url);
        this.settings().put(KEYS.SECURITY_HEADER_ALLOWED_HOST_NAMES.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls));
    }

    public HomeDirectoryResolver getHomeDirectoryResolver() {
        return this.homeDirectoryResolver;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        JSONArray installedPlugins = new JSONArray((Collection)this.pluginAccessor.getPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).filter(plugin -> !io.vavr.collection.List.of((Object[])new String[]{"Atlassian", "Atlassian Community", "Atlassian Software Systems", "Atlassian Software Systems Pty Ltd", "OSGi Alliance", "The Apache Software Foundation"}).contains((Object)plugin.getPluginInformation().getVendorName())).map(plugin -> new JSONObject((Map)io.vavr.collection.HashMap.of((Object)"key", (Object)plugin.getKey(), (Object)"name", (Object)plugin.getName(), (Object)"version", (Object)plugin.getPluginInformation().getVersion(), (Object)"vendor", (Object)plugin.getPluginInformation().getVendorName(), (Object)"pluginState", (Object)plugin.getPluginState()).toJavaMap())).collect(Collectors.toList()));
        JSONObject licenseJson = new JSONObject();
        licenseJson.put("isActive", this.licenseManager.getLicense().map(PluginLicense::isActive).getOrElse((Object)false));
        licenseJson.put("isAutoRenewal", this.licenseManager.getLicense().map(PluginLicense::isAutoRenewal).getOrElse((Object)false));
        licenseJson.put("isEmbeddedWithinHostLicense", this.licenseManager.getLicense().map(PluginLicense::isEmbeddedWithinHostLicense).getOrElse((Object)false));
        licenseJson.put("isEnterprise", this.licenseManager.getLicense().map(PluginLicense::isEnterprise).getOrElse((Object)false));
        licenseJson.put("isEvaluation", this.licenseManager.getLicense().map(PluginLicense::isEvaluation).getOrElse((Object)false));
        licenseJson.put("isMaintenanceExpired", this.licenseManager.getLicense().map(PluginLicense::isMaintenanceExpired).getOrElse((Object)false));
        licenseJson.put("isSubscription", this.licenseManager.getLicense().map(PluginLicense::isSubscription).getOrElse((Object)false));
        licenseJson.put("isUnlimitedEdition", this.licenseManager.getLicense().map(PluginLicense::isUnlimitedEdition).getOrElse((Object)false));
        licenseJson.put("isValid", this.licenseManager.getLicense().map(PluginLicense::isValid).getOrElse((Object)false));
        licenseJson.put("isUnlimitedNumberOfUsers", this.licenseManager.getLicense().map(PluginLicense::isUnlimitedNumberOfUsers).getOrElse((Object)false));
        licenseJson.put("error", this.licenseManager.getLicense().flatMap(PluginLicense::getError).map(Enum::name).getOrElse((Object)""));
        licenseJson.put("organization", this.licenseManager.getLicense().map(PluginLicense::getOrganization).map(Organization::getName).getOrElse((Object)""));
        licenseJson.put("partner", this.licenseManager.getLicense().flatMap(PluginLicense::getPartner).map(Organization::getName).getOrElse((Object)""));
        licenseJson.put("maxNumberOfUsers", this.licenseManager.getLicense().flatMap(PluginLicense::getMaximumNumberOfUsers).getOrElse((Object)0));
        JSONObject statsJson = new JSONObject();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        statsJson.put("attempts", this.stats.getAttempts());
        statsJson.put("authFailed", this.stats.getAuthFailed());
        statsJson.put("failedDecodingToken", this.stats.getFailedDecodingToken());
        statsJson.put("failedParsingToken", this.stats.getFailedParsingToken());
        statsJson.put("kerberosLockout", (Object)this.stats.getKerberosLockout());
        statsJson.put("lacksPermission", this.stats.getLacksPermission());
        statsJson.put("lacksRequiredGroup", this.stats.getLacksRequiredGroup());
        statsJson.put("missingUsers", this.stats.getMissingUsers());
        statsJson.put("since", (Object)dateFormat.format(this.stats.getSince().getTime()));
        statsJson.put("successes", this.stats.getSuccesses());
        statsJson.put("wrongTokenBasic", this.stats.getWrongTokenBasic());
        statsJson.put("wrongTokenNotKerberos", this.stats.getWrongTokenNotKerberos());
        statsJson.put("wrongTokenNotNegotiate", this.stats.getWrongTokenNotNegotiate());
        statsJson.put("wrongTokenNtlm", this.stats.getWrongTokenNtlm());
        JSONObject settingsJson = new JSONObject();
        Try.run(() -> io.vavr.collection.List.of((Object[])KEYS.values()).forEach(key -> settingsJson.put(key.name(), this.settings().get(key.key)))).onFailure(throwable -> this.log.debug("Could not provide settings for json: ", throwable));
        settingsJson.put("isTraditionalLoginPrevented", this.isTraditionalLoginPrevented());
        settingsJson.put("isTraditionalLoginJsmPrevented", this.isTraditionalLoginJsmPrevented());
        settingsJson.put("isBasicAuthPrevented", this.isBasicAuthPrevented());
        settingsJson.put("isCsrfOriginCheckEnabled", this.isCsrfOriginCheckEnabled());
        json.put("stats", (Object)statsJson);
        json.put("license", (Object)licenseJson);
        json.put("installedPlugins", (Object)installedPlugins);
        json.put("settings", (Object)settingsJson);
        return json;
    }

    public void setSendToDashboardAfterLogin(boolean sendToDashboardAfterLogin) {
        this.settings().put(KEYS.SEND_TO_DASHBOARD_AFTER_LOGIN.key, (Object)Boolean.toString(sendToDashboardAfterLogin));
    }

    public boolean isSendToDashboardAfterLogin() {
        Object sendToDashboardAfterLogin = this.settings().get(KEYS.SEND_TO_DASHBOARD_AFTER_LOGIN.key);
        return !"false".equals(sendToDashboardAfterLogin);
    }

    public void setShouldHideUsernameField(boolean shouldHideUsernameField) {
        this.settings().put(KEYS.SHOULD_HIDE_USERNAME_FIELD.key, (Object)Boolean.toString(shouldHideUsernameField));
    }

    public boolean shouldHideUsernameField() {
        Object shouldHideUsernameField = this.settings().get(KEYS.SHOULD_HIDE_USERNAME_FIELD.key);
        return "true".equals(shouldHideUsernameField);
    }

    public String[] getDefaultDisabledUserAgents() {
        return defaultDisabledUserAgents;
    }

    public static enum IpRestrictionType {
        UNRESTRICTED("UNRESTRICTED"),
        UNBLOCKEDLIST("WHITELIST"),
        BLOCKEDLIST("BLACKLIST");

        private final String alias;

        private IpRestrictionType(String alias) {
            this.alias = alias;
        }

        public static IpRestrictionType getValueByNameOrAlias(String name) {
            return Arrays.stream(IpRestrictionType.values()).filter(m -> m.name().equals(name) || m.alias.equals(name)).findAny().orElseThrow(IllegalArgumentException::new);
        }

        public String stringValue() {
            switch (this) {
                case UNBLOCKEDLIST: {
                    return "Unblocked list";
                }
                case BLOCKEDLIST: {
                    return "Blocked list";
                }
                case UNRESTRICTED: {
                    return "Unrestricted";
                }
            }
            throw new IllegalArgumentException("Bad type");
        }
    }

    public static enum KEYS {
        ADDITIONAL_USER_SUFFIX("additionalUserSuffix"),
        REGEX_LOOKUP("regexLookup"),
        REGEX_REPLACEMENT("regexReplacement"),
        REGEX_LOOKUP_ENABLED("regexLookupEnabled"),
        ONLY_REGEX_TRANSFORMATION_LOOKUP("onlyRegexTransformationLookup"),
        CROWD_AUTO_ADD_GROUPS("crowdAutoAddGroups"),
        LEGACY_GLOBAL_IP_BLOCKEDLIST("ipblacklist"),
        LEGACY_GLOBAL_IP_UNBLOCKEDLIST("ipwhitelist"),
        GLOBAL_IP_BLOCKEDLIST("version5ipBlockedlist"),
        GLOBAL_IP_UNBLOCKEDLIST("version5ipUnblockedlist"),
        GLOBAL_IP_RESTRICTION_TYPE("iprestrictiontype"),
        LEGACY_REST_IP_BLOCKEDLIST("restipblacklist"),
        LEGACY_REST_IP_UNBLOCKEDLIST("restipwhitelist"),
        REST_IP_BLOCKEDLIST("version5restIpBlockedlist"),
        REST_IP_UNBLOCKEDLIST("version5restIpUnblockedlist"),
        REST_IP_RESTRICTION_TYPE("restiprestrictiontype"),
        CUSTOM_DISABLED_USER_AGENTS("customDisabledUserAgents"),
        IDP_DISABLED_USER_AGENTS("idpDisabledUserAgents"),
        KEYTAB_FILE("keytabFile"),
        PREEMPTIVE_AUTH_EXCLUDED_PATHS("preemptiveAuthExcludedPaths"),
        REST_EXCLUDED_PATHS("RestExcludedPaths"),
        VALID_USER_GROUPS("ValidUserGroups"),
        PREFERRED_PROXY_HEADER("preferredproxyheader"),
        PRINCIPAL("principal"),
        REQUIRED_GROUP("requiredGroup"),
        BITBUCKET_SCM_URLS_DEFAULT("bitbucketScmUrlsDefault"),
        BITBUCKET_SCM_URLS_ENABLED("bitbucketScmUrlsEnabled"),
        BITBUCKET_KERBEROS_SCM_URLS_ENABLED("bitbucketKerberosScmUrlsEnabled"),
        BITBUCKET_SCM_URL_TYPES("bitbucketScmUrlTypes"),
        FAILURE_COLLECTION("failurecollection"),
        KERBEROS_ENABLED("kerberosEnabled"),
        KEYTAB_UPLOADED("uploaded"),
        MANUAL_LOGIN_LOG_ENABLED("manualLoginLogEnabled"),
        REQUIRE_LOGIN_ENABLED("preemptiveAuthEnabled"),
        SEND_TO_LOGIN_ENABLED("sendToLoginEnabled"),
        JIRA_REST_AUTH_ENABLED("jiraRestAuthEnabled"),
        KERBEROS_JSM_ENABLED("jiraKerberosJsmEnabled"),
        KERBEROS_KNOWLEDGEBASE_ENABLED("jiraKerberosKnowledgeBaseEnabled"),
        REST_AUTH_ENABLED("restAuthEnabled"),
        KERBEROS_REST_FROM_BROWSER_ENABLED("kerberosRestRequestFromBrowserEnabled"),
        USERNAME_ATTR_LOOKUP_ENABLED("userNameAttributeLookupEnabled"),
        USER_PRINCIPAL_ATTR_LOOKUP_ENABLED("userPrincipalNameLookupEnabled"),
        WEBDAV_ENABLED("webdavEnabled"),
        SHOW_WELCOME_MESSAGE("showWelcomeMessage"),
        ERROR_PAGE_MESSAGE("errorPageMessage"),
        TRADITIONALLOGINDISABLEDMESSAGE("traditionalLoginDisabledMessage"),
        ALLTRADITIONALLOGINDISABLEDMESSAGE("allTraditionalLoginDisabledMessage"),
        BASIC_AUTH_IP_RESTRICTION_TYPE("basicAuthIpRestrictionType"),
        BASIC_AUTH_IP_BLOCKEDLIST("version5BasicAuthIpBlockedList"),
        BASIC_AUTH_IP_UNBLOCKEDLIST("version5BasicAuthnIpUnblockedList"),
        ALLOW_TRADITIONAL_LOGIN_GROUPS("allowTraditionalLoginGroups"),
        DISALLOW_TRADITIONAL_LOGIN_GROUPS("disallowTraditionalLoginGroups"),
        ALLOW_BASIC_AUTH_GROUPS("allowBasicAuthGroups"),
        DISALLOW_BASIC_AUTH_GROUPS("disallowBasicAuthGroups"),
        SAML_LOGIN_USERNAME_PLACEHOLDER("samlLoginUsernamePlaceholder"),
        USERNAME_FIELD_TEXT("usernameFieldText"),
        NEXT_BUTTON_TEXT("nextButtonText"),
        IDP_LIST_TITLE_TEXT("idpListTitleText"),
        LEGACY_HEADER_USERNAME_IP_UNBLOCKEDLIST("headerUsernameIpWhitelist"),
        HEADER_USERNAME_IP_UNBLOCKEDLIST("version5headerUsernameIpWhitelist"),
        HEADER_USERNAME_ATTRIBUTE("headerUsernameAttribute"),
        HEADERAUTH_USE_X_FORWARDED_FOR("headerauthUseXForwardedFor"),
        HEADER_EMAIL_ATTRIBUTE("headerEmailAttribute"),
        JSM_SIGNUP_EMAIL_UNBLOCKEDLIST("jsmSignupEmailUnblockedlist"),
        JSM_SIGNUP_FORM_URLPARTS("jsmSignupFormUrlparts"),
        REMEMBERME_COOKIE_ENABLED("remembermeCookieEnabled"),
        API_TOKENS_ENABLED("apiTokensEnabled"),
        USER_API_TOKEN_ENABLED("userApiTokenEnabled"),
        API_TOKEN_USER_PERMISSION("apiTokenUserPermission"),
        API_TOKEN_ALLOWED_USER_GROUPS("apiTokenAllowedUserGroups"),
        LEGACY_API_TOKEN_IP_BLOCKEDLIST("apiTokenIpBlacklist"),
        LEGACY_API_TOKEN_IP_UNBLOCKEDLIST("apiTokenIpWhitelist"),
        API_TOKEN_IP_BLOCKEDLIST("version5ApiTokenIpBlockedList"),
        API_TOKEN_IP_UNBLOCKEDLIST("version5ApiTokenIpUnblockedList"),
        API_TOKEN_IP_RESTRICTION_TYPE("apiTokenIpRestrictionType"),
        API_TOKEN_USER_MAX_TIME_RESTRICTION("apiTokensUserMaxTimeRestriction"),
        SSO_ENABLED_FOR_USER_AVATAR("SSOEnabledForUserAvatar"),
        KSSO_CONFIG_VERSION("kssoVersion"),
        LOCKED_REST_API_ERROR_PAGE_MESSAGE("lockedRestApiErrorPageMessage"),
        USER_DETAILS_IN_COMMENTS_ENABLED("userdetailsInComments"),
        ALLOW_KERBEROS_LOGIN_GROUPS("allowKerberosLoginGroups"),
        DISALLOW_KERBEROS_LOGIN_GROUPS("disallowKerberosLoginGroups"),
        API_TOKEN_ACCESS_URLS("apiTokenAccessUrls"),
        FORCED_SSO_URLS("forcedSsoUrls"),
        CONFIG_UPDATE_FAILURES("upgradeFailures"),
        MS_TEAMS_AUTHENTICATION_ENABLED("msTeamsAuthenticationEnabled"),
        MS_TEAMS_SECURITY_HEADERS_ENABLED("msTeamsSecurityHeadersEnabled"),
        SECURITY_HEADER_ALLOWED_HOST_NAMES("securityHeaderAllowedHostNames"),
        MS_TEAMS_CLIENT_ID("msTeamsClientId"),
        MS_TEAMS_SECRET("msTeamsSecret"),
        USER_CLEANUP_RULE("userCleanupRule"),
        JSM_CLEANUP_RULE("jsmCleanupRule"),
        LDAP_FILTER_ENCODING("ldapFilterEncoding"),
        LICENSE_EXPIRY_NOTIFICATIONS_SNOOZE("licenseExpiryNotificationsSnooze"),
        SEND_TO_DASHBOARD_AFTER_LOGIN("sendToDashboardAfterLogin"),
        COLLECT_LAST_USER_AGENTS_LIST_ENABLED("collectLastUserAgentsList"),
        SHOULD_HIDE_USERNAME_FIELD("shouldHideUsernameField");

        public final String key;

        private KEYS(String key) {
            this.key = key;
        }

        public boolean hasAlias(String alias) {
            return this.key.equals(alias);
        }
    }
}

