/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class CustomizableTextsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final IdpConfManager idpConfManager;

    public CustomizableTextsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "customizable-texts");
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
        model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
        model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
        model.put("defaultSamlLoginUsernamePlaceholder", this.kerbConfManager.getDefaultSamlLoginUsernamePlaceholder());
        model.put("defaultErrorPageMessage", this.kerbConfManager.getDefaultErrorPageMessage());
        model.put("defaultUsernameFieldText", this.kerbConfManager.getDefaultUsernameFieldText());
        model.put("defaultNextButtonText", this.kerbConfManager.getDefaultNextButtonText());
        model.put("defaultIdpListTitleText", this.kerbConfManager.getDefaultIdpListTitleText());
        model.put("traditionalLoginDisabledMessage", this.kerbConfManager.getTraditionalLoginDisabledMessage());
        model.put("allTraditionalLoginDisabledMessage", this.kerbConfManager.getAllTraditionalLoginDisabledMessage());
        model.put("defaultTraditionalLoginDisabledMessage", this.kerbConfManager.getTraditionalLoginDisabledDefaultMessage());
        model.put("defaultAllTraditionalLoginDisabledMessage", this.kerbConfManager.getAllTraditionalLoginDisabledDefaultMessage());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/customizableTexts.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String errorMessage = req.getParameter("errorMessage");
        String samlLoginUsernamePlaceholder = req.getParameter("samlLoginUsernamePlaceholder");
        String usernameFieldText = req.getParameter("usernameFieldText");
        String nextButtonText = req.getParameter("nextButtonText");
        String idpListTitleText = req.getParameter("idpListTitleText");
        this.kerbConfManager.setErrorPageMessage(StringUtils.trim((String)errorMessage));
        this.kerbConfManager.setSamlLoginUsernamePlaceholder(StringUtils.trim((String)samlLoginUsernamePlaceholder));
        this.kerbConfManager.setUsernameFieldText(StringUtils.trim((String)usernameFieldText));
        this.kerbConfManager.setNextButtonText(StringUtils.trim((String)nextButtonText));
        this.kerbConfManager.setIdpListTitleText(StringUtils.trim((String)idpListTitleText));
        String traditionalLoginDisabledMessage = StringUtils.trim((String)req.getParameter("traditionalLoginDisabledMessage"));
        this.kerbConfManager.setTraditionalLoginDisabledMessage(StringUtils.isBlank((CharSequence)traditionalLoginDisabledMessage) ? this.kerbConfManager.getTraditionalLoginDisabledDefaultMessage() : traditionalLoginDisabledMessage);
        String allTraditionalLoginDisabledMessage = StringUtils.trim((String)req.getParameter("allTraditionalLoginDisabledMessage"));
        this.kerbConfManager.setAllTraditionalLoginDisabledMessage(StringUtils.isBlank((CharSequence)allTraditionalLoginDisabledMessage) ? this.kerbConfManager.getAllTraditionalLoginDisabledDefaultMessage() : allTraditionalLoginDisabledMessage);
        resp.sendRedirect("customizable-texts");
    }
}

