/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.update;

import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.List;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.update.KssoUpdateManager;
import org.kantega.atlaskerb.update.data.UpdateMessage;
import org.kantega.atlaskerb.update.data.UpdateResult;
import org.kantega.atlaskerb.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStatusServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(ConfigStatusServlet.class);
    private final TemplateRenderer renderer;
    private final KerbConfManager kerbConfManager;
    private final KssoUpdateManager kssoUpdateManager;

    @Inject
    public ConfigStatusServlet(RequireAdminServletDependencyBucket bucket, KssoUpdateManager kssoUpdateManager) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.kssoUpdateManager = kssoUpdateManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp, new HashMap<String, Object>());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean doUpdate = StringUtils.equals((CharSequence)"doUpdate", (CharSequence)req.getParameter("action"));
        boolean confirmVersionChange = StringUtils.equals((CharSequence)"confirmVersionChange", (CharSequence)req.getParameter("action"));
        HashMap<String, Object> additionalData = new HashMap<String, Object>();
        String savedVersion = (String)this.kerbConfManager.getSavedKssoConfigVersion().map(Version::stringValue).getOrNull();
        if (doUpdate) {
            try {
                List messages = List.ofAll(this.kssoUpdateManager.doUpdate());
                if (messages.forAll(UpdateMessage::isSuccess)) {
                    additionalData.put("runningKssoVersion", KerbConfManager.getRunningKssoVersion().map(Version::stringValue).getOrNull());
                    additionalData.put("updatedFrom", savedVersion);
                    List updateResults = messages.flatMap(UpdateMessage::getUpdateResults).distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageUrl(), (CharSequence)b.getConfigPageUrl()) ? 0 : 1);
                    additionalData.put("updateSuccessResults", updateResults.toJavaList());
                } else if (messages.exists(msg -> msg.getResultCode() == KssoUpdateManager.ResultCode.VERSION_CHANGE_FAILURE)) {
                    additionalData.put("versionChangeFailure", true);
                } else {
                    List updateResults = messages.filter(UpdateMessage::isFailure).flatMap(message -> message.getUpdateResults().filter(UpdateResult::isFailure)).distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageName(), (CharSequence)b.getConfigPageName()) ? 0 : 1);
                    additionalData.put("updateFailedResults", updateResults.toJavaList());
                    additionalData.put("updateFailed", updateResults.size() > 0);
                    additionalData.put("messagesWithPageUri", messages.filter(UpdateMessage::isFailure).filter(updateMessage -> StringUtils.isNotBlank((CharSequence)updateMessage.getConfigPageUri())));
                }
                additionalData.put("updateMessage", messages.map(UpdateMessage::getMessage).intersperse((Object)", ").foldLeft((Object)"", String::concat));
            }
            catch (Exception e) {
                log.error("Encountered an unexpected error during update of Kantega SSO Configuration:", (Throwable)e);
                throw new RuntimeException("Encountered an unexpected error during update of Kantega SSO Configuration. Please re-try and contact support if the issue persists.", e);
            }
        }
        if (confirmVersionChange) {
            try {
                this.kerbConfManager.updateKssoVersionInConfig();
            }
            catch (Exception e) {
                additionalData.put("persistentVersionError", true);
            }
        }
        this.buildModelAndRenderTemplate(req, resp, additionalData);
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalData) throws IOException {
        boolean writable = Files.isWritable(this.applicationProperties.getHomeDirectory().toPath());
        Map<String, Object> model = this.newModel(req);
        boolean isKssoUpdateNeeded = this.kssoUpdateManager.isKssoConfigUpdateNeeded();
        model.putAll(additionalData);
        model.putIfAbsent("updateOk", !isKssoUpdateNeeded && !this.kssoUpdateManager.hasUpdateFailures());
        model.putIfAbsent("needsUpdateOrUpdateFailed", isKssoUpdateNeeded || this.kssoUpdateManager.hasUpdateFailures());
        model.putIfAbsent("updateFailedResults", this.kssoUpdateManager.getUpdateFailures().distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageName(), (CharSequence)b.getConfigPageName()) ? 0 : 1).asJava());
        model.putIfAbsent("updateFailed", this.kssoUpdateManager.hasUpdateFailures());
        List messagesWithPageUri = this.kssoUpdateManager.getUpdateFailures().distinctBy((a, b) -> StringUtils.equals((CharSequence)a.getConfigPageName(), (CharSequence)b.getConfigPageName()) ? 0 : 1);
        model.put("menuItem", "configStatus");
        model.put("isWritable", writable);
        model.put("path", this.kerbConfManager.getHomeDirectoryResolver().getHomeDirectory().toPath());
        model.put("topMenu", "dashboard");
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/config-status.vm", model, (Writer)resp.getWriter());
    }
}

