/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.jaas;

import java.io.File;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class JaasConfig
extends Configuration {
    public static final String JAAS_CFG_NAME = "atlaskerb";
    private final AppConfigurationEntry[] entries;

    public JaasConfig(File keytabFile, String servicePrincipalName) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("useKeyTab", "true");
        options.put("storeKey", "true");
        options.put("isInitiator", "false");
        options.put("keyTab", keytabFile.getAbsolutePath());
        options.put("principal", servicePrincipalName);
        AppConfigurationEntry entry = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        this.entries = new AppConfigurationEntry[]{entry};
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        if (!name.equalsIgnoreCase(JAAS_CFG_NAME)) {
            throw new RuntimeException("invalid JAAS config " + name);
        }
        return this.entries;
    }
}

