/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import com.kantegasso.runtimetrust.FingerprintSSLSocketFactory;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.kantega.atlaskerb.saml.MetadataParser;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

public class SamlMetadataParserWrapper {
    private final List<byte[]> signingCerts;
    private final String idpLocation;
    private final String singleLogoutServiceUrl;
    private final boolean isUsePostBinding;

    private SamlMetadataParserWrapper(List<byte[]> signingCerts, String idpLocation, String singleLogoutServiceUrl, boolean isUsePostBinding) {
        this.signingCerts = signingCerts;
        this.idpLocation = idpLocation;
        this.singleLogoutServiceUrl = singleLogoutServiceUrl;
        this.isUsePostBinding = isUsePostBinding;
    }

    static Try<SamlMetadataParserWrapper> fromUrl(String metadataUrl) {
        return SamlMetadataParserWrapper.fromUrl(metadataUrl, "");
    }

    static Try<SamlMetadataParserWrapper> fromUrl(String metadataUrl, String tlsFingerprint) {
        return Try.of((CheckedFunction0 & Serializable)() -> metadataUrl).mapTry(URL::new).mapTry(URL::openConnection).peek(urlConnection -> urlConnection.setConnectTimeout(10000)).peek(urlConnection -> urlConnection.setReadTimeout(30000)).peek(urlConnection -> {
            if (urlConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory((SSLSocketFactory)new FingerprintSSLSocketFactory(tlsFingerprint));
            }
        }).mapTry(URLConnection::getInputStream).flatMap(SamlMetadataParserWrapper::parseMetadata);
    }

    static Try<SamlMetadataParserWrapper> fromPaste(String paste) {
        return Try.of((CheckedFunction0 & Serializable)() -> paste).map(String::getBytes).map(ByteArrayInputStream::new).flatMap(SamlMetadataParserWrapper::parseMetadata);
    }

    private static Try<SamlMetadataParserWrapper> parseMetadata(InputStream metadataInputStream) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            MetadataParser metadataParser = new MetadataParser();
            EntityDescriptor entityDescriptor = metadataParser.parse(metadataInputStream);
            IDPSSODescriptor idpSsoDescriptor = metadataParser.getIDPDescriptorForSaml(entityDescriptor);
            List<byte[]> signingCerts = metadataParser.getSigningCerts(idpSsoDescriptor);
            MetadataParser.IdpSsoLocation idpSsoLocation = metadataParser.getIdpSsoLocation(idpSsoDescriptor);
            String idpSingleLogoutServiceURL = metadataParser.getIdpSingleLogoutServiceURL(idpSsoDescriptor);
            return new SamlMetadataParserWrapper(signingCerts, idpSsoLocation.getLocation(), idpSingleLogoutServiceURL, idpSsoLocation.usePostBinding());
        });
    }

    public List<byte[]> getSigningCerts() {
        return this.signingCerts;
    }

    public String getIdpLocation() {
        return this.idpLocation;
    }

    public String getSingleLogoutServiceUrl() {
        return this.singleLogoutServiceUrl;
    }

    public boolean isUsePostBinding() {
        return this.isUsePostBinding;
    }
}

