/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.setup;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.setup.IdpValidationError;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.login.RedirectProperties;

abstract class IdpValidator {
    IdpValidator() {
    }

    Validation<IdpValidationError, String> validateIdpId(String id) {
        return (Validation)Option.of((Object)id).filter(IdpConfManager::isValidIdpId).transform(maybeId -> maybeId.isDefined() ? Validation.valid((Object)maybeId.get()) : Validation.invalid((Object)((Object)IdpValidationError.IDP_ID)));
    }

    Validation<IdpValidationError, IdpConfiguration.Kind> validateKind(String kind) {
        return (Validation)Try.of((CheckedFunction0 & Serializable)() -> IdpConfiguration.Kind.valueOf(kind)).transform(tryKind -> tryKind.isSuccess() ? Validation.valid((Object)tryKind.get()) : Validation.invalid((Object)((Object)IdpValidationError.KIND)));
    }

    Validation<IdpValidationError, RedirectProperties> validateRedirectPolicy(String redirectPolicy) {
        return (Validation)Try.of((CheckedFunction0 & Serializable)() -> IdpConfiguration.RedirectPolicy.valueOf(redirectPolicy)).mapTry((CheckedFunction1 & Serializable)redirectPolicy1 -> new RedirectProperties((IdpConfiguration.RedirectPolicy)((Object)((Object)redirectPolicy1)), Collections.emptySet(), true, false, true, false, Collections.emptySet(), IdpConfiguration.MatchingPolicy.IN, IdpConfiguration.MatchingPolicy.IN)).transform(redirectPolicyTry -> redirectPolicyTry.isSuccess() ? Validation.valid((Object)redirectPolicyTry.get()) : Validation.invalid((Object)((Object)IdpValidationError.REDIRECT_POLICY)));
    }

    Validation<IdpValidationError, String> validateName(String name) {
        return (Validation)Option.of((Object)name).map(StringUtils::trim).filter(StringUtils::isNotBlank).transform(xxx -> xxx.isDefined() ? Validation.valid((Object)xxx.get()) : Validation.invalid((Object)((Object)IdpValidationError.DISPLAY_NAME)));
    }
}

