/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class DateTool {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());

    public String formatInstant(Instant instant) {
        try {
            return dtf.format(instant);
        }
        catch (DateTimeException e) {
            return "N/A";
        }
    }

    public String formatDateFull(Date date) {
        try {
            return dtf.format(date.toInstant());
        }
        catch (DateTimeException e) {
            return "N/A";
        }
    }

    public String formatDate(long date) {
        return this.formatDate(new Date(date));
    }

    public String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public String formatTime(long date) {
        return this.formatTime(new Date(date));
    }

    public String formatTime(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public boolean moreMinutesSince(int minutes, Date date) {
        return System.currentTimeMillis() - date.getTime() > (long)minutes * 1000L * 60L;
    }

    public String formatSince(Date date) {
        return this.formatSince(date.getTime());
    }

    public String formatSince(long time) {
        long l = System.currentTimeMillis() - time;
        return this.formatDuration(l) + " ago";
    }

    public String formatSince(Instant instant) {
        Duration duration = Duration.between(instant, Instant.now());
        return this.formatDuration(duration.toMillis());
    }

    public String formatShortDurationNanos(long duration) {
        long millis = TimeUnit.NANOSECONDS.toMillis(duration);
        if (millis < 10000L) {
            return millis + "ms";
        }
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration);
        long remainder = TimeUnit.NANOSECONDS.toMillis(duration - TimeUnit.SECONDS.toNanos(seconds));
        return String.format("%ds %dms", seconds, remainder);
    }

    public String formatDurationSeconds(long seconds) {
        return this.formatDuration(seconds * 1000L);
    }

    @NotNull
    public String formatDuration(long l) {
        String time;
        long number;
        StringBuilder sb = new StringBuilder();
        if (l >= 86400000L) {
            number = l / 86400000L;
            time = "day";
        } else if (l > 3600000L) {
            number = l / 3600000L;
            time = "hour";
        } else if (l > 60000L) {
            number = l / 60000L;
            time = "minute";
        } else {
            number = l / 1000L;
            time = "second";
        }
        sb.append(number).append(" ").append(time);
        if (number != 1L) {
            sb.append("s");
        }
        return sb.toString();
    }
}

