/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

public class IdpCommonRedirectSettingsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public IdpCommonRedirectSettingsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "SAML");
        model.put("menuItem", "idp-common-redirect-settings");
        model.put("shouldHideUsernameField", this.kerbConfManager.shouldHideUsernameField());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/idp-common-redirect-settings.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String shouldHideUsernameField = req.getParameter("shouldHideUsernameField");
        this.kerbConfManager.setShouldHideUsernameField(StringUtils.equals((CharSequence)shouldHideUsernameField, (CharSequence)"on"));
        IdpCommonRedirectSettingsAction.sendSuccess(resp);
    }

    private static void sendSuccess(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.getWriter().print("<html>Settings was saved</html>");
    }
}

