/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.kantegasso.oidc.OidcData;
import com.kantegasso.oidc.Workaround;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataCache;
import org.kantega.atlaskerb.identityproviders.oidc.OidcDataWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OidcLibWrapper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiateOidcLogin {
    private static final Logger log = LoggerFactory.getLogger(InitiateOidcLogin.class);

    public static OidcLoginResult run(OidcIdpConfiguration idpConfig, IdpConfManager idpConfManager, String callbackUrl, String loginHint, String domainHint, OidcDataCache cache, String targetUrl, OidcLibWrapper oidcLibWrapper, boolean isTest) {
        List scope = (List)Option.of(idpConfig.getScope()).map(List::ofAll).getOrElse((Object)List.empty());
        HashMap mfaParams = (HashMap)Option.of((Object)idpConfig).filter(IdpConfiguration::mfaSupported).filter(IdpConfiguration::mfaRequired).map(OidcIdpConfiguration::getOidcLibRepresentation).flatMap(Workaround::option).map(wa -> Tuple.of((Object)"require_amr", (Object)wa.getMfaAmrValue())).map(xva$0 -> HashMap.ofEntries((Tuple2[])new Tuple2[]{xva$0})).getOrElse(HashMap::empty);
        Either maybeOidcData = oidcLibWrapper.createOidcData((HashMap<String, Object>)HashMap.narrow((HashMap)HashMap.ofEntries((Tuple2[])new Tuple2[]{Tuple.of((Object)"client_id", (Object)idpConfig.getClientId()), Tuple.of((Object)"client_secret", (Object)idpConfig.getClientSecret()), Tuple.of((Object)"discovery_url", (Object)idpConfig.getDiscoveryUrl()), Tuple.of((Object)"redirect_uri", (Object)callbackUrl), Tuple.of((Object)"workaround", (Object)idpConfig.getOidcLibRepresentation()), Tuple.of((Object)"login_hint", (Object)loginHint), Tuple.of((Object)"domain_hint", (Object)domainHint), Tuple.of((Object)"issuer_allowlist", (Object)idpConfig.getIssuerAllowList()), Tuple.of((Object)"ksso:is_test", (Object)isTest)}).merge((Map)mfaParams))).peek(oidcData -> Option.of((Object)oidcData).filter(TestUtils::isTest).peek(oidcData1 -> idpConfManager.recordOidcTestStarted(idpConfig.getId(), targetUrl, (OidcData)oidcData1))).peekLeft(errorMessage -> log.error(ErrorUtils.createErrorMessage("KSSO-8S2JI6BDXO", "Error initiating OIDC login. Error message creating OIDC config: " + errorMessage)));
        Either maybeOidcDataWithAuthUrl = maybeOidcData.flatMap(oidcData -> oidcData.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? oidcLibWrapper.discover((OidcData)oidcData) : Either.right((Object)oidcData)).peekLeft(leftMessage -> log.error(ErrorUtils.createErrorMessage("KSSO-1GNF5BZ2F9", "Error initiating OIDC login trying to do discovery: " + leftMessage))).flatMap(oidcData -> oidcLibWrapper.authentication((OidcData)oidcData, (List<String>)scope)).peekLeft(leftMessage -> {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-0B21TH9KN4", "Error initiating OIDC login trying to do OIDC authentication: " + leftMessage);
            log.error(kssoError.asMessage());
            maybeOidcData.filter(TestUtils::isTest).peek(oidcTestData -> TestUtils.recordTestFailedBeforeRequest(idpConfig, idpConfManager, (Either<String, OidcData>)oidcTestData, kssoError, ResponseEvaluationCode.FAILED_OIDC_INITIATE_LOGIN).onFailure(InitiateOidcLogin::logTestRecordingError));
        }).peek(oidcDataWithAuthUrl -> cache.put(new OidcDataWrapper((OidcData)oidcDataWithAuthUrl, idpConfig.getId(), targetUrl, isTest)).onFailure(throwable -> log.error(ErrorUtils.createKssoError("KSSO-8P1Y6WQJ3E", "Failed to save OIDC state cache: " + throwable.getMessage()).asMessage(), throwable)).andThenTry(() -> Option.of((Object)oidcDataWithAuthUrl).filter(TestUtils::isTest).peek(oidcData -> TestUtils.recordTestProcedureBeforeRequest(idpConfig, idpConfManager, oidcDataWithAuthUrl, ResponseEvaluationCode.WAITING_FOR_RESPONSE).onFailure(InitiateOidcLogin::logTestRecordingError))));
        String state = (String)maybeOidcDataWithAuthUrl.toOption().flatMap(oidcData -> oidcData.get("state")).getOrElse((Object)"");
        String authorizationUrl = (String)maybeOidcDataWithAuthUrl.toOption().flatMap(OidcData::getAuthorizationUrl).getOrElse((Object)"");
        Option error = Try.of(() -> ((Either)maybeOidcDataWithAuthUrl).getLeft()).toOption();
        return new OidcLoginResult(authorizationUrl, state, (Option<String>)error);
    }

    private static void logTestRecordingError(Throwable error) {
        log.warn(ErrorUtils.createErrorMessage("KSSO-F8CMRH6DG1", "Error recording test result: " + error.getMessage()));
    }

    public static class OidcLoginResult {
        private final String authorizationUrl;
        private final String state;
        private final Option<String> error;

        public OidcLoginResult(String authorizationUrl, String state, Option<String> error) {
            this.state = state;
            this.authorizationUrl = authorizationUrl;
            this.error = error;
        }

        public String getState() {
            return this.state;
        }

        public String getAuthorizationUrl() {
            return this.authorizationUrl;
        }

        public boolean isSuccess() {
            return this.error.isEmpty();
        }

        public String getError() {
            return (String)this.error.getOrElse((Object)"");
        }
    }
}

