/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import io.vavr.API;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.oidc.OidcIdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlIdpConfiguration;
import org.springframework.stereotype.Component;

@Component
public class EnforceIdpMfaServlet
extends RequireAdminServlet {
    @Inject
    public EnforceIdpMfaServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        this.templateRenderer.render("templates/saml/idp-mfa.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean isMfaRequired = this.getSafeParameter("mfaRequired", req).filter(val -> val.equals("on")).isDefined();
        String mfaAttribute = (String)this.getSafeParameter("mfaAttribute", req).getOrElse((Object)"");
        Option.of((Object)IdpConfManager.IdpServletUtil.getId(req)).map(this.idpConfManager::getIdentityProviderById).peek(idp -> API.Match((Object)idp).option(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(IdpConfiguration::isOidc), () -> (OidcIdpConfiguration)((IdpConfigurationBuilder.Oidc)((IdpConfigurationBuilder.Oidc)IdpConfigurationBuilder.Oidc.of((OidcIdpConfiguration)idp).setMfaRequired(isMfaRequired)).setMfaAttribute(mfaAttribute)).build()), API.Case((API.Match.Pattern0)API.$(IdpConfiguration::isSaml), () -> (SamlIdpConfiguration)((IdpConfigurationBuilder.Saml)((IdpConfigurationBuilder.Saml)IdpConfigurationBuilder.Saml.of((SamlIdpConfiguration)idp).setMfaRequired(isMfaRequired)).setMfaAttribute(mfaAttribute)).build())}).peek(this.idpConfManager::updateIdpConfiguration));
        resp.sendRedirect("mfa");
    }

    @Override
    protected Map<String, Object> newModel(HttpServletRequest req) {
        Map<String, Object> model = super.newModel(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(IdpConfManager.IdpServletUtil.getId(req));
        model.put("idp", configuration);
        model.put("topMenu", "SAML");
        model.put("menuItem", "mfa");
        return model;
    }
}

