/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim;

import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.ksso.scim.ScimLib;
import com.ksso.scim.ScimProviderKind;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.atlassian.AtlScimServerSpi;
import com.ksso.scim.atlassian.ScimProvisioningEvents;
import com.ksso.scim.atlassian.auth.BasicAuthCredentials;
import com.ksso.scim.atlassian.auth.BearerTokenCredentials;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.NoCredentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import com.ksso.scim.atlassian.hostapp.DefaultScimHostApp;
import com.ksso.scim.atlassian.hostapp.ScimHostApp;
import com.ksso.scim.atlassian.repository.AtlassianUserRepository;
import com.ksso.scim.event.ScimEventListener;
import com.ksso.scim.spi.ScimServerSpi;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.scim.ScimTenantConfig;
import org.kantega.atlaskerb.security.XmlSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Component
public class ScimConfManager
implements DebugInfo {
    private static final Logger log = LoggerFactory.getLogger(ScimConfManager.class);
    private static final String PASSWORD_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String SCIM_CONFIG_ELEMENT = "scim-config";
    private static final String KIND_ATTR = "kind";
    private static final String NAME_ATTR = "name";
    private static final String CREDENTIALS_ATTR = "scim-credentials";
    private static final String AUTH_METHOD_ATTR = "auth-method";
    private static final String USE_CACHE_FILE = "use-cache-file";
    @Deprecated
    private static final String APPLICATION_SECRET_ATTR = "application-secret";
    @Deprecated
    private static final String AUTHENTICATE_BEARER_TOKEN_ENABLED_ATTR = "authenticate-bearer-boken-enabled";
    private final ApplicationProperties applicationProperties;
    private final ApiServerConfManager apiServerConfManager;
    private final HostApp hostApp;
    private final PluginSettings settings;
    private final TransactionTemplate txTemplate;
    private final ScimHostApp scimHostApp;
    private AtomicReference<ScimConfigState> state = new AtomicReference();
    private ScimProvisioningEvents eventList;
    private final SecureRandom secureRandom;
    private final CacheManager cacheManager;

    @Inject
    public ScimConfManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport TransactionTemplate txTemplate, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport CacheManager cacheManager, ApiServerConfManager apiServerConfManager, HostAppFactory hostAppFactory, ScimHostApp scimHostApp) {
        this.applicationProperties = applicationProperties;
        this.cacheManager = cacheManager;
        this.apiServerConfManager = apiServerConfManager;
        this.hostApp = hostAppFactory.getInstance();
        this.settings = pluginSettingsFactory.createGlobalSettings();
        this.txTemplate = txTemplate;
        this.scimHostApp = scimHostApp;
        this.eventList = new ScimProvisioningEvents();
        ScimLib.registerListener((ScimEventListener)this.eventList);
        try {
            this.readState();
            this.fixOldDirectoryPermissions();
        }
        catch (Exception e) {
            log.warn("Unexpected error: Invalid SCIM configuration", (Throwable)e);
        }
        this.secureRandom = new SecureRandom();
    }

    public boolean isScimEnabled() {
        return !this.hostApp.isProductMatch("fecru") && !this.hostApp.isProductMatch("bamboo");
    }

    public boolean isScimBaseUrlEndpointEnabled() {
        return !StringUtils.equals((CharSequence)"false", (CharSequence)((String)this.settings.get(KEYS.SCIM_BASE_URL_SERVLET_ENABLED.key)));
    }

    public void setscimBaseUrlEndpointEnabled(boolean value) {
        this.settings.put(KEYS.SCIM_BASE_URL_SERVLET_ENABLED.key, (Object)String.valueOf(value));
    }

    public Option<ScimServerSpi> getScimServerSpi(String tenantId) {
        return this.currentState().getSpi(tenantId);
    }

    public Option<ScimDirectory> getScimDirectoryByInternalId(long internalIdent) {
        return this.currentState().getScimDirectories().find(dir -> dir.getDirectoryId() == internalIdent);
    }

    public String getApiServerEndpoint(String tenantId, ScimVersion version) {
        return this.apiServerConfManager.getServerUrl() + "/scim/" + tenantId + "/" + version.pathValue();
    }

    public String getBaseUrlEndpoint(String tenantId, ScimVersion version) {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + "/plugins/servlet/ksso/scim/" + tenantId + "/" + version.pathValue();
    }

    public Option<ScimDirectory> getScimDirectory(String tenantId) {
        return this.currentState().getScimDirectories().find(dir -> StringUtils.equals((CharSequence)dir.getConfig().getTenantId(), (CharSequence)tenantId));
    }

    public List<Directory> findStaleInternalDirectories() {
        List configTenantIds = this.getTenantConfigs().map(cfg -> cfg.getTenantId());
        return this.scimHostApp.findScimDirectories().filterKeys(tenantId -> !configTenantIds.contains(tenantId)).toList().map(tuple -> (Directory)tuple._2);
    }

    private void fixOldDirectoryPermissions() {
        List oldDirectories = this.scimHostApp.findScimDirectories().map(t -> (Directory)t._2).filter(directory -> !directory.getAllowedOperations().containsAll(DefaultScimHostApp.ALL_OPS)).toList();
        if (!oldDirectories.isEmpty()) {
            log.info("Resetting allowed operations for SCIM directories: {}", (Object)oldDirectories.map(dir -> dir.getName()).mkString((CharSequence)","));
        }
        oldDirectories.forEach(directory -> Try.of((CheckedFunction0 & Serializable)() -> this.scimHostApp.resetAllowedOperations(directory)).onFailure(t -> log.error("Directory permission reset failed", t.getCause())));
    }

    public List<ScimTenantConfig> findStaleTenantConfigs() {
        Set directoryTenantIds = this.scimHostApp.findScimDirectories().keySet();
        return this.getTenantConfigs().filter(config -> !directoryTenantIds.contains((Object)config.getTenantId()));
    }

    public List<ScimDirectory> getScimDirectories() {
        return this.currentState().getScimDirectories();
    }

    public List<ScimTenantConfig> getTenantConfigs() {
        return this.currentState().getTenantConfigs();
    }

    ScimConfigState currentState() {
        String currentStateId;
        ScimConfigState cachedState = this.state.get();
        if (!cachedState.isCurrent(currentStateId = this.currentStateId())) {
            ScimConfigState nextState = this.readState(currentStateId);
            if (this.state.compareAndSet(cachedState, nextState)) {
                return nextState;
            }
            return this.state.get();
        }
        return cachedState;
    }

    private String currentStateId() {
        return (String)this.settings.get(KEYS.SCIM_DIRECTORY_STATE_ID.key);
    }

    private void updateStateId() {
        String nextId = UUID.randomUUID().toString();
        this.settings.put(KEYS.SCIM_DIRECTORY_STATE_ID.key, (Object)nextId);
    }

    private ScimConfigState readState(String stateId) {
        List<ScimTenantConfig> tenantConfigs = this.readTenantConfigs();
        io.vavr.collection.Map scimDirectories = this.scimHostApp.findScimDirectories();
        return new ScimConfigState(stateId, tenantConfigs, (io.vavr.collection.Map<String, Directory>)scimDirectories);
    }

    private List<ScimTenantConfig> readTenantConfigs() {
        File configDir = this.getConfigHomeDir();
        if (!configDir.exists()) {
            return List.empty();
        }
        return ((List)Option.of((Object)configDir.listFiles(file -> file.getName().endsWith(".xml"))).map(List::of).getOrElse((Object)List.empty())).map(this::parseTenantConfig);
    }

    private File getTenantCacheFile(String tenantId) {
        File configDir = this.getConfigHomeDir();
        if (!configDir.exists()) {
            return null;
        }
        return new File(configDir + File.separator + tenantId + "-cache.json");
    }

    private ScimTenantConfig parseTenantConfig(File xmlFile) {
        try {
            Document document = XmlSecurity.secureDocumentBuilder().parse(xmlFile);
            Element element = document.getDocumentElement();
            ScimProviderKind kind = ScimProviderKind.valueOf((String)element.getAttribute(KIND_ATTR));
            String credentialsSaved = (String)Option.of((Object)element.getAttribute(CREDENTIALS_ATTR)).filter(StringUtils::isNotEmpty).getOrElse((Object)element.getAttribute(APPLICATION_SECRET_ATTR));
            boolean authenticateBearerTokenEnabled = (Boolean)Option.of((Object)element.getAttribute(AUTHENTICATE_BEARER_TOKEN_ENABLED_ATTR)).filter(StringUtils::isNotEmpty).map(Boolean::valueOf).getOrElse((Object)true);
            boolean useCacheFile = (Boolean)Option.of((Object)element.getAttribute(USE_CACHE_FILE)).filter(StringUtils::isNotEmpty).map(Boolean::valueOf).getOrElse((Object)false);
            ScimAuthMethod authMethod = (ScimAuthMethod)Try.of((CheckedFunction0 & Serializable)() -> ScimAuthMethod.valueOf((String)element.getAttribute(AUTH_METHOD_ATTR))).getOrElse((Object)(authenticateBearerTokenEnabled ? ScimAuthMethod.BEARER : ScimAuthMethod.NONE));
            String directoryName = element.getAttribute(NAME_ATTR);
            String tenantId = StringUtils.substringBefore((String)xmlFile.getName(), (String)".xml");
            Object credentials = authMethod == ScimAuthMethod.BEARER ? BearerTokenCredentials.fromConfig((String)credentialsSaved) : (authMethod == ScimAuthMethod.BASIC ? BasicAuthCredentials.fromConfig((String)credentialsSaved) : NoCredentials.fromConfig((String)credentialsSaved));
            return new ScimTenantConfig(tenantId, directoryName, (Credentials)credentials, authMethod, kind, useCacheFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void readState() {
        ScimConfigState state = this.readState(this.currentStateId());
        this.state.set(state);
        List tenantIds = state.getScimDirectories().map(d -> d.getTenantId());
        this.eventList.pruneTenants(tenantIds);
        this.readUsersIntoCache(state);
    }

    private void readUsersIntoCache(ScimConfigState state) {
        log.debug("readAllUsersIntoCache triggering.");
        Runnable runnable = () -> {
            log.debug("readAllUsersIntoCache for SCIM dir.");
            for (String tenantId : state.spiMap.keySet()) {
                ScimServerSpi spi = (ScimServerSpi)state.spiMap.get((Object)tenantId).getOrElseThrow(() -> new RuntimeException("Unable to get spi for given tenantId"));
                ScimTenantConfig config = (ScimTenantConfig)this.getTenantConfigs().find(c -> c.getTenantId().equals(tenantId)).get();
                spi.readAllUsersIntoCache(true, config.isUseCacheFile());
            }
            log.debug("readAllUsersIntoCache for SCIM dir finished.");
        };
        new Thread(runnable).start();
        log.debug("readAllUsersIntoCache triggered.");
    }

    public void considerCacheFileWrite() {
        for (String tenantId : this.state.get().spiMap.keySet()) {
            ScimServerSpi spi = (ScimServerSpi)this.state.get().spiMap.get((Object)tenantId).getOrElseThrow(() -> new RuntimeException("Unable to get spi for given tenantId"));
            ScimTenantConfig config = (ScimTenantConfig)this.getTenantConfigs().find(c -> c.getTenantId().equals(tenantId)).get();
            if (!config.isUseCacheFile()) continue;
            spi.considerCacheFileWrite();
        }
    }

    private File getTenantConfigFile(File configHomeDir, String tenantId) {
        return new File(configHomeDir, tenantId + ".xml");
    }

    private File getConfigHomeDir() {
        return new File(this.hostApp.getHomeDirectory(), "scim");
    }

    public void restoreScimDirectory(String name, Map<String, String> attrs) {
        this.scimHostApp.restoreDirectory(name, attrs);
    }

    public void saveOrUpdate(ScimTenantConfig config) {
        this.persistScimTenantConfig(config);
        Option maybeDirectory = this.scimHostApp.findDirectoryByTenantId(config.getTenantId());
        String directoryName = "SCIM: " + config.getTenantName();
        if (maybeDirectory.isDefined()) {
            Directory directory = (Directory)maybeDirectory.get();
            this.scimHostApp.setDirectoryName(directory, directoryName);
        } else {
            this.scimHostApp.addDirectory(config.getTenantId(), directoryName, config.getKind());
        }
    }

    private void persistScimTenantConfig(ScimTenantConfig config) {
        File xmlFile = this.getTenantConfigFile(this.getConfigHomeDir(), config.getTenantId());
        xmlFile.getParentFile().mkdirs();
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(SCIM_CONFIG_ELEMENT);
            element.setAttribute(KIND_ATTR, config.getKind().name());
            Credentials credentials = config.getCredentials();
            element.setAttribute(CREDENTIALS_ATTR, credentials.toConfig());
            element.setAttribute(NAME_ATTR, config.getTenantName());
            element.setAttribute(AUTH_METHOD_ATTR, credentials.getAuthMethod().toString());
            element.setAttribute(USE_CACHE_FILE, Boolean.toString(config.isUseCacheFile()));
            document.appendChild(element);
            this.persistDocument(xmlFile, document);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void persistDocument(File file, Document document) {
        try {
            File tempFile = new File(file.getParentFile(), "_" + file.getName());
            Transformer transformer = XmlSecurity.secureTransformer();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(tempFile);
                transformer.transform(new DOMSource(document), new StreamResult(out));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.renameFile(tempFile, file);
            this.updateStateId();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void renameFile(File sourceFile, File destFile) {
        try {
            Files.move(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPluginAdminBase(HttpServletRequest request) {
        return request.getContextPath() + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin";
    }

    public String getSCIMConfigUrl(HttpServletRequest request) {
        return this.getPluginAdminBase(request) + "/scim/";
    }

    public void deleteScimDirectoryAndTenantConfig(String tenantId) {
        File file = this.getTenantConfigFile(this.getConfigHomeDir(), tenantId);
        try {
            FileUtils.forceDelete((File)file);
            this.updateStateId();
            this.scimHostApp.removeDirectoryByTenantId(tenantId);
            FileUtils.forceDelete((File)new File(this.getTenantCacheFile(tenantId).getAbsolutePath() + ".zip"));
            ScimServerSpi spi = (ScimServerSpi)this.state.get().spiMap.get((Object)tenantId).getOrElseThrow(() -> new RuntimeException("Unable to get spi for given tenantId"));
            spi.clearUserAttributeCache();
        }
        catch (FileNotFoundException e) {
            log.info("Could not delete SCIM config file for tenant {}. Reason: {}", (Object)tenantId, (Object)e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteInternalDirectory(long directoryId) {
        this.scimHostApp.removeDirectoryById(directoryId);
    }

    public List<ScimProvisioningEvents.Item> getProvisioningEvents(String tenantId) {
        return this.eventList.getEvents(tenantId);
    }

    public void clearProvisioningEvents(String tenantId) {
        this.eventList.clear(tenantId);
    }

    public String nextId() {
        return Long.toString(this.secureRandom.nextLong() % Long.MAX_VALUE, 36);
    }

    public String nextPassword() {
        StringBuilder password = this.secureRandom.ints(50L, 0, PASSWORD_CHARS.length()).mapToObj(PASSWORD_CHARS::charAt).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append);
        return password.toString();
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("isScimEnabled", this.isScimEnabled());
        json.put("isScimBaseUrlEndpointEnabled", this.isScimBaseUrlEndpointEnabled());
        json.put("scimTenantConfigs", (Collection)this.getTenantConfigs().map(DebugInfo::asJson).toJavaList());
        return json;
    }

    public Map<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys : KEYS.values()) {
            Object value = this.settings.get(keys.key);
            if (!(value instanceof String)) continue;
            result.put(keys.key, (String)value);
        }
        return result;
    }

    public void restoreSettings(Properties props) {
        for (KEYS keys : KEYS.values()) {
            this.settings.remove(keys.key);
        }
        for (KEYS keys : KEYS.values()) {
            String value = props.getProperty(keys.key);
            if (value == null) continue;
            this.settings.put(keys.key, (Object)value);
        }
        this.updateStateId();
        this.currentState();
    }

    public io.vavr.collection.Map<String, Directory> findScimDirectories() {
        return this.scimHostApp.findScimDirectories();
    }

    private class ScimConfigState {
        private final String stateId;
        private final List<ScimTenantConfig> tenantConfigs;
        private final List<ScimDirectory> scimDirectories;
        private final io.vavr.collection.Map<String, ScimServerSpi> spiMap;

        public ScimConfigState(String stateId, List<ScimTenantConfig> tenantConfigs, io.vavr.collection.Map<String, Directory> internalDirectories) {
            this.stateId = stateId;
            this.tenantConfigs = tenantConfigs;
            this.scimDirectories = tenantConfigs.map(cfg -> internalDirectories.get((Object)cfg.getTenantId()).map(dir -> new ScimDirectory((Directory)dir, (ScimTenantConfig)cfg))).flatMap(Function.identity());
            this.spiMap = this.scimDirectories.map(dir -> Tuple.of((Object)dir.getConfig(), (Object)new AtlassianUserRepository(ScimConfManager.this.txTemplate, dir.getDirectory(), ScimConfManager.this.scimHostApp, dir.getTenantId(), ScimConfManager.this.cacheManager, ScimConfManager.this.getTenantCacheFile(dir.getTenantId()))).map2(repository -> new AtlScimServerSpi(repository, dir.getConfig().getCredentials()))).toMap(tup -> ((ScimTenantConfig)tup._1).getTenantId(), tup -> (AtlScimServerSpi)tup._2);
        }

        public Option<ScimServerSpi> getSpi(String tenantId) {
            return this.spiMap.get((Object)tenantId);
        }

        public boolean isCurrent(String stateId) {
            if (stateId == null) {
                return this.stateId == null;
            }
            return stateId.equals(this.stateId);
        }

        public List<ScimDirectory> getScimDirectories() {
            return this.scimDirectories;
        }

        public List<ScimTenantConfig> getTenantConfigs() {
            return this.tenantConfigs;
        }
    }

    static enum KEYS {
        SCIM_DIRECTORY_STATE_ID("no.kantega.scimDirectoryStateId"),
        SCIM_BASE_URL_SERVLET_ENABLED("no.kantega.scimServlet.enabled");

        final String key;

        private KEYS(String key) {
            this.key = key;
        }
    }
}

