/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.DomainDirectory;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.LdapPrincipalSearcher;
import org.kantega.atlaskerb.LdapTestResult;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.kerberos.AtlDirectoryManager;
import org.kantega.atlaskerb.kerberos.keytab.EncryptionType;
import org.kantega.atlaskerb.kerberos.keytab.KeytabEntry;
import org.kantega.atlaskerb.kerberos.keytab.KeytabReader;
import org.kantega.atlaskerb.kerberos.keytab.PrincipalName;
import org.kantega.atlaskerb.kerberos.servlet.SetupAction;
import org.kantega.atlaskerb.kerberos.servlet.TestKerberosAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchKeysAction
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(FetchKeysAction.class);
    private final LdapPrincipalSearcher ldapPrincipalSearcher;
    private final AtlDirectoryManager directoryManager;
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public FetchKeysAction(RequireAdminServletDependencyBucket bucket, LdapPrincipalSearcher ldapPrincipalSearcher, AtlDirectoryManager directoryManager) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.ldapPrincipalSearcher = ldapPrincipalSearcher;
        this.directoryManager = directoryManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.render(req, resp, model);
    }

    private void render(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("userDirectories", FetchKeysAction.guessServiceAccounts(req, this.directoryManager, this.newModel(req), this.ldapPrincipalSearcher, this.directoryManager.getActiveMsAdDirectories()));
        TestKerberosAction.checkDns(model, req);
        String aRecord = (String)model.get("aRecord");
        if (aRecord != null) {
            model.put("canonicalSpn", "HTTP/" + aRecord);
        }
        if (this.kerbConfManager.isKeytabConfigured()) {
            Keytab keytab = new Keytab(this.kerbConfManager.getKeytabInfos());
            model.put("keytab", keytab);
        }
        this.renderer.render("templates/atlaskerb/fetch.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse resp) throws IOException {
        MultipartHttpRequest req = this.getMultipartRequest(request, 100000L);
        Map<String, Object> model = this.newModel((HttpServletRequest)req);
        model.put("menuItem", "keytab");
        if (req.getParameter("connect") != null) {
            this.testConnection(req, model);
            this.render((HttpServletRequest)req, resp, model);
            return;
        }
        if (req.getParameter("genkeys") != null) {
            this.generateKeys(req, resp, model);
            this.render((HttpServletRequest)req, resp, model);
            return;
        }
        if (req.getParameter("importkeys") != null) {
            List<KerberosKey> kerberosKeys = this.generateKeys(req, resp, this.newModel((HttpServletRequest)req));
            if (kerberosKeys != null && !kerberosKeys.isEmpty()) {
                KeytabReader keytabParser = new KeytabReader();
                LinkedHashMap<String, KeytabEntry> entries = new LinkedHashMap<String, KeytabEntry>();
                boolean merge = "merge".equals(req.getParameter("replace_or_merge"));
                boolean existedBeforeUpload = this.kerbConfManager.isKeytabUploaded();
                if (merge && existedBeforeUpload) {
                    for (KeytabEntry keytabEntry : keytabParser.read(this.kerbConfManager.getKeytabFile())) {
                        entries.put(keytabEntry.getEntryKey(), keytabEntry);
                    }
                }
                int time = (int)(System.currentTimeMillis() / 1000L);
                for (KerberosKey kerberosKey : kerberosKeys) {
                    PrincipalName name = PrincipalName.parse(kerberosKey.getPrincipal().getName(), kerberosKey.getPrincipal().getNameType());
                    KeytabEntry entry = new KeytabEntry(name, time, kerberosKey.getVersionNumber(), kerberosKey.getKeyType(), kerberosKey.getEncoded());
                    entries.put(entry.getEntryKey(), entry);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                keytabParser.write(new ArrayList<KeytabEntry>(entries.values()), byteArrayOutputStream);
                this.kerbConfManager.setKeytabContent(byteArrayOutputStream.toByteArray());
                this.kerbConfManager.flushKeytabCaches();
                String configUrl = "test?keytab";
                if (existedBeforeUpload) {
                    configUrl = "keytab?purge";
                }
                resp.sendRedirect(configUrl);
            }
            return;
        }
        resp.sendRedirect("keytab?purge");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(MultipartHttpRequest req, Map<String, Object> model) {
        String serviceAccount = req.getParameter("serviceAccount").trim();
        String serviceAccountPassword = req.getParameter("serviceAccountPassword").trim();
        String directory = req.getParameter("directory");
        String adServer = req.getParameter("adServer");
        if (adServer != null) {
            adServer = adServer.trim();
        }
        this.copyConnectionAttrs(model, serviceAccount, serviceAccountPassword, directory, adServer);
        HashMap<String, Boolean> errors = new HashMap<String, Boolean>();
        if (serviceAccount.isEmpty()) {
            errors.put("serviceAccountRequired", true);
        }
        if (serviceAccountPassword.isEmpty()) {
            errors.put("passwordRequired", true);
        }
        if ("custom".equals(directory) && (adServer == null || adServer.isEmpty())) {
            errors.put("adServerRequired", true);
        }
        if (!errors.isEmpty()) {
            model.putAll(errors);
            return;
        }
        String ldapServerUrl = this.getKdc(directory, SetupAction.addLdapProtocol(adServer));
        InitialDirContext context = null;
        try {
            List<LdapTestResult> accountsForAccountName;
            context = this.getContext(serviceAccount, serviceAccountPassword, ldapServerUrl);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Attributes rootAttrs = context.search("", "(objectClass=*)", sc).next().getAttributes();
            String defaultNamingContext = (String)rootAttrs.get("defaultNamingContext").get();
            String samAccountName = serviceAccount;
            if (serviceAccount.contains("@")) {
                samAccountName = samAccountName.substring(0, samAccountName.indexOf("@"));
            }
            if ((accountsForAccountName = this.ldapPrincipalSearcher.findAccountsForAccountName(context, defaultNamingContext, samAccountName, this.kerbConfManager.isLdapFilterEncoding())).isEmpty()) {
                throw new IllegalArgumentException("Unknown service account");
            }
            LdapTestResult ldapTestResult = accountsForAccountName.get(0);
            Set<String> servicePrincipalNames = ldapTestResult.getServicePrincipalAliases();
            if (servicePrincipalNames.isEmpty()) {
                model.put("missingServicePrincipalNames", true);
                return;
            }
            model.put("servicePrincipalNames", servicePrincipalNames);
            TestKerberosAction.checkMaxKeyLength(model);
            model.put("availableEncTypes", Arrays.asList(EncryptionType.byEncType(18), EncryptionType.byEncType(17), EncryptionType.byEncType(23)));
            HashSet supportedEncryptionTypes = new HashSet();
            model.put("strongestEncryptionType", supportedEncryptionTypes);
            model.put("strongestEncryptionType", ldapTestResult.getStrongestEncryptionType());
        }
        catch (CommunicationException e) {
            model.put("communicationException", e);
        }
        catch (AuthenticationException e) {
            model.put("authenticationException", e);
        }
        catch (NamingException e) {
            model.put("namingException", e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static List<UserDirWithAccount> guessServiceAccounts(HttpServletRequest req, AtlDirectoryManager directoryManager, Map<String, Object> model, LdapPrincipalSearcher ldapPrincipalSearcher, List<DomainDirectory> directories) {
        TestKerberosAction.checkDns(model, req);
        String aRecord = (String)model.get("aRecord");
        ArrayList<UserDirWithAccount> result = new ArrayList<UserDirWithAccount>();
        for (DomainDirectory directory : directories) {
            result.add(new UserDirWithAccount(directory, FetchKeysAction.getServiceAccount(directory, directoryManager, ldapPrincipalSearcher, aRecord)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServiceAccount(DomainDirectory directory, AtlDirectoryManager directoryManager, LdapPrincipalSearcher ldapPrincipalSearcher, String aRecord) {
        block17: {
            if (aRecord == null) {
                return null;
            }
            Context context = null;
            try {
                List<LdapTestResult> accounts;
                Hashtable<String, String> env = directoryManager.getEnvForDirectory(directory.getDirectory());
                context = new InitialDirContext(env);
                String defaultNamingContext = directory.getDefaultNamingContext();
                if (defaultNamingContext == null) {
                    log.debug("No defaultNamingContext for directory '{}': Falling back to search base \"\". Attribute may be missing from RootDSE, or dir user doesn't have read access.", (Object)directory.getDirectory().getName());
                    defaultNamingContext = "";
                }
                if ((accounts = ldapPrincipalSearcher.findAccountsForSpn((DirContext)context, defaultNamingContext, "HTTP/" + aRecord, true)).size() == 1) {
                    String spn;
                    String string = spn = accounts.get(0).getServicePrincipalUsername() + "@" + directory.getRealm();
                    return string;
                }
            }
            catch (NamingException e) {
                if (context == null) break block17;
                try {
                    context.close();
                }
                catch (NamingException e2) {
                    throw new RuntimeException(e2);
                }
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KerberosKey> generateKeys(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        String serviceAccount = req.getParameter("serviceAccount");
        String serviceAccountPassword = req.getParameter("serviceAccountPassword");
        String directory = req.getParameter("directory");
        String adServer = req.getParameter("adServer");
        this.copyConnectionAttrs(model, serviceAccount, serviceAccountPassword, directory, adServer);
        String ldapServerUrl = this.getKdc(directory, SetupAction.addLdapProtocol(adServer));
        model.put("keytabUploaded", this.kerbConfManager.isKeytabUploaded());
        if (this.kerbConfManager.isKeytabConfigured()) {
            Keytab keytab = new Keytab(this.kerbConfManager.getKeytabInfos());
            model.put("keytab", keytab);
        }
        String realm = serviceAccount.substring(serviceAccount.indexOf("@"));
        InitialDirContext context = null;
        try {
            List<LdapTestResult> accountsForAccountName;
            context = this.getContext(serviceAccount, serviceAccountPassword, ldapServerUrl);
            String actualPassword = (String)context.getEnvironment().get("java.naming.security.credentials");
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Attributes rootAttrs = context.search("", "(objectClass=*)", sc).next().getAttributes();
            String defaultNamingContext = (String)rootAttrs.get("defaultNamingContext").get();
            String samAccountName = serviceAccount;
            if (serviceAccount.contains("@")) {
                samAccountName = samAccountName.substring(0, samAccountName.indexOf("@"));
            }
            if ((accountsForAccountName = this.ldapPrincipalSearcher.findAccountsForAccountName(context, defaultNamingContext, samAccountName, this.kerbConfManager.isLdapFilterEncoding())).isEmpty()) {
                throw new IllegalArgumentException("Unknown service account");
            }
            LdapTestResult ldapTestResult = accountsForAccountName.get(0);
            ArrayList<String> spns = new ArrayList<String>();
            for (String spn : ldapTestResult.getServicePrincipalAliases()) {
                if (req.getParameter("spn_" + spn) == null) continue;
                spns.add(spn);
            }
            ArrayList<KerberosKey> keys = new ArrayList<KerberosKey>();
            HashMap<Integer, EncryptionType> keytypes = new HashMap<Integer, EncryptionType>();
            ArrayList<EncryptionType> enctypes = new ArrayList<EncryptionType>();
            model.put("keytypes", keytypes);
            for (EncryptionType type : EncryptionType.getKnownEncryptionTypes()) {
                keytypes.put(type.getEnctype(), type);
                if (req.getParameter("enctype_" + type.getName()) == null) continue;
                enctypes.add(type);
            }
            Map<Integer, byte[]> keyBytes = this.generateKeyBytes(enctypes, ldapTestResult.getUserPrincipalName(), actualPassword.toCharArray());
            for (String spn : spns) {
                for (EncryptionType type : enctypes) {
                    byte[] key = keyBytes.get(type.getEnctype());
                    keys.add(new KerberosKey(new KerberosPrincipal(spn + "@" + realm), key, type.getEnctype(), ldapTestResult.getLdapKeyVersionNumber()));
                }
            }
            model.put("enctypes", enctypes);
            model.put("spns", spns);
            model.put("keys", keys);
            ArrayList<KerberosKey> arrayList = keys;
            return arrayList;
        }
        catch (NamingException e) {
            this.render((HttpServletRequest)req, resp, model);
            List<KerberosKey> list = null;
            return list;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Map<Integer, byte[]> generateKeyBytes(List<EncryptionType> enctypes, String userPrincipalName, char[] password) {
        HashMap<Integer, byte[]> result = new HashMap<Integer, byte[]>();
        for (EncryptionType enctype : enctypes) {
            byte[] bytes = new KerberosKey(new KerberosPrincipal(userPrincipalName), password, enctype.getKerberosKeyName()).getEncoded();
            result.put(enctype.getEnctype(), bytes);
        }
        return result;
    }

    private void copyConnectionAttrs(Map<String, Object> model, String serviceAccount, String serviceAccountPassword, String directory, String adServer) {
        model.put("serviceAccount", serviceAccount);
        model.put("serviceAccountPassword", serviceAccountPassword);
        model.put("directory", directory);
        model.put("adServer", adServer);
    }

    @NotNull
    private InitialDirContext getContext(String serviceAccount, String serviceAccountPassword, String ldapServerUrl) throws NamingException {
        try {
            return new InitialDirContext(this.directoryManager.getLdapEnv(ldapServerUrl, serviceAccount, serviceAccountPassword));
        }
        catch (AuthenticationException e) {
            return new InitialDirContext(this.directoryManager.getLdapEnv(ldapServerUrl, serviceAccount, serviceAccountPassword + "\n"));
        }
    }

    private String getKdc(String directory, String adServerUrl) {
        if ("custom".equals(directory)) {
            return adServerUrl;
        }
        if (directory != null) {
            long directoryId = Long.parseLong(directory);
            for (DomainDirectory domainDirectory : this.directoryManager.getActiveMsAdDirectories()) {
                if (domainDirectory.getDirectory().getId() != directoryId) continue;
                return (String)domainDirectory.getDirectory().getAttributes().get("ldap.url");
            }
        }
        return adServerUrl;
    }

    public static class UserDirWithAccount {
        private final DomainDirectory directory;
        private final String serviceAccount;

        public UserDirWithAccount(DomainDirectory directory, String serviceAccount) {
            this.directory = directory;
            this.serviceAccount = serviceAccount;
        }

        public DomainDirectory getDirectory() {
            return this.directory;
        }

        public String getServiceAccount() {
            return this.serviceAccount;
        }
    }
}

