/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class SsoProtectedAnonymousBrowsingServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;

    public SsoProtectedAnonymousBrowsingServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.idpConfManager = bucket.getIdpConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean correctFormAction = StringUtils.equals((CharSequence)"setAuthenticatedAnonymousBrowsing", (CharSequence)req.getParameter("action"));
        boolean toggleEnabled = StringUtils.equals((CharSequence)"on", (CharSequence)req.getParameter("authenticatedAnonymousBrowsing"));
        this.idpConfManager.findIdentityProviderByIdFromPath(req).filter(_idp -> correctFormAction).map(IdpConfigurationBuilder::ofGeneric).map(builder -> builder.setAuthenticatedAnonymousBrowsingEnabled(toggleEnabled)).map(builder -> (IdpConfigurationBuilder)builder).map(IdpConfigurationBuilder::build).peek(this.idpConfManager::updateIdpConfiguration);
        resp.sendRedirect("authenticated-anonymous-browsing");
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        Option<IdpConfiguration> maybeIdpConfiguration = this.idpConfManager.findIdentityProviderByIdFromPath(req);
        maybeIdpConfiguration.peek(idpConfiguration -> {
            model.put("topMenu", "SAML");
            model.put("menuItem", "authenticatedAnonymousBrowsing");
            model.putIfAbsent("displayName", this.applicationProperties.getDisplayName());
            model.put("infoJitCreateTurnedOn", idpConfiguration.getUserNotFoundPolicy().equals((Object)IdpConfiguration.UserNotFoundPolicy.CREATE));
            model.put("isAuthenticatedAnonymousBrowsingEnabled", idpConfiguration.isSsoProtectedAnonymousBrowsingEnabled());
            model.put("idp", idpConfiguration);
        });
        this.hostApp.getAnonymousBrowsingSettingsUrl().map(relativePath -> this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE) + relativePath).peek(_url -> model.put("hostAppSupportsAnonymousBrowsing", true)).peek(url -> model.put("anonymousBrowsingSettingsUrl", url));
        if (maybeIdpConfiguration.isEmpty()) {
            resp.sendError(404);
        }
        this.renderer.render("templates/saml/authenticated-anonymous-browsing.vm", model, (Writer)resp.getWriter());
    }
}

