/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.rest.resource.api.idp;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.rest.resource.api.idp.model.IdpInfoDto;
import org.kantega.atlaskerb.rest.util.ResponseUtils;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="idp")
public class IdpConfigResource {
    private final Logger log = LoggerFactory.getLogger(IdpConfigResource.class);
    private final IdpConfManager idpConfManager;
    private final UserManager userManager;

    public IdpConfigResource(IdpConfManager idpConfManager, @ComponentImport UserManager userManager) {
        this.idpConfManager = idpConfManager;
        this.userManager = userManager;
    }

    @GET
    @Path(value="/ids")
    @Produces(value={"application/json"})
    @ResponseType(value=List.class, genericTypes={IdpInfoDto.class})
    public Response getAllIdpIds(@Context HttpServletRequest request) {
        return ResponseUtils.sysadminOnly(request, this.userManager).wrap((CheckedFunction1<UserProfile, Response>)(CheckedFunction1 & Serializable)_u -> {
            Collection<IdpConfiguration> identityProviders = this.idpConfManager.getIdentityProviders();
            List idpIds = identityProviders.stream().map(idpConfiguration -> new IdpInfoDto(idpConfiguration.getId(), idpConfiguration.getName())).collect(Collectors.toList());
            this.log.debug("getAllIdpIds -> Found {} idp ids", (Object)idpIds.size());
            return Response.ok(idpIds).build();
        });
    }
}

