/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.kantega.atlaskerb.security.XmlSecurity;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Component
public class PluginKey {
    private static final String key;
    private static final String version;

    public static String getPluginKey() {
        return key;
    }

    public static String getVersion() {
        return version;
    }

    static {
        try (InputStream stream = PluginKey.class.getResourceAsStream("/atlassian-plugin.xml");
             InputStream pluginStream = PluginKey.class.getResourceAsStream("/META-INF/maven/no.kantega.kerberosauth/kerberosauth-plugin/pom.properties");){
            Document doc = XmlSecurity.secureDocumentBuilder().parse(stream);
            key = doc.getDocumentElement().getAttribute("key");
            Properties props = new Properties();
            props.load(pluginStream);
            version = props.getProperty("version");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

