/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;

public class DirectoryUserAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private final ScimConfManager scimConfManager;

    @Inject
    public DirectoryUserAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        String tenantId = req.getParameter("tenantId");
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        ScimDirectory scimDirectory = (ScimDirectory)maybeDirectory.get();
        model.put("topMenu", "connectors");
        model.put("menuItem", "directoryUsers");
        model.put("displayName", this.applicationProperties.getDisplayName());
        String username = req.getParameter("username");
        model.put("username", username);
        this.render(scimDirectory, username, resp, model);
    }

    private void render(ScimDirectory scimDirectory, String username, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        try {
            Directory dir = scimDirectory.getDirectory();
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(0).returningAtMost(-1);
            List groupNames = directoryManager.searchNestedGroupRelationships(dir.getId().longValue(), membershipQuery);
            List userGroups = groupNames.stream().map(groupName -> {
                try {
                    return directoryManager.findGroupByName(dir.getId().longValue(), groupName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            model.put("groups", userGroups);
            UserWithAttributes user = directoryManager.findUserWithAttributesByName(dir.getId().longValue(), username);
            model.put("currentScimDirectory", scimDirectory);
            model.put("userAccount", user);
            model.put("uid", this.getUid(user));
            model.put("created", this.getCreated(user));
            model.put("lastModified", this.getLastModified(user));
            model.put("isActive", user.isActive());
            model.put("dateTool", new DateTool());
            resp.setContentType("text/html");
            resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.renderer.render("templates/atlaskerb/scim/user-details.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
        catch (UserNotFoundException e) {
            resp.sendError(404, "No such user found");
        }
    }

    private String getUid(UserWithAttributes user) {
        return user.getValue("ksso.scim.id");
    }

    private Date getCreated(UserWithAttributes user) {
        return (Date)Option.of((Object)user.getValue("ksso.scim.created")).map(v -> new Date(Long.parseLong(v))).getOrElse((Object)new Date(0L));
    }

    private Date getLastModified(UserWithAttributes user) {
        return (Date)Option.of((Object)user.getValue("ksso.scim.lastModified")).map(v -> new Date(Long.parseLong(v))).getOrElse((Object)new Date(0L));
    }
}

