/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.kerberos.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.kerberos.servlet.IdpConfigureUserAgentRestrictionsAction;

public class ConfigureUserAgentRestrictionsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public ConfigureUserAgentRestrictionsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("restrictionList", this.kerbConfManager.getCustomDisabledUserAgents());
        model.put("defaultDisabledUserAgents", this.kerbConfManager.getDefaultDisabledUserAgents());
        model.put("lastTenUserAgents", IdpConfigureUserAgentRestrictionsAction.lastUserAgents);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/useragent_restrict.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String removeUserAgent;
        String addUserAgent = req.getParameter("addUserAgent");
        if (StringUtils.isNotBlank((CharSequence)addUserAgent)) {
            addUserAgent = addUserAgent.trim();
            this.kerbConfManager.addCustomDisabledUserAgent(addUserAgent);
        }
        if (StringUtils.isNotBlank((CharSequence)(removeUserAgent = req.getParameter("removeUserAgent")))) {
            this.kerbConfManager.removeCustomDisabledUserAgent(removeUserAgent);
        }
        resp.sendRedirect("useragentrestrict");
    }
}

