/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Function2;
import io.vavr.Predicates;
import io.vavr.collection.CharSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetAddressUtils {
    private static final Logger log = LoggerFactory.getLogger(InternetAddressUtils.class);
    static final String OLD_IP_ADDRESS_PREFIX_MATCH = "^(?:\\d{1,3}[.]?)|(?:\\d{1,3}[.]\\d{1,3}[.]?)|(?:(\\d{1,3}[.]){2}\\d{1,3}[.]?)$";
    static final String FULL_IPV4_ADDRESS_MATCH = "^(?:\\d{1,3}[.]){3}\\d{1,3}$";
    private static final Pattern IPv4_CIDR_PATTERN;
    private static final Pattern IPV6_RECOGNIZE_PATTERN;
    private final Function2<String, String, Boolean> isAddressPermittedCachedFunction = isAddressPermitted.memoized();
    static InetAddressValidator inetAddressValidator;
    static DomainValidator domainValidator;
    static final Predicate<CharSeq> isKssoVersion4IpAddressPrefixNotation;
    private static final Predicate<CharSeq> isValidIpv4OrCidrPattern;
    static final Predicate<CharSeq> isMatchingIpv6Pattern;
    static final Predicate<CharSeq> isKssoVersion4Regex;
    static final Predicate<CharSeq> isFullIpv4AddressPattern;
    static final Predicate<CharSeq> lookupIfValidInternetAddress;
    static final Predicate<CharSeq> isValidInet4Address;
    static final Predicate<CharSeq> isEmpty;
    static final Predicate<CharSeq> isValidPermissionCorrectFormat;
    private static final Function2<String, String, Boolean> isAddressPermitted;

    @NotNull
    private static Predicate<CharSeq> isValidHostname() {
        return hostname -> domainValidator.isValid(String.valueOf(hostname));
    }

    public static boolean isNotValidPermission(String permission) {
        return !isValidPermissionCorrectFormat.test(CharSeq.of((CharSequence)permission));
    }

    public static boolean isValidPermission(String permission) {
        return isValidPermissionCorrectFormat.test(CharSeq.of((CharSequence)permission));
    }

    public static boolean isValidIpCidrPattern(String permission) {
        return isValidIpv4OrCidrPattern.test(CharSeq.of((CharSequence)permission));
    }

    public static boolean isValidPermissionList(String permissionList) {
        if (StringUtils.isBlank((CharSequence)permissionList)) {
            return true;
        }
        Predicate<Seq> isValidPermissionList = pList -> pList.forAll(isValidPermissionCorrectFormat);
        return isValidPermissionList.test(ListParseUtils.parseFromNewlines(permissionList));
    }

    private static Either<String, String> transformIpRestrictionToVersion_6_20_Format(String oldIpRestriction) {
        return (Either)API.Match((Object)CharSeq.of((CharSequence)oldIpRestriction)).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(isFullIpv4AddressPattern), InternetAddressUtils.normalizeIpv4AddressWithLeadingZeroes(oldIpRestriction)), API.Case((API.Match.Pattern0)API.$(isValidIpv4OrCidrPattern), InternetAddressUtils.normalizeIpv4CidrAddressWithLeadingZeroes(oldIpRestriction)), API.Case((API.Match.Pattern0)API.$(), () -> Either.right((Object)oldIpRestriction))});
    }

    private static Either<String, CharSeq> transformIpRestrictionToVersion_6_20_Format(CharSeq oldIpRestriction) {
        return (Either)API.Match((Object)oldIpRestriction).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(isFullIpv4AddressPattern), InternetAddressUtils.normalizeIpv4AddressWithLeadingZeroes(oldIpRestriction)), API.Case((API.Match.Pattern0)API.$(isValidIpv4OrCidrPattern), InternetAddressUtils.normalizeIpv4CidrAddressWithLeadingZeroes(oldIpRestriction)), API.Case((API.Match.Pattern0)API.$(), () -> Either.right((Object)oldIpRestriction))});
    }

    public static boolean isAddressPermissionMatch(String addressExpression, String[] permissionListArray) {
        return InternetAddressUtils.isAddressPermissionMatch(addressExpression, ListParseUtils.arrayToStringWithNewlines(permissionListArray));
    }

    public static Function2<String, String, Boolean> getIsAddressPermittedFunction() {
        return isAddressPermitted;
    }

    public static boolean isAddressPermissionMatch(String adr, String permissions) {
        return (Boolean)isAddressPermitted.apply((Object)adr, (Object)permissions);
    }

    public boolean isAddressPermitted(String adr, String permissions) {
        return (Boolean)this.isAddressPermittedCachedFunction.apply((Object)adr, (Object)permissions);
    }

    public static Either<String, CharSeq> normalizeIpv4CidrAddressWithLeadingZeroes(CharSeq address) {
        return Option.of((Object)address).filter(StringUtils::isNotBlank).toEither((Object)"IP Address must not be null").flatMap(a -> InternetAddressUtils.normalizeIpv4CidrAddressWithLeadingZeroes(String.valueOf(a))).map(CharSeq::of);
    }

    public static Either<String, String> normalizeIpv4CidrAddressWithLeadingZeroes(String ipAddress) {
        return Option.of((Object)ipAddress).filter(StringUtils::isNotBlank).map(adr -> adr.split("/")).toEither((Object)String.format("Could not transform IP address %s to new format.", ipAddress)).flatMap(cidrSplit -> InternetAddressUtils.normalizeIpv4AddressWithLeadingZeroes(cidrSplit[0]).map(adr -> ((String[])cidrSplit).length > 1 ? adr + "/" : adr).map(adr -> ((String[])cidrSplit).length > 1 ? adr + Integer.parseInt(cidrSplit[1]) : adr));
    }

    public static String softNormalizeIpRestrictions(String newlineSeparatedIpRestrictions) {
        return (String)Option.of((Object)newlineSeparatedIpRestrictions).filter(StringUtils::isNotBlank).map(restrictions -> ListParseUtils.parseListFromNewlines(restrictions).map(ipRestriction -> new IpRestrictionConversionResult((String)ipRestriction, (Either<String, String>)InternetAddressUtils.transformIpRestrictionToVersion_6_20_Format(ipRestriction).flatMap(x$0 -> Versioning.validConvertedV6_20PermissionOrErrorMessage(x$0)))).toList()).map(restrictions -> restrictions.map(result -> (String)((IpRestrictionConversionResult)result).maybeConvertedRestriction.getOrElse((Object)((IpRestrictionConversionResult)result).originalIpRestriction))).map(ListParseUtils::listToStringWithNewlines).getOrElse((Object)"");
    }

    public static Either<String, CharSeq> normalizeIpv4AddressWithLeadingZeroes(CharSeq ipAddress) {
        return Option.of((Object)ipAddress).filter(StringUtils::isNotBlank).toEither((Object)"IP Address must not be null").flatMap(a -> InternetAddressUtils.normalizeIpv4AddressWithLeadingZeroes(String.valueOf(a))).map(CharSeq::of);
    }

    public static Either<String, String> normalizeIpv4AddressWithLeadingZeroes(String ipAddress) {
        return Option.of((Object)ipAddress).filter(StringUtils::isNotBlank).toTry().mapTry((CheckedFunction1 & Serializable)adr -> (String)List.of((Object[])adr.split("\\.")).map(Integer::parseInt).map(String::valueOf).intersperse((Object)".").foldLeft((Object)"", String::concat)).toEither((Object)String.format("Could not transform IP address %s to new format.", ipAddress));
    }

    static {
        String ipv6Pattern = "^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$";
        IPV6_RECOGNIZE_PATTERN = Pattern.compile(ipv6Pattern);
        String ipv4Part = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
        String ipv4Regex = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
        String ipCidrRegex = "(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\/((0)?[0-9]|[1-2][0-9]|3[0-2]))?";
        String patternString = "(\\^)?(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\/((0)?[0-9]|[1-2][0-9]|3[0-2]))?(\\$)?";
        IPv4_CIDR_PATTERN = Pattern.compile(patternString);
        inetAddressValidator = InetAddressValidator.getInstance();
        domainValidator = DomainValidator.getInstance((boolean)true);
        isKssoVersion4IpAddressPrefixNotation = ipAddressPrefixNotation -> ipAddressPrefixNotation.matches(OLD_IP_ADDRESS_PREFIX_MATCH);
        isValidIpv4OrCidrPattern = ip -> IPv4_CIDR_PATTERN.matcher((CharSequence)ip).matches();
        isMatchingIpv6Pattern = ip -> IPV6_RECOGNIZE_PATTERN.matcher((CharSequence)ip).matches();
        isKssoVersion4Regex = KssoStringUtils.isPrefixedRegex.and(KssoStringUtils.isCompilingRegex);
        isFullIpv4AddressPattern = ipAddress -> CharSeq.of((CharSequence)ipAddress).matches(FULL_IPV4_ADDRESS_MATCH);
        lookupIfValidInternetAddress = cs -> Try.of((CheckedFunction0 & Serializable)() -> {
            log.debug("InternetAddressUtils isValidInternetAddress: {}", (Object)String.valueOf(cs));
            return InetAddress.getByName(String.valueOf(cs));
        }).isSuccess();
        isValidInet4Address = cs -> inetAddressValidator.isValidInet4Address(String.valueOf(cs));
        isEmpty = CharSeq::isEmpty;
        isValidPermissionCorrectFormat = charSeq -> isEmpty.test((CharSeq)charSeq) || isValidIpv4OrCidrPattern.test((CharSeq)charSeq) || KssoStringUtils.isValidPrefixAndSuffixRegex.test((CharSeq)charSeq) || isValidInet4Address.test((CharSeq)charSeq) || InternetAddressUtils.isValidHostname().test((CharSeq)charSeq) && lookupIfValidInternetAddress.test((CharSeq)charSeq) || isMatchingIpv6Pattern.test((CharSeq)charSeq) && lookupIfValidInternetAddress.test((CharSeq)charSeq);
        isAddressPermitted = (Function2 & Serializable)(adr, permissions) -> {
            Seq<CharSeq> permissionList = ListParseUtils.parseFromNewlines(permissions);
            CharSeq address = CharSeq.of((CharSequence)adr).trim();
            Predicate<CharSeq> isRegexMatch = regexPermission -> CharSeq.of((CharSequence)address).matches(regexPermission.mkString());
            Predicate isValidRegexMatch = Predicates.allOf((Predicate[])new Predicate[]{KssoStringUtils.isValidPrefixAndSuffixRegex, isRegexMatch});
            Predicate<CharSeq> isInternetAddressMatch = addressPermission -> addressPermission.contentEquals((CharSequence)address);
            Predicate isValidInternetAddressMatch = Predicates.allOf((Predicate[])new Predicate[]{isValidInet4Address, isInternetAddressMatch});
            Predicate<CharSeq> isInetAddressNameResolutionMatch = hostnamePermission -> {
                try {
                    String permittedAddress = InetAddress.getByName(hostnamePermission.mkString()).getHostAddress();
                    return address.mkString().equals(permittedAddress);
                }
                catch (IOException e) {
                    return false;
                }
            };
            Predicate isValidIpv6AddressMatch = Predicates.allOf((Predicate[])new Predicate[]{isMatchingIpv6Pattern, isInetAddressNameResolutionMatch});
            Predicate isValidInternetHostnameMatch = Predicates.allOf((Predicate[])new Predicate[]{InternetAddressUtils.isValidHostname(), isInetAddressNameResolutionMatch});
            Predicate<CharSeq> isValidCidrMatch = cidrPermission -> (Boolean)Try.of((CheckedFunction0 & Serializable)() -> new SubnetUtils(cidrPermission.mkString()).getInfo().isInRange(adr)).getOrElse((Object)false);
            Predicate<Seq> isAnyValidMatch = css -> {
                for (CharSeq permission : css) {
                    if (isValidInternetAddressMatch.test(permission)) {
                        return true;
                    }
                    if (isValidCidrMatch.test(permission)) {
                        return true;
                    }
                    if (isValidRegexMatch.test(permission)) {
                        return true;
                    }
                    if (isValidIpv6AddressMatch.test(permission)) {
                        return true;
                    }
                    if (!isValidInternetHostnameMatch.test(permission)) continue;
                    return true;
                }
                return false;
            };
            return isAnyValidMatch.test(permissionList);
        };
    }

    public static class Versioning {
        private static final Function<CharSeq, CharSeq> transformVersion4PrefixNotationToVersion5Regex = ipRestriction -> (CharSeq)Versioning.extractPreV5ValuesThatMustBeTransformed(ipRestriction).filter(isKssoVersion4IpAddressPrefixNotation).map(oldPrefix -> oldPrefix.prepend(KssoStringUtils.StringLiteral.REGEX_PREFIX.character())).map(regex -> regex.replaceAll("\\.", "\\\\.")).map(regex -> regex.appendAll((Iterable)CharSeq.of((CharSequence)"[\\d\\.]*"))).map(regex -> regex.append(KssoStringUtils.StringLiteral.REGEX_SUFFIX.character())).getOrElse(ipRestriction);
        private static final Function<CharSeq, CharSeq> transformVersion4RegexToVersion5Regex = prefix -> (CharSeq)Versioning.extractPreV5ValuesThatMustBeTransformed(prefix).filter(isKssoVersion4Regex).map(oldRegex -> oldRegex.append(KssoStringUtils.StringLiteral.REGEX_SUFFIX.character())).getOrElse(prefix);

        private static Either<String, String> validConvertedV5PermissionOrErrorMessage(@Nonnull String oldFormatPermission) {
            return (Either)Try.of((CheckedFunction0 & Serializable)() -> CharSeq.of((CharSequence)oldFormatPermission)).filterTry(p -> KssoStringUtils.isValidPrefixAndSuffixRegex.or(isFullIpv4AddressPattern).or(isValidIpv4OrCidrPattern).or(InternetAddressUtils.isValidHostname()).test((CharSeq)p)).mapTry(CharSeq::mkString).fold(_throwable -> Either.left((Object)("[Could not convert invalid permission: '" + oldFormatPermission + "'. Must be changed manually.]")), Either::right);
        }

        private static Either<String, String> validConvertedV6_20PermissionOrErrorMessage(String transformedPermission) {
            return (Either)Try.of((CheckedFunction0 & Serializable)() -> CharSeq.of((CharSequence)transformedPermission)).filter(KssoStringUtils.isValidPrefixAndSuffixRegex.or(isValidIpv4OrCidrPattern).or(InternetAddressUtils.isValidHostname()).or(isMatchingIpv6Pattern)).mapTry(CharSeq::mkString).fold(_throwable -> Either.left((Object)("[Invalid IP permission after conversion: '" + transformedPermission + "'. Must be changed manually.]")), Either::right);
        }

        private static Stream<CharSeq> extractPreV5ValuesThatMustBeTransformed(CharSeq ipRestriction) {
            return Stream.of((Object)ipRestriction).filter(Predicates.not(KssoStringUtils.isValidPrefixAndSuffixRegex).and(Predicates.not(isFullIpv4AddressPattern)));
        }

        private static CharSeq transformToVersion5Format(CharSeq oldIpRestriction) {
            return (CharSeq)API.Match((Object)oldIpRestriction).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(isKssoVersion4IpAddressPrefixNotation), transformVersion4PrefixNotationToVersion5Regex), API.Case((API.Match.Pattern0)API.$(isKssoVersion4Regex), transformVersion4RegexToVersion5Regex), API.Case((API.Match.Pattern0)API.$(), () -> oldIpRestriction)});
        }

        public static List<Either<String, String>> convertOldIpRestrictionFormatToVersion5Format(String oldFormatIpRestrictions) {
            return (List)Option.of((Object)oldFormatIpRestrictions).filter(StringUtils::isNotBlank).map(restrictions -> ListParseUtils.parseFromNewlines(restrictions).map(Versioning::transformToVersion5Format).map(CharSeq::mkString).map(Versioning::validConvertedV5PermissionOrErrorMessage).toList()).getOrElse((Object)List.empty());
        }

        public static List<IpRestrictionConversionResult> convertV5IpRestrictionFormatToV6_20Format(String oldFormatIpRestrictions) {
            return (List)Option.of((Object)oldFormatIpRestrictions).filter(StringUtils::isNotBlank).map(restrictions -> ListParseUtils.parseListFromNewlines(restrictions).map(oldRestriction -> new IpRestrictionConversionResult((String)oldRestriction, (Either<String, String>)InternetAddressUtils.transformIpRestrictionToVersion_6_20_Format(oldRestriction).flatMap(Versioning::validConvertedV6_20PermissionOrErrorMessage))).toList()).getOrElse((Object)List.empty());
        }
    }

    public static class IpRestrictionConversionResult {
        private final String originalIpRestriction;
        private final Either<String, String> maybeConvertedRestriction;

        public IpRestrictionConversionResult(String originalIpRestriction, Either<String, String> maybeConvertedRestriction) {
            this.originalIpRestriction = originalIpRestriction;
            this.maybeConvertedRestriction = maybeConvertedRestriction;
        }

        public String getOriginalIpRestriction() {
            return this.originalIpRestriction;
        }

        public Either<String, String> getMaybeConvertedRestriction() {
            return this.maybeConvertedRestriction;
        }

        public IpRestrictionConversionResult flatMap(Function<String, Either<String, String>> mapper) {
            return new IpRestrictionConversionResult(this.originalIpRestriction, (Either<String, String>)this.maybeConvertedRestriction.flatMap(mapper));
        }
    }
}

